/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.generator.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.attrs.Attributes;
import org.objectweb.jorm.api.PBinding;
import org.objectweb.jorm.api.PBindingCtrl;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.JormCompilerConfigurator;
import org.objectweb.jorm.compiler.api.JormCompilerParameter;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.generator.lib.ClassInterfaceAdder;
import org.objectweb.jorm.generator.lib.ClassMergerVisitor;
import org.objectweb.jorm.generator.lib.ClassRenamer;
import org.objectweb.jorm.generator.lib.CommonGenerator;
import org.objectweb.jorm.generator.lib.RedundencyRemover;
import org.objectweb.jorm.lib.PBindingImpl;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.util.io.api.TargetHolder;
import org.objectweb.jorm.util.lib.StringReplace;
import org.objectweb.util.monolog.api.BasicLevel;

public class BindingGenerator
extends CommonGenerator {
    public void generate(Class clazz, TargetHolder holder, JormCompilerParameter cp, JormCompilerConfigurator jcc) throws PException {
        String extend = cp.getBindingInheritance();
        if (extend != null) {
            extend = BindingGenerator.getJVMClassName(extend);
        }
        boolean injectPBindingImpl = true;
        boolean newClass = true;
        String classToWrite = BindingGenerator.getJVMClassName(clazz.getFQName() + "Binding");
        if (extend == null) {
            if (cp.getBindingEnhancedClass() == null) {
                extend = BindingGenerator.getJVMClassName(PBindingImpl.class);
                injectPBindingImpl = false;
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Generate the class '" + classToWrite + "' extending PBindingImpl."));
                }
            } else {
                newClass = false;
                extend = BindingGenerator.getJVMClassName(Object.class);
                classToWrite = BindingGenerator.getJVMClassName(cp.getBindingEnhancedClass());
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Enhance the class '" + classToWrite + "'."));
                }
            }
        } else if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Generate the class '" + classToWrite + "' extending '" + extend + "'."));
        }
        ClassWriter cw = new ClassWriter(true);
        RedundencyRemover rr = new RedundencyRemover(cw, this.logger);
        HashSet<String> interfaces = new HashSet<String>();
        interfaces.add(BindingGenerator.getJVMClassName(PBinding.class));
        interfaces.add(BindingGenerator.getJVMClassName(PBindingCtrl.class));
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("interfaces: " + interfaces));
        }
        if (newClass) {
            cw.visit(196653, 1 + (cp.isBindingAbstract() ? 1024 : 0), classToWrite, extend, interfaces.toArray(new String[interfaces.size()]), classToWrite);
            CodeVisitor _cv = cw.visitMethod(1, "<init>", "()V", null, null);
            _cv.visitVarInsn(25, 0);
            _cv.visitMethodInsn(183, extend, "<init>", "()V");
            _cv.visitInsn(177);
            _cv.visitMaxs(0, 0);
        } else {
            ClassInterfaceAdder cia = new ClassInterfaceAdder(rr, interfaces, this.logger);
            ClassMergerVisitor cmv = new ClassMergerVisitor(cia, this.logger);
            ClassReader cr = this.loadJavaClass(classToWrite, holder, true);
            cr.accept(cmv, Attributes.getDefaultAttributes(), false);
        }
        if (injectPBindingImpl) {
            ClassMergerVisitor cmv = new ClassMergerVisitor(rr, this.logger);
            ClassReader cr = null;
            try {
                cr = new ClassReader(this.getClass().getClassLoader().getResourceAsStream(BindingGenerator.getJVMClassName(PBindingImpl.class) + ".class"));
            }
            catch (Exception e) {
                this.logger.log(BasicLevel.ERROR, (Object)e.getMessage(), (Throwable)e);
                throw new PException("Impossible to load the PBinding class, check your classpath");
            }
            HashSet<String> oldNames = new HashSet<String>();
            oldNames.add(BindingGenerator.getJVMClassName(PBindingImpl.class));
            ClassRenamer cren = new ClassRenamer(cmv, oldNames, classToWrite, this.logger);
            cr.accept(cren, Attributes.getDefaultAttributes(), false);
        }
        cw.visitEnd();
        try {
            String fileName = classToWrite;
            fileName = StringReplace.replaceChar((char)'/', (char)File.separatorChar, (String)fileName) + ".class";
            FileOutputStream fos = holder.getFileOutputStream(fileName);
            fos.write(cw.toByteArray());
            fos.close();
        }
        catch (Exception e) {
            throw new PExceptionCompiler(e, "Problem while generating PAccessor.");
        }
    }

    public ClassReader loadJavaClass(String completeName, TargetHolder holder, boolean remove) throws PException {
        ClassReader jclass = null;
        File f = holder.getFile(completeName.replace('.', File.separatorChar) + ".class");
        try {
            FileInputStream fis = new FileInputStream(f);
            jclass = new ClassReader(fis);
            fis.close();
            if (remove) {
                f.delete();
            }
        }
        catch (Exception e) {
            throw new PException(e);
        }
        return jclass;
    }
}

