/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.easybeans.ext;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.resource.ClassLoaderResolver;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.ow2.easybeans.api.EZBContainerCallbackInfo;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.bean.info.IWebServiceInfo;
import org.ow2.easybeans.container.EmptyLifeCycleCallBack;
import org.ow2.easybeans.container.session.stateless.StatelessSessionFactory;
import org.ow2.jonas.ws.cxf.BusCreator;
import org.ow2.jonas.ws.cxf.JOnASJaxWsImplementorInfo;
import org.ow2.jonas.ws.cxf.easybeans.CXFEJBWebserviceEndpoint;
import org.ow2.jonas.ws.cxf.easybeans.EasyBeansJaxWsServerFactoryBean;
import org.ow2.jonas.ws.cxf.easybeans.EasyBeansJaxWsServiceFactoryBean;
import org.ow2.jonas.ws.cxf.jaxws.WebservicesContainer;
import org.ow2.jonas.ws.jaxws.IWebservicesModule;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.jonas.ws.jaxws.base.JAXWSWebservicesModule;
import org.ow2.jonas.ws.jaxws.ejb.IWebDeployer;
import org.ow2.jonas.ws.jaxws.util.JAXWSClassUtils;
import org.ow2.jonas.ws.publish.WSDLPublisherException;
import org.ow2.jonas.ws.publish.WSDLPublisherManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifeCycleCallback
extends EmptyLifeCycleCallBack {
    private static Log logger = LogFactory.getLog(LifeCycleCallback.class);
    private WSDLPublisherManager publisherManager;
    private Map<String, IWebservicesModule<WebservicesContainer<CXFEJBWebserviceEndpoint>>> modules = new HashMap<String, IWebservicesModule<WebservicesContainer<CXFEJBWebserviceEndpoint>>>();
    private IWebDeployer webDeployer;
    private BusFactory factory;

    public void start(EZBContainerCallbackInfo info) {
        String name = info.getArchive().getName();
        IWebservicesModule<WebservicesContainer<CXFEJBWebserviceEndpoint>> module = null;
        Map factories = info.getFactories();
        for (Factory f : factories.values()) {
            String directory;
            WebservicesContainer<CXFEJBWebserviceEndpoint> container;
            JOnASJaxWsImplementorInfo jaxWsImplementorInfo;
            StatelessSessionFactory factory;
            Class klass;
            if (!(f instanceof StatelessSessionFactory) || !JAXWSClassUtils.isWebService((Class)(klass = (factory = (StatelessSessionFactory)f).getBeanClass()))) continue;
            IBeanInfo beanInfo = factory.getBeanInfo();
            IWebServiceInfo webServiceInfo = beanInfo.getWebServiceInfo();
            PortMetaData pmd = new PortMetaData();
            if (webServiceInfo != null) {
                jaxWsImplementorInfo = new JOnASJaxWsImplementorInfo(klass, webServiceInfo);
                pmd.setContextRoot(webServiceInfo.getContextRoot());
            } else {
                jaxWsImplementorInfo = new JOnASJaxWsImplementorInfo(klass);
            }
            module = this.modules.get(name);
            if (module == null) {
                module = this.createWebservicesModule(name);
                this.modules.put(name, module);
            }
            if ((container = (WebservicesContainer<CXFEJBWebserviceEndpoint>)module.findContainer(jaxWsImplementorInfo.getWsdlLocation())) == null) {
                container = this.createWebservicesContainer(jaxWsImplementorInfo.getWsdlLocation());
                module.addContainer(container);
                ResourceManager manager = (ResourceManager)container.getBus().getExtension(ResourceManager.class);
                manager.addResourceResolver((ResourceResolver)new ClassLoaderResolver(klass.getClassLoader()));
            }
            String pattern = this.getUrlPattern(klass, webServiceInfo, jaxWsImplementorInfo);
            pmd.setUrlPattern(pattern);
            EndpointImpl easybeansEndpoint = this.createEasyBeansEndpoint(factory, container, jaxWsImplementorInfo);
            CXFEJBWebserviceEndpoint endpoint = new CXFEJBWebserviceEndpoint(easybeansEndpoint, pmd, container, info.getContainer(), beanInfo);
            container.addEndpoint(endpoint);
            if (webServiceInfo == null || (directory = webServiceInfo.getWsdlPublicationDirectory()) == null) continue;
            container.setWsdlPublicationDirectory(directory);
        }
        if (module != null) {
            module.start();
            try {
                this.webDeployer.deploy(module);
                for (WebservicesContainer container : module.getContainers()) {
                    this.publishWSDL(container);
                    for (CXFEJBWebserviceEndpoint endpoint : container.getEndpoints()) {
                        endpoint.displayInfos();
                    }
                }
            }
            catch (WSException e) {
                logger.warn((Object)"Webservices endpoints of the EjbJar ''{0}'' cannot be deployed because of some error: {1}", new Object[]{info.getContainer().getName(), e.getMessage(), e});
                this.webDeployer.undeploy(module);
                this.stopWebservicesModule(module);
                this.modules.remove(name);
            }
        }
    }

    protected WebservicesContainer<CXFEJBWebserviceEndpoint> createWebservicesContainer(String name) {
        return new WebservicesContainer<CXFEJBWebserviceEndpoint>(name, this.factory);
    }

    protected JAXWSWebservicesModule<WebservicesContainer<CXFEJBWebserviceEndpoint>> createWebservicesModule(String name) {
        return new JAXWSWebservicesModule(name);
    }

    protected void checkEnableMtom(JaxWsServiceFactoryBean jaxWsServiceFactoryBean, JOnASJaxWsImplementorInfo info) {
        String protocolBinding;
        if (info == null) {
            return;
        }
        if (!info.isMTOMEnabled() || (protocolBinding = info.getBindingType()) == null || "http://schemas.xmlsoap.org/wsdl/soap/http".equals(protocolBinding) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(protocolBinding)) {
            // empty if block
        }
    }

    private String getUrlPattern(Class<?> klass, IWebServiceInfo webServiceInfo, JaxWsImplementorInfo jaxWsImplementorInfo) {
        String pattern;
        if (webServiceInfo != null && webServiceInfo.getEndpointAddress() != null) {
            pattern = webServiceInfo.getEndpointAddress();
            if (!pattern.startsWith("/")) {
                pattern = "/" + pattern;
            }
        } else {
            String serviceName = jaxWsImplementorInfo.getServiceName().getLocalPart();
            pattern = !"".equals(serviceName) ? "/" + serviceName : "/" + klass.getSimpleName() + "Service";
        }
        return pattern;
    }

    private void publishWSDL(WebservicesContainer container) {
        try {
            this.publisherManager.publish(container.getPublishableDefinitions());
        }
        catch (WSDLPublisherException e) {
            logger.error((Object)"Unable to publish WSDL for the container ''{0}''", new Object[]{container.getName(), e});
        }
    }

    private static String extractContextRoot(String filename) {
        String context = filename.substring(filename.lastIndexOf(File.separator) + 1);
        int underscoreIndex = context.indexOf(95);
        context = underscoreIndex == -1 ? context.substring(0, context.lastIndexOf(46)) : context.substring(0, underscoreIndex);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EndpointImpl createEasyBeansEndpoint(StatelessSessionFactory factory, WebservicesContainer<CXFEJBWebserviceEndpoint> container, JOnASJaxWsImplementorInfo info) {
        Bus bus = container.getBus();
        EasyBeansJaxWsServiceFactoryBean jaxWsServiceFactoryBean = new EasyBeansJaxWsServiceFactoryBean(info, factory);
        jaxWsServiceFactoryBean.setBus(bus);
        this.checkEnableMtom(jaxWsServiceFactoryBean, info);
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Bus.class.getClassLoader());
            jaxWsServiceFactoryBean.setServiceName(info.getServiceName());
            jaxWsServiceFactoryBean.create();
            Object var8_7 = null;
            Thread.currentThread().setContextClassLoader(old);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Thread.currentThread().setContextClassLoader(old);
            throw throwable;
        }
        EasyBeansJaxWsServerFactoryBean factoryBean = new EasyBeansJaxWsServerFactoryBean(jaxWsServiceFactoryBean, factory, container);
        EndpointImpl endpoint = new EndpointImpl(bus, (Object)factory.getBeanClass(), (JaxWsServerFactoryBean)factoryBean);
        endpoint.setImplementorClass(factory.getBeanClass());
        endpoint.setServiceFactory((JaxWsServiceFactoryBean)jaxWsServiceFactoryBean);
        HashMap<String, QName> properties = new HashMap<String, QName>();
        if (info.getServiceName() != null) {
            properties.put("javax.xml.ws.wsdl.service", info.getServiceName());
            endpoint.setServiceName(info.getServiceName());
        }
        if (info.getEndpointName() != null) {
            properties.put("javax.xml.ws.wsdl.port", info.getEndpointName());
            endpoint.setEndpointName(info.getEndpointName());
        }
        endpoint.setProperties(properties);
        Handler audit = (Handler)bus.getProperty(BusCreator.class.getName() + ".ENDPOINT");
        endpoint.getHandlers().add(audit);
        return endpoint;
    }

    public void stop(EZBContainerCallbackInfo info) {
        String name = info.getArchive().getName();
        IWebservicesModule<WebservicesContainer<CXFEJBWebserviceEndpoint>> module = this.modules.get(name);
        if (module != null) {
            this.stopWebservicesModule(module);
            this.modules.remove(name);
        }
    }

    public void stop() {
        logger.debug((Object)"Stop ''{0}''", new Object[]{this});
        for (Map.Entry<String, IWebservicesModule<WebservicesContainer<CXFEJBWebserviceEndpoint>>> entry : this.modules.entrySet()) {
            IWebservicesModule<WebservicesContainer<CXFEJBWebserviceEndpoint>> module = entry.getValue();
            this.stopWebservicesModule(module);
        }
        this.modules.clear();
    }

    private void stopWebservicesModule(IWebservicesModule<WebservicesContainer<CXFEJBWebserviceEndpoint>> module) {
        this.webDeployer.undeploy(module);
        module.stop();
    }

    public void setWSDLPublisherManager(WSDLPublisherManager publisherManager) {
        this.publisherManager = publisherManager;
    }

    public void setWebDeployer(IWebDeployer webDeployer) {
        this.webDeployer = webDeployer;
    }

    public void setBusFactory(BusFactory factory) {
        this.factory = factory;
    }
}

