/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.hibernate.ejb.internal.EntityManagerMessageLogger;
import org.hibernate.ejb.packaging.AbstractJarVisitor;
import org.hibernate.ejb.packaging.Filter;
import org.hibernate.ejb.packaging.JarVisitorFactory;
import org.jboss.logging.Logger;

public class FileZippedJarVisitor
extends AbstractJarVisitor {
    private static final EntityManagerMessageLogger LOG = Logger.getMessageLogger(EntityManagerMessageLogger.class, FileZippedJarVisitor.class.getName());
    private String entry;

    public FileZippedJarVisitor(String fileName, Filter[] filters) {
        super(fileName, filters);
    }

    public FileZippedJarVisitor(URL url, Filter[] filters, String entry) {
        super(url, filters);
        this.entry = entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProcessElements() throws IOException {
        JarFile jarFile;
        try {
            String filePart = this.jarUrl.getFile();
            jarFile = filePart != null && filePart.indexOf(32) != -1 ? new JarFile(this.jarUrl.getFile()) : new JarFile(this.jarUrl.toURI().getSchemeSpecificPart());
        }
        catch (IOException ze) {
            LOG.unableToFindFile(this.jarUrl, ze);
            return;
        }
        catch (URISyntaxException e) {
            LOG.malformedUrlWarning(this.jarUrl, e);
            return;
        }
        if (this.entry != null && this.entry.length() == 1) {
            this.entry = null;
        }
        if (this.entry != null && this.entry.startsWith("/")) {
            this.entry = this.entry.substring(1);
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = zipEntry.getName();
            if (this.entry != null && !name.startsWith(this.entry) || zipEntry.isDirectory()) continue;
            if (name.equals(this.entry)) {
                InputStream is = null;
                try {
                    is = new BufferedInputStream(jarFile.getInputStream(zipEntry));
                    JarInputStream jis = new JarInputStream(is);
                    ZipEntry subZipEntry = jis.getNextEntry();
                    while (subZipEntry != null) {
                        if (!subZipEntry.isDirectory()) {
                            byte[] entryBytes = JarVisitorFactory.getBytesFromInputStream(jis);
                            String subname = subZipEntry.getName();
                            if (subname.startsWith("/")) {
                                subname = subname.substring(1);
                            }
                            this.addElement(subname, new ByteArrayInputStream(entryBytes), new ByteArrayInputStream(entryBytes));
                        }
                        subZipEntry = jis.getNextEntry();
                    }
                    continue;
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                    continue;
                }
            }
            if (this.entry != null) {
                name = name.substring(this.entry.length());
            }
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            this.addElement(name, new BufferedInputStream(jarFile.getInputStream(zipEntry)), new BufferedInputStream(jarFile.getInputStream(zipEntry)));
        }
    }
}

