/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.util;

import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.ejb.internal.EntityManagerMessageLogger;
import org.hibernate.service.jndi.JndiException;
import org.hibernate.service.jndi.JndiNameException;
import org.hibernate.service.jndi.internal.JndiServiceImpl;
import org.jboss.logging.Logger;

public class NamingHelper {
    private static final EntityManagerMessageLogger LOG = Logger.getMessageLogger(EntityManagerMessageLogger.class, NamingHelper.class.getName());
    private static final NamespaceChangeListener LISTENER = new NamespaceChangeListener(){

        @Override
        public void objectAdded(NamingEvent evt) {
            LOG.debugf("An Ejb3Configuration was successfully bound to name: %s", (Object)evt.getNewBinding().getName());
        }

        @Override
        public void objectRemoved(NamingEvent evt) {
            String name = evt.getOldBinding().getName();
            LOG.ejb3ConfigurationUnboundFromName(name);
        }

        @Override
        public void objectRenamed(NamingEvent evt) {
            String name = evt.getOldBinding().getName();
            LOG.ejb3ConfigurationRenamedFromName(name);
        }

        @Override
        public void namingExceptionThrown(NamingExceptionEvent evt) {
            LOG.unableToAccessEjb3Configuration(evt.getException());
        }
    };

    private NamingHelper() {
    }

    public static void bind(Ejb3Configuration cfg) {
        String name = cfg.getHibernateConfiguration().getProperty("hibernate.ejb.configuration_jndi_name");
        if (name == null) {
            LOG.debug("No JNDI name configured for binding Ejb3Configuration");
        } else {
            LOG.ejb3ConfigurationName(name);
            JndiServiceImpl jndiService = new JndiServiceImpl(cfg.getProperties());
            try {
                jndiService.bind(name, cfg);
                LOG.boundEjb3ConfigurationToJndiName(name);
                try {
                    jndiService.addListener(name, LISTENER);
                }
                catch (Exception e) {
                    LOG.couldNotBindJndiListener();
                }
            }
            catch (JndiNameException e) {
                LOG.invalidJndiName(name, e);
            }
            catch (JndiException e) {
                LOG.unableToBindEjb3ConfigurationToJndi(e);
            }
        }
    }
}

