/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.util.List;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.jgroups.BackendMessage;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;

public class JGroupsMasterMessageListener
implements Receiver {
    private static final Log log = LoggerFactory.make();
    private SearchFactoryImplementor searchFactory;

    public JGroupsMasterMessageListener(SearchFactoryImplementor searchFactory) {
        this.searchFactory = searchFactory;
    }

    public void receive(Message message) {
        List<LuceneWork> queue;
        String indexName;
        try {
            BackendMessage decoded = (BackendMessage)message.getObject();
            indexName = decoded.indexName;
            IndexManager indexManager = this.searchFactory.getAllIndexesManager().getIndexManager(indexName);
            if (indexManager == null) {
                log.messageReceivedForUndefinedIndex(indexName);
                return;
            }
            queue = indexManager.getSerializer().toLuceneWorks(decoded.queue);
        }
        catch (ClassCastException e) {
            log.illegalObjectRetrievedFromMessage(e);
            return;
        }
        catch (SearchException e) {
            log.illegalObjectRetrievedFromMessage(e);
            return;
        }
        if (queue != null && !queue.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debugf("There are %d Lucene docs received from slave node %s to be processed by master", (Object)queue.size(), (Object)message.getSrc());
            }
            this.perform(indexName, queue);
        } else {
            log.receivedEmptyLuceneWOrksInMessage();
        }
    }

    private void perform(String indexName, List<LuceneWork> queue) {
        IndexManagerHolder allIndexesManager = this.searchFactory.getAllIndexesManager();
        IndexManager indexManager = allIndexesManager.getIndexManager(indexName);
        indexManager.performOperations(queue, null);
    }

    public byte[] getState() {
        return null;
    }

    public void setState(byte[] state) {
    }

    public void viewAccepted(View view) {
        log.jGroupsReceivedNewClusterView(view);
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }
}

