/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.util.Properties;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.backend.impl.lucene.NRTWorkspaceImpl;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.DirectoryBasedReaderProvider;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class NRTIndexManager
extends DirectoryBasedIndexManager {
    private static final Log log = LoggerFactory.make();
    private NRTWorkspaceImpl nrtWorkspace;

    @Override
    protected BackendQueueProcessor createBackend(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        String backend = cfg.getProperty("worker.backend");
        if (backend != null) {
            log.ignoringBackendOptionForIndex(indexName, "near-real-time");
        }
        LuceneBackendQueueProcessor backendQueueProcessor = new LuceneBackendQueueProcessor();
        this.nrtWorkspace = new NRTWorkspaceImpl(this, buildContext.getErrorHandler(), cfg);
        backendQueueProcessor.setCustomWorkspace(this.nrtWorkspace);
        backendQueueProcessor.initialize(cfg, buildContext, this);
        return backendQueueProcessor;
    }

    @Override
    protected DirectoryBasedReaderProvider createIndexReader(String indexName, Properties cfg, WorkerBuildContext buildContext) {
        return this.nrtWorkspace;
    }
}

