/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jmx.impl;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hibernate.search.SearchException;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class JMXRegistrar {
    private static final Log log = LoggerFactory.make();

    private JMXRegistrar() {
    }

    public static String registerMBean(Object object, String name) {
        ObjectName objectName = JMXRegistrar.createObjectName(name);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(object, objectName);
        }
        catch (Exception e) {
            throw new SearchException("Unable to enable MBean for Hibernate Search", e);
        }
        return objectName.toString();
    }

    public static void unRegisterMBean(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The object name cannot be null");
        }
        ObjectName objectName = JMXRegistrar.createObjectName(name);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (mbs.isRegistered(objectName)) {
            try {
                mbs.unregisterMBean(objectName);
            }
            catch (Exception e) {
                log.unableToUnregisterExistingMBean(name, e);
            }
        }
    }

    public static boolean isNameRegistered(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The object name cannot be null");
        }
        ObjectName objectName = JMXRegistrar.createObjectName(name);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        return mbs.isRegistered(objectName);
    }

    private static ObjectName createObjectName(String name) {
        ObjectName objectName;
        try {
            objectName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new SearchException("Invalid JMX Bean name: " + name, e);
        }
        return objectName;
    }
}

