/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.TimeoutManager;
import org.hibernate.search.query.hibernate.impl.ObjectsInitializer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class CriteriaObjectsInitializer
implements ObjectsInitializer {
    private static final Log log = LoggerFactory.make();
    private static final int MAX_IN_CLAUSE = 500;
    public static final CriteriaObjectsInitializer INSTANCE = new CriteriaObjectsInitializer();

    private CriteriaObjectsInitializer() {
    }

    @Override
    public void initializeObjects(EntityInfo[] entityInfos, Criteria criteria, Class<?> entityType, SearchFactoryImplementor searchFactoryImplementor, TimeoutManager timeoutManager, Session session) {
        Long timeLeftInSecond;
        boolean exact;
        int maxResults = entityInfos.length;
        log.tracef("Load %d objects using criteria queries", (Object)maxResults);
        if (maxResults == 0) {
            return;
        }
        if (criteria == null) {
            criteria = session.createCriteria(entityType);
        }
        Set<Class<?>> indexedEntities = searchFactoryImplementor.getIndexedTypesPolymorphic(new Class[]{entityType});
        DocumentBuilderIndexedEntity<?> builder = searchFactoryImplementor.getIndexBindingForEntity(indexedEntities.iterator().next()).getDocumentBuilder();
        String idName = builder.getIdentifierName();
        Disjunction disjunction = Restrictions.disjunction();
        int loop = maxResults / 500;
        boolean bl = exact = maxResults % 500 == 0;
        if (!exact) {
            ++loop;
        }
        for (int index = 0; index < loop; ++index) {
            int max = index * 500 + 500 <= maxResults ? index * 500 + 500 : maxResults;
            ArrayList<Serializable> ids = new ArrayList<Serializable>(max - index * 500);
            for (int entityInfoIndex = index * 500; entityInfoIndex < max; ++entityInfoIndex) {
                ids.add(entityInfos[entityInfoIndex].getId());
            }
            disjunction.add(Restrictions.in(idName, ids));
        }
        criteria.add(disjunction);
        if (timeoutManager.getType() != TimeoutManager.Type.LIMIT && (timeLeftInSecond = timeoutManager.getTimeoutLeftInSeconds()) != null) {
            if (timeLeftInSecond == 0L) {
                timeoutManager.reactOnQueryTimeoutExceptionWhileExtracting(null);
            }
            criteria.setTimeout(timeLeftInSecond.intValue());
        }
        criteria.list();
    }
}

