/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader.impl;

import org.apache.lucene.index.IndexReader;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.reader.impl.CacheableMultiReader;
import org.hibernate.search.reader.impl.ReaderProviderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class MultiReaderFactory {
    private static final Log log = LoggerFactory.make();

    public static IndexReader openReader(IndexManager ... indexManagers) {
        int length = indexManagers.length;
        IndexReader[] readers = new IndexReader[length];
        ReaderProvider[] managers = new ReaderProvider[length];
        for (int index = 0; index < length; ++index) {
            IndexReader openIndexReader;
            ReaderProvider indexReaderManager = indexManagers[index].getReaderProvider();
            readers[index] = openIndexReader = indexReaderManager.openIndexReader();
            managers[index] = indexReaderManager;
        }
        return ReaderProviderHelper.buildMultiReader(length, readers, managers);
    }

    public static void closeReader(IndexReader multiReader) {
        if (multiReader == null) {
            return;
        }
        if (!(multiReader instanceof CacheableMultiReader)) {
            throw new AssertionFailure("Everything should be wrapped in a CacheableMultiReader");
        }
        CacheableMultiReader castMultiReader = (CacheableMultiReader)multiReader;
        IndexReader[] readers = ReaderProviderHelper.getSubReadersFromMultiReader(castMultiReader);
        ReaderProvider[] managers = castMultiReader.managers;
        log.debugf("Closing MultiReader: %s", (Object)multiReader);
        for (int i = 0; i < readers.length; ++i) {
            ReaderProvider container = managers[i];
            container.closeIndexReader(readers[i]);
        }
        log.trace("IndexReader closed.");
    }
}

