/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.search.SearchException;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.reader.impl.CacheableMultiReader;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class ReaderProviderHelper {
    private static final Log log = LoggerFactory.make();
    private static final Field subReadersField = ReaderProviderHelper.getSubReadersField();

    private static Field getSubReadersField() {
        try {
            Field field = MultiReader.class.getDeclaredField("subReaders");
            ReflectionHelper.setAccessible(field);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new SearchException("Incompatible version of Lucene: MultiReader.subReaders not available", e);
        }
    }

    public static IndexReader[] getSubReadersFromMultiReader(MultiReader parentReader) {
        try {
            return (IndexReader[])subReadersField.get(parentReader);
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Incompatible version of Lucene: MultiReader.subReaders not accessible", e);
        }
    }

    public static IndexReader buildMultiReader(int length, IndexReader[] readers, ReaderProvider[] managers) {
        if (length == 0) {
            return null;
        }
        return new CacheableMultiReader(readers, managers);
    }

    public static void clean(SearchException e, IndexReader ... readers) {
        for (IndexReader reader : readers) {
            if (reader == null) continue;
            try {
                reader.close();
            }
            catch (IOException ee) {
                log.unableToCLoseLuceneIndexReader(e);
            }
        }
        throw e;
    }

    public static Set<IndexReader> getIndexReaders(IndexSearcher searchable) {
        HashSet<IndexReader> readers = new HashSet<IndexReader>();
        ReaderProviderHelper.getIndexReadersInternal(readers, searchable);
        return readers;
    }

    public static Set<IndexReader> getIndexReaders(IndexReader reader) {
        HashSet<IndexReader> readers = new HashSet<IndexReader>();
        ReaderProviderHelper.getIndexReadersInternal(readers, reader);
        return readers;
    }

    private static void getIndexReadersInternal(Set<IndexReader> readers, Object obj) {
        if (obj instanceof IndexSearcher) {
            ReaderProviderHelper.getIndexReadersInternal(readers, ((IndexSearcher)obj).getIndexReader());
        } else if (obj instanceof IndexReader) {
            readers.add((IndexReader)obj);
        }
    }
}

