/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.util.BaseTransaction;
import fr.dyade.aaa.util.JTransactionMBean;
import fr.dyade.aaa.util.Operation;
import fr.dyade.aaa.util.OperationKey;
import fr.dyade.aaa.util.StartWithFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public final class JTransaction
extends BaseTransaction
implements JTransactionMBean {
    protected long startTime = 0L;
    public static final String EMPTY_STRING = new String();
    static int LogThresholdOperation = 100;
    private File dir = null;
    private static final String LOG = "log";
    private RandomAccessFile logFile = null;
    private Hashtable log = null;
    protected int phase;

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isPersistent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String path) throws IOException {
        this.phase = 0;
        this.dir = new File(path);
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
        if (!this.dir.isDirectory()) {
            throw new FileNotFoundException(path + " is not a directory.");
        }
        FilterOutputStream dos = null;
        try {
            File tfc = new File(this.dir, "TFC");
            if (!tfc.exists()) {
                dos = new DataOutputStream(new FileOutputStream(tfc));
                ((DataOutputStream)dos).writeUTF(this.getClass().getName());
                ((DataOutputStream)dos).flush();
            }
        }
        finally {
            if (dos != null) {
                dos.close();
            }
        }
        this.loadProperties(this.dir);
        LogThresholdOperation = this.getInteger("LogThresholdOperation", LogThresholdOperation);
        Operation.initPool(LogThresholdOperation);
        this.saveProperties(this.dir);
        int oldPhase = 1;
        this.logFile = new RandomAccessFile(new File(this.dir, LOG), "rw");
        this.log = new Hashtable();
        if (this.logFile.length() != 0L) {
            this.logFile.seek(0L);
            oldPhase = this.logFile.readInt();
            if (oldPhase == 3) {
                String name;
                while (!(name = this.logFile.readUTF()).equals("")) {
                    String dirName = this.logFile.readUTF();
                    if (dirName.length() == 0) {
                        dirName = null;
                    }
                    Object key = OperationKey.newKey(dirName, name);
                    int op = this.logFile.read();
                    if (op == 1) {
                        byte[] buf = new byte[this.logFile.readInt()];
                        this.logFile.readFully(buf);
                        this.log.put(key, Operation.alloc(1, dirName, name, buf));
                        continue;
                    }
                    this.log.put(key, Operation.alloc(op, dirName, name));
                }
            }
            this._commit();
        }
        this.startTime = System.currentTimeMillis();
        this.setPhase(1);
    }

    public File getDir() {
        return this.dir;
    }

    public String getPersistenceDir() {
        return this.dir.getPath();
    }

    public final int getPhase() {
        return this.phase;
    }

    public final String getPhaseInfo() {
        return PhaseInfo[this.phase];
    }

    protected void setPhase(int newPhase) throws IOException {
        this.logFile.seek(0L);
        this.logFile.writeInt(newPhase);
        this.logFile.getFD().sync();
        this.phase = newPhase;
    }

    public final synchronized void begin() throws IOException {
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setPhase(2);
    }

    public String[] getList(String prefix) {
        return this.dir.list(new StartWithFilter(prefix));
    }

    public final void create(Serializable obj, String name) throws IOException {
        this.save(obj, null, name, true);
    }

    public final void create(Serializable obj, String dirName, String name) throws IOException {
        this.save(obj, dirName, name, true);
    }

    public final void save(Serializable obj, String name) throws IOException {
        this.save(obj, null, name, false);
    }

    public final void save(Serializable obj, String dirName, String name) throws IOException {
        this.save(obj, dirName, name, false);
    }

    public void save(Serializable obj, String dirName, String name, boolean first) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.flush();
        this.saveByteArray(bos.toByteArray(), dirName, name);
    }

    public final void createByteArray(byte[] buf, String name) throws IOException {
        this.saveByteArray(buf, null, name, true, true);
    }

    public final void createByteArray(byte[] buf, String dirName, String name) throws IOException {
        this.saveByteArray(buf, dirName, name, true, true);
    }

    public final void saveByteArray(byte[] buf, String name) throws IOException {
        this.saveByteArray(buf, null, name, true, false);
    }

    public final void saveByteArray(byte[] buf, String dirName, String name) throws IOException {
        this.saveByteArray(buf, dirName, name, true, false);
    }

    public void saveByteArray(byte[] buf, String dirName, String name, boolean copy, boolean first) throws IOException {
        if (this.phase == 2) {
            Object key = OperationKey.newKey(dirName, name);
            this.log.put(key, Operation.alloc(1, dirName, name, buf));
        } else {
            File file;
            if (dirName == null) {
                file = new File(this.dir, name);
            } else {
                File parentDir = new File(this.dir, dirName);
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                file = new File(parentDir, name);
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(buf);
            fos.close();
        }
    }

    public final Object load(String name) throws IOException, ClassNotFoundException {
        return this.load(null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object load(String dirName, String name) throws IOException, ClassNotFoundException {
        byte[] buf = this.loadByteArray(dirName, name);
        if (buf != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            ObjectInputStream ois = new ObjectInputStream(bis);
            try {
                Object object = ois.readObject();
                return object;
            }
            finally {
                ois.close();
                bis.close();
            }
        }
        return null;
    }

    public final byte[] loadByteArray(String name) throws IOException {
        return this.loadByteArray(null, name);
    }

    public byte[] loadByteArray(String dirName, String name) throws IOException {
        Object key;
        Operation op;
        if (this.phase == 2 && (op = (Operation)this.log.get(key = OperationKey.newKey(dirName, name))) != null) {
            if (op.type == 1) {
                return op.value;
            }
            if (op.type == 2) {
                return null;
            }
        }
        try {
            int ret;
            File file;
            if (dirName == null) {
                file = new File(this.dir, name);
            } else {
                File parentDir = new File(this.dir, dirName);
                file = new File(parentDir, name);
            }
            FileInputStream fis = new FileInputStream(file);
            byte[] buf = new byte[(int)file.length()];
            for (int nb = 0; nb < buf.length; nb += ret) {
                ret = fis.read(buf, nb, buf.length - nb);
                if (ret != -1) continue;
                throw new EOFException();
            }
            fis.close();
            return buf;
        }
        catch (FileNotFoundException exc) {
            return null;
        }
    }

    public final void delete(String name) {
        this.delete(null, name);
    }

    public void delete(String dirName, String name) {
        if (this.phase == 2) {
            Object key = OperationKey.newKey(dirName, name);
            this.log.put(key, Operation.alloc(2, dirName, name));
        } else if (dirName == null) {
            File file = new File(this.dir, name);
            file.delete();
        } else {
            File parentDir = new File(this.dir, dirName);
            File file = new File(parentDir, name);
            file.delete();
            this.deleteDir(parentDir);
        }
    }

    private void deleteDir(File dir) {
        String[] children = dir.list();
        if (children != null && children.length == 0) {
            dir.delete();
            if (dir.getAbsolutePath().length() > this.dir.getAbsolutePath().length()) {
                this.deleteDir(dir.getParentFile());
            }
        }
    }

    public synchronized void commit(boolean release) throws IOException {
        if (this.phase != 2) {
            throw new NotActiveException("Can not commit inexistent transaction.");
        }
        this.logFile.seek(4L);
        Enumeration e = this.log.elements();
        while (e.hasMoreElements()) {
            Operation op = (Operation)e.nextElement();
            this.logFile.writeUTF(op.name);
            if (op.dirName != null) {
                this.logFile.writeUTF(op.dirName);
            } else {
                this.logFile.writeUTF(EMPTY_STRING);
            }
            this.logFile.writeByte(op.type);
            if (op.type != 1) continue;
            this.logFile.writeInt(op.value.length);
            this.logFile.write(op.value);
        }
        this.logFile.writeUTF("");
        this.setPhase(3);
        this._commit();
        this.log.clear();
        if (release) {
            this.setPhase(1);
            this.notify();
        }
    }

    private void _commit() throws IOException {
        Enumeration e = this.log.elements();
        while (e.hasMoreElements()) {
            File parentDir;
            File file;
            Operation op = (Operation)e.nextElement();
            if (op.type == 1) {
                if (op.dirName == null) {
                    file = new File(this.dir, op.name);
                } else {
                    parentDir = new File(this.dir, op.dirName);
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    file = new File(parentDir, op.name);
                }
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(op.value);
                fos.getFD().sync();
                fos.close();
                continue;
            }
            if (op.type == 2) {
                if (op.dirName == null) {
                    file = new File(this.dir, op.name);
                    file.delete();
                    continue;
                }
                parentDir = new File(this.dir, op.dirName);
                file = new File(parentDir, op.name);
                file.delete();
                this.deleteDir(parentDir);
                continue;
            }
            throw new InvalidObjectException("Unknow object in log.");
        }
    }

    public synchronized void release() throws IOException {
        if (this.phase != 2 && this.phase != 3 && this.phase != 4) {
            throw new IllegalStateException("Can not release transaction.");
        }
        this.setPhase(1);
        this.notify();
    }

    public synchronized void stop() {
        while (this.phase != 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void close() {
        this.stop();
        try {
            this.setPhase(6);
            this.logFile.close();
            this.setPhase(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

