/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.stream.Properties;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.objectweb.joram.mom.dest.Destination;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.dest.TopicMBean;
import org.objectweb.joram.mom.notifications.AbstractRequestNot;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.ClusterJoinAck;
import org.objectweb.joram.mom.notifications.ClusterJoinNot;
import org.objectweb.joram.mom.notifications.ClusterRemoveNot;
import org.objectweb.joram.mom.notifications.ExceptionReply;
import org.objectweb.joram.mom.notifications.FwdAdminRequestNot;
import org.objectweb.joram.mom.notifications.SubscribeReply;
import org.objectweb.joram.mom.notifications.SubscribeRequest;
import org.objectweb.joram.mom.notifications.TopicForwardNot;
import org.objectweb.joram.mom.notifications.TopicMsgsReply;
import org.objectweb.joram.mom.notifications.UnsubscribeRequest;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.ClusterAdd;
import org.objectweb.joram.shared.admin.ClusterLeave;
import org.objectweb.joram.shared.admin.ClusterList;
import org.objectweb.joram.shared.admin.ClusterListReply;
import org.objectweb.joram.shared.admin.GetDMQSettingsReply;
import org.objectweb.joram.shared.admin.GetDMQSettingsRequest;
import org.objectweb.joram.shared.admin.GetFatherReply;
import org.objectweb.joram.shared.admin.GetFatherRequest;
import org.objectweb.joram.shared.admin.GetNumberReply;
import org.objectweb.joram.shared.admin.GetSubscriberIds;
import org.objectweb.joram.shared.admin.GetSubscriberIdsRep;
import org.objectweb.joram.shared.admin.GetSubscriptionsRequest;
import org.objectweb.joram.shared.admin.SetFather;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.selectors.Selector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class Topic
extends Destination
implements TopicMBean {
    public static Logger logger = Debug.getLogger((String)Topic.class.getName());
    private static final long serialVersionUID = 1L;
    protected AgentId fatherId = null;
    protected Set friends = null;
    protected List subscribers = new Vector();
    protected Map selectors = new Hashtable();
    protected transient boolean alreadySentLocally;

    public Topic() {
    }

    public Topic(String string, boolean b, int joramAdminStamp) {
        super(string, b, joramAdminStamp);
    }

    public final byte getType() {
        return 1;
    }

    public void react(AgentId from, Notification not) throws Exception {
        this.setAlreadySentLocally(false);
        int reqId = -1;
        if (not instanceof AbstractRequestNot) {
            reqId = ((AbstractRequestNot)not).getRequestId();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + ": got " + not.getClass().getName() + " with id: " + reqId + " from: " + from.toString()));
        }
        try {
            if (not instanceof ClusterJoinAck) {
                this.clusterJoinAck((ClusterJoinAck)not);
            } else if (not instanceof ClusterJoinNot) {
                this.clusterJoin((ClusterJoinNot)not);
            } else if (not instanceof ClusterRemoveNot) {
                this.clusterRemove(from);
            } else if (not instanceof SubscribeRequest) {
                this.subscribeRequest(from, (SubscribeRequest)not);
            } else if (not instanceof UnsubscribeRequest) {
                this.unsubscribeRequest(from);
            } else if (not instanceof TopicForwardNot) {
                this.topicForwardNot(from, (TopicForwardNot)not);
            } else {
                super.react(from, not);
            }
        }
        catch (MomException exc) {
            if (logger.isLoggable(BasicLevel.WARN)) {
                logger.log(BasicLevel.WARN, (Object)exc);
            }
            AbstractRequestNot req = (AbstractRequestNot)not;
            Channel.sendTo((AgentId)from, (Notification)new ExceptionReply(req, exc));
        }
    }

    public void initialize(boolean firstTime) {
    }

    protected void finalize(boolean lastTime) {
    }

    public String toString() {
        return "Topic:" + this.getId().toString();
    }

    public void wakeUpNot(WakeUpNot not) {
    }

    private void clusterAdd(FwdAdminRequestNot req, String joiningTopic) {
        AgentId newFriendId = AgentId.fromString((String)joiningTopic);
        if (this.friends == null) {
            this.friends = new HashSet();
            this.friends.add(this.getId());
        }
        this.forward(newFriendId, new ClusterJoinNot(this.friends, req.getReplyTo(), req.getRequestMsgId(), req.getReplyMsgId()));
    }

    protected void clusterJoin(ClusterJoinNot not) {
        this.setSave();
        if (this.friends == null) {
            this.friends = new HashSet();
            this.friends.add(this.getId());
        }
        this.friends.addAll(not.getCluster());
        this.sendToCluster(new ClusterJoinAck(this.friends));
        this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
    }

    protected void clusterJoinAck(ClusterJoinAck not) {
        this.friends.addAll(not.getCluster());
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " Topic.clusterJoinAck(" + (Object)((Object)not) + ")" + "\nfriends=" + this.friends));
        }
    }

    private List clusterList() {
        ArrayList<String> cluster = new ArrayList<String>();
        if (this.friends != null) {
            Iterator iterator = this.friends.iterator();
            while (iterator.hasNext()) {
                cluster.add(iterator.next().toString());
            }
        } else {
            cluster.add(this.getAgentId());
        }
        return cluster;
    }

    public String[] getClusterElements() {
        List list = this.clusterList();
        return list.toArray(new String[list.size()]);
    }

    private void clusterLeave() {
        if (this.friends != null) {
            this.sendToCluster(new ClusterRemoveNot());
            this.friends = null;
            this.setSave();
        }
    }

    private void clusterRemove(AgentId topic) {
        this.setSave();
        this.friends.remove(topic);
        if (this.friends.size() == 1) {
            this.friends = null;
        }
    }

    protected void sendToCluster(Notification not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " Topic.sendToCluster(" + not + ")"));
        }
        if (this.friends == null || this.friends.size() < 2) {
            return;
        }
        for (AgentId id : this.friends) {
            if (id.equals((Object)this.getId())) continue;
            this.forward(id, not);
        }
    }

    public void preSubscribe() {
    }

    public void postSubscribe() {
    }

    protected void subscribeRequest(AgentId from, SubscribeRequest not) throws AccessException {
        if (!this.isReader(from)) {
            throw new AccessException("READ right not granted");
        }
        this.preSubscribe();
        this.setSave();
        if (!this.subscribers.contains(from)) {
            this.subscribers.add(from);
        }
        if (not.getSelector() != null && !not.getSelector().equals("")) {
            this.selectors.put(from, not.getSelector());
        } else {
            this.selectors.remove(from);
        }
        if (!not.isAsyncSub()) {
            this.forward(from, new SubscribeReply(not));
        }
        this.postSubscribe();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Client " + from + " set as a subscriber with selector " + not.getSelector()));
        }
    }

    public void preUnsubscribe() {
    }

    public void postUnsubscribe() {
    }

    protected void unsubscribeRequest(AgentId from) {
        this.preUnsubscribe();
        this.setSave();
        this.subscribers.remove(from);
        this.selectors.remove(from);
        this.postUnsubscribe();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Client " + from + " removed from the subscribers."));
        }
    }

    protected void topicForwardNot(AgentId from, TopicForwardNot not) {
        this.doClientMessages(from, not.messages, not.fromCluster, false);
    }

    public void handleAdminRequestNot(AgentId from, FwdAdminRequestNot not) {
        AdminRequest adminRequest = not.getRequest();
        if (adminRequest instanceof GetSubscriberIds) {
            this.replyToTopic((AdminReply)new GetSubscriberIdsRep(this.getSubscriberIds()), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetSubscriptionsRequest) {
            this.replyToTopic((AdminReply)new GetNumberReply(this.getNumberOfSubscribers()), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetDMQSettingsRequest) {
            this.replyToTopic((AdminReply)new GetDMQSettingsReply(this.dmqId != null ? this.dmqId.toString() : null, 0), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof SetFather) {
            this.setSave();
            this.fatherId = AgentId.fromString((String)((SetFather)adminRequest).getFather());
            this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetFatherRequest) {
            this.replyToTopic((AdminReply)new GetFatherReply(this.fatherId != null ? this.fatherId.toString() : null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof ClusterList) {
            List clstr = this.clusterList();
            this.replyToTopic((AdminReply)new ClusterListReply(clstr), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof ClusterAdd) {
            this.clusterAdd(not, ((ClusterAdd)adminRequest).getAddedDest());
        } else if (adminRequest instanceof ClusterLeave) {
            this.clusterLeave();
            this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else {
            super.handleAdminRequestNot(from, not);
        }
    }

    public final int getNumberOfSubscribers() {
        return this.subscribers.size();
    }

    public final String[] getSubscriberIds() {
        String[] res = new String[this.subscribers.size()];
        for (int i = 0; i < res.length; ++i) {
            AgentId aid = (AgentId)this.subscribers.get(i);
            res[i] = aid.toString();
        }
        return res;
    }

    protected void doRightRequest(AgentId user, int right) {
        if (right != -READ) {
            return;
        }
        if (user != null) {
            this.setSave();
            this.subscribers.remove(user);
            this.selectors.remove(user);
            this.forward(user, new ExceptionReply((MomException)((Object)new AccessException("READ right removed."))));
        } else {
            Iterator subs = this.subscribers.iterator();
            while (subs.hasNext()) {
                user = (AgentId)subs.next();
                if (this.isReader(user)) continue;
                this.setSave();
                subs.remove();
                this.selectors.remove(user);
                this.forward(user, new ExceptionReply((MomException)((Object)new AccessException("READ right removed."))));
            }
        }
    }

    protected void doClientMessages(AgentId from, ClientMessages not, boolean throwsExceptionOnFullDest) {
        this.doClientMessages(from, not, false, throwsExceptionOnFullDest);
    }

    private void doClientMessages(AgentId from, ClientMessages not, boolean fromCluster, boolean throwsExceptionOnFullDest) {
        ClientMessages clientMsgs = this.preProcess(from, not);
        if (clientMsgs != null) {
            this.forwardMessages(clientMsgs, fromCluster);
            this.processMessages(clientMsgs);
            this.postProcess(clientMsgs);
        }
    }

    protected void doUnknownAgent(UnknownAgent uA) {
        AgentId agId = uA.agent;
        Notification not = uA.not;
        if (not instanceof ClusterJoinNot) {
            ClusterJoinNot cT = (ClusterJoinNot)not;
            logger.log(BasicLevel.ERROR, (Object)("Cluster join failed: " + uA.agent + " unknown."));
            String info = "Cluster join failed: Unknown destination.";
            this.replyToTopic(new AdminReply(7, info), cT.getReplyTo(), cT.getRequestMsgId(), cT.getReplyMsgId());
        } else if (not instanceof ClusterJoinAck || not instanceof ClusterRemoveNot) {
            logger.log(BasicLevel.ERROR, (Object)("Cluster error: " + uA.agent + " unknown. " + "The topic has probably been removed in the meantime."));
            this.clusterRemove(agId);
        } else {
            this.setSave();
            this.subscribers.remove(agId);
            this.selectors.remove(agId);
            if (agId.equals((Object)this.fatherId)) {
                this.fatherId = null;
            }
        }
    }

    protected void doDeleteNot(DeleteNot not) {
        for (int i = 0; i < this.subscribers.size(); ++i) {
            AgentId clientId = (AgentId)this.subscribers.get(i);
            this.forward(clientId, (Notification)new UnknownAgent(this.getId(), null));
        }
        this.clusterLeave();
        this.setSave();
    }

    protected void forwardMessages(ClientMessages messages) {
        this.forwardMessages(messages, false);
    }

    private void forwardMessages(ClientMessages messages, boolean fromCluster) {
        if (!fromCluster) {
            this.sendToCluster(new TopicForwardNot(messages, true));
        }
        if (this.fatherId != null) {
            this.forward(this.fatherId, new TopicForwardNot(messages, false));
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Messages forwarded to father " + this.fatherId.toString()));
            }
        }
    }

    protected void processMessages(ClientMessages not) {
        Message message;
        ArrayList<Message> messages = not.getMessages();
        this.nbMsgsReceiveSinceCreation += (long)messages.size();
        if (this.interceptorsAvailable()) {
            DMQManager dmqManager = null;
            ArrayList<Message> newMessages = new ArrayList<Message>();
            for (Message m : messages) {
                m.setProperty("JoramDestinationName", (Object)this.getName());
                message = this.processInterceptors(m);
                if (message != null) {
                    newMessages.add(message);
                    continue;
                }
                if (dmqManager == null) {
                    dmqManager = new DMQManager(this.dmqId, this.getId());
                }
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(m, (short)7);
            }
            if (dmqManager != null) {
                dmqManager.sendToDMQ();
            }
            if (!newMessages.isEmpty()) {
                messages = newMessages;
            } else {
                return;
            }
        }
        this.setNoSave();
        boolean persistent = false;
        for (AgentId subscriber : this.subscribers) {
            AbstractList deliverables;
            boolean local = subscriber.getTo() == AgentServer.getServerId();
            String selector = (String)this.selectors.get(subscriber);
            if (selector == null || selector.equals("")) {
                if (!local) {
                    deliverables = messages;
                    persistent = true;
                } else if (!this.alreadySentLocally) {
                    deliverables = messages;
                    this.alreadySentLocally = true;
                } else {
                    deliverables = new Vector();
                    Iterator msgs = messages.iterator();
                    while (msgs.hasNext()) {
                        deliverables.add(((Message)msgs.next()).clone());
                    }
                }
            } else {
                deliverables = new Vector();
                for (int i = 0; i < messages.size(); ++i) {
                    message = (Message)messages.get(i);
                    if (!Selector.matches((Message)message, (String)selector)) continue;
                    if (!local) {
                        deliverables.add(message);
                        persistent = true;
                        continue;
                    }
                    if (!this.alreadySentLocally) {
                        deliverables.add(message);
                        this.alreadySentLocally = true;
                        continue;
                    }
                    deliverables.add(message.clone());
                }
            }
            if (deliverables.isEmpty()) continue;
            TopicMsgsReply topicMsgsReply = new TopicMsgsReply(deliverables);
            topicMsgsReply.setPersistent(persistent);
            this.setDmq(topicMsgsReply);
            this.forward(subscriber, topicMsgsReply);
            this.nbMsgsDeliverSinceCreation += (long)deliverables.size();
        }
    }

    private void setDmq(TopicMsgsReply not) {
        if (this.dmqId != null) {
            not.setDMQId(this.dmqId);
        } else {
            not.setDMQId(Queue.getDefaultDMQId());
        }
    }

    public void setAlreadySentLocally(boolean alreadySentLocally) {
        this.alreadySentLocally = alreadySentLocally;
    }

    public long getNbMsgsReceiveSinceCreation() {
        return this.nbMsgsReceiveSinceCreation;
    }

    public String getTxName(String msgId) {
        return null;
    }

    protected Properties getStats() {
        return null;
    }
}

