/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.util;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.common.Debug;
import java.util.Properties;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.notifications.FwdAdminRequestNot;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.ClearQueue;
import org.objectweb.joram.shared.admin.ClearSubscription;
import org.objectweb.joram.shared.admin.CreateUserRequest;
import org.objectweb.joram.shared.admin.DeleteQueueMessage;
import org.objectweb.joram.shared.admin.DeleteSubscriptionMessage;
import org.objectweb.joram.shared.admin.SetReader;
import org.objectweb.joram.shared.admin.SetRight;
import org.objectweb.joram.shared.admin.SetWriter;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class JoramHelper {
    public static Logger logger = Debug.getLogger((String)JoramHelper.class.getName());
    public static final String JNDI_INITIAL = "java.naming.factory.initial";
    public static final String JNDI_HOST = "scn.naming.factory.host";
    public static final String JNDI_PORT = "scn.naming.factory.port";

    public static final void createUser(String userName, String userPass) {
        block3: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("JoramHelper.createUser(" + userName + ')'));
            }
            try {
                SimpleIdentity identity = new SimpleIdentity();
                identity.setIdentity(userName, userPass);
                AdminTopic.CreateUserAndSave(new CreateUserRequest((Identity)identity, (int)AgentServer.getServerId(), null), null, "-1");
            }
            catch (Exception exc) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break block3;
                logger.log(BasicLevel.ERROR, (Object)"Exception:: JoramHelper.createUser", (Throwable)exc);
            }
        }
    }

    public static final AgentId createDestination(String destName, AgentId adminId, String destClassName, byte type, Properties properties, boolean freerw) throws Exception {
        return JoramHelper.createDestination(destName, adminId, destClassName, type, properties, freerw, freerw);
    }

    public static final AgentId createDestination(String destName, AgentId adminId, String destClassName, byte type, Properties properties, boolean freeReading, boolean freeWriting) throws Exception {
        AgentId destId;
        block10: {
            block9: {
                destId = null;
                StringBuffer strbuf = new StringBuffer();
                AdminTopic.DestinationDesc destDesc = null;
                try {
                    destDesc = AdminTopic.createDestinationAndSave(destName, adminId, properties, type, destClassName, "JoramHelper", strbuf);
                }
                catch (Exception exc) {
                    logger.log(BasicLevel.ERROR, (Object)("JoramHelper.createDestination, Cannot create destination " + destName), (Throwable)exc);
                    throw exc;
                }
                destId = destDesc.getId();
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("JoramHelper.createDestination info = " + strbuf.toString()));
                }
                strbuf.setLength(0);
                if (freeReading) {
                    try {
                        AdminTopic.setRightAndSave((SetRight)new SetReader(null, destId.toString()), null, "-1");
                    }
                    catch (Exception exc) {
                        if (!logger.isLoggable(BasicLevel.ERROR)) break block9;
                        logger.log(BasicLevel.ERROR, (Object)"JoramHelper.createDestination, Cannot set FreeReader", (Throwable)exc);
                    }
                }
            }
            if (freeWriting) {
                try {
                    AdminTopic.setRightAndSave((SetRight)new SetWriter(null, destId.toString()), null, "-1");
                }
                catch (Exception exc) {
                    if (!logger.isLoggable(BasicLevel.ERROR)) break block10;
                    logger.log(BasicLevel.ERROR, (Object)"JoramHelper.createDestination, Cannot set FreeWriter", (Throwable)exc);
                }
            }
        }
        return destId;
    }

    public static final boolean deleteQueueMessage(String queueName, String msgId) {
        AdminTopic.DestinationDesc queueDesc;
        try {
            queueDesc = AdminTopic.lookupDest(queueName, (byte)2);
        }
        catch (RequestException e) {
            return false;
        }
        if (queueDesc == null) {
            return false;
        }
        DeleteQueueMessage req = new DeleteQueueMessage(queueDesc.getId().toString(), msgId);
        FwdAdminRequestNot not = new FwdAdminRequestNot((AdminRequest)req, null, null);
        Channel.sendTo((AgentId)queueDesc.getId(), (Notification)not);
        return true;
    }

    public static final boolean deleteSubMessage(String userName, String subName, String msgId) {
        AgentId userId = AdminTopic.lookupUser(userName);
        if (userId == null) {
            return false;
        }
        DeleteSubscriptionMessage req = new DeleteSubscriptionMessage(userId.toString(), subName, msgId);
        FwdAdminRequestNot not = new FwdAdminRequestNot((AdminRequest)req, null, null);
        Channel.sendTo((AgentId)userId, (Notification)not);
        return true;
    }

    public static final boolean clearQueue(String queueName) {
        AdminTopic.DestinationDesc queueDesc;
        try {
            queueDesc = AdminTopic.lookupDest(queueName, (byte)2);
            if (queueDesc == null) {
                return false;
            }
        }
        catch (RequestException e) {
            return false;
        }
        ClearQueue req = new ClearQueue(queueDesc.getId().toString());
        FwdAdminRequestNot not = new FwdAdminRequestNot((AdminRequest)req, null, null);
        Channel.sendTo((AgentId)queueDesc.getId(), (Notification)not);
        return true;
    }

    public static final boolean clearSubscription(String userName, String subName) {
        AgentId userId = AdminTopic.lookupUser(userName);
        ClearSubscription req = new ClearSubscription(userId.toString(), subName);
        FwdAdminRequestNot not = new FwdAdminRequestNot((AdminRequest)req, null, null);
        Channel.sendTo((AgentId)userId, (Notification)not);
        return true;
    }
}

