/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.jorm;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMultiMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbExternalTable;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbGenClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbJoin;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbMappingFactory;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbMappingPrinter;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbTable;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.ClassRef;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.NameRef;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.PrimitiveElementMapping;
import org.objectweb.jorm.metainfo.api.ScalarField;
import org.objectweb.jorm.metainfo.lib.JormManager;
import org.objectweb.jorm.metainfo.lib.MetaInfoPrinter;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.wrapper.printwriter.PrintStreamImpl;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.DeploymentDescEjb2;
import org.ow2.jonas.deployment.ejb.EjbRelationDesc;
import org.ow2.jonas.deployment.ejb.EjbRelationshipRoleDesc;
import org.ow2.jonas.deployment.ejb.EntityJdbcCmp2Desc;
import org.ow2.jonas.deployment.ejb.FieldJdbcDesc;
import org.ow2.jonas.lib.ejb21.jorm.CMP2Bean;
import org.ow2.jonas.lib.ejb21.jorm.JormType;
import org.ow2.jonas.lib.util.Log;

public class RdbMappingBuilder {
    private Logger logger = null;
    private JormManager manager = null;
    public static final String MAPPER_NAME = "rdb";
    public static final String PROJECT_NAME = "jonas";
    private PrintStreamImpl pstream;
    private MetaInfoPrinter mip;
    private ArrayList cmp2List = new ArrayList();

    public RdbMappingBuilder(DeploymentDescEjb2 dd) throws DeploymentDescException {
        this.logger = Log.getLogger((String)"org.ow2.jonas.lib.ejb21.mijorm");
        this.pstream = new PrintStreamImpl(this.logger);
        this.mip = new MetaInfoPrinter();
        this.mip.addMappingPrinter(new RdbMappingPrinter());
        this.manager = new JormManager();
        this.manager.setLogger(this.logger);
        this.manager.init();
        this.manager.addMappingFactory(MAPPER_NAME, new RdbMappingFactory());
        try {
            Iterator i = dd.getBeanDescIterator();
            while (i.hasNext()) {
                BeanDesc bd = (BeanDesc)i.next();
                if (!(bd instanceof EntityJdbcCmp2Desc)) continue;
                CMP2Bean cmp2 = this.createJormEntityMI((EntityJdbcCmp2Desc)bd);
                this.cmp2List.add(cmp2);
            }
            i = dd.getEjbRelationDescIterator();
            while (i.hasNext()) {
                EjbRelationDesc relation = (EjbRelationDesc)i.next();
                this.createJormRelationMI(relation);
            }
        }
        catch (PException e) {
            this.logger.log(BasicLevel.ERROR, (Object)("Jorm Exception raised: " + e));
            throw new DeploymentDescException((Throwable)e);
        }
    }

    public CMP2Bean getCmp2Bean(String beanName) {
        for (CMP2Bean cmp2 : this.cmp2List) {
            if (!cmp2.getName().equals(beanName)) continue;
            return cmp2;
        }
        return null;
    }

    public Manager getJormMIManager() {
        return this.manager;
    }

    public static String getProjectName() {
        return PROJECT_NAME;
    }

    private CMP2Bean createJormEntityMI(EntityJdbcCmp2Desc bd) throws PException {
        CMP2Bean cmp = new CMP2Bean(bd);
        String asn = bd.getJormClassName();
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Create Jorm MI for the bean: " + asn));
        }
        Class myejb = this.manager.createClass(asn);
        cmp.addToJormList(myejb);
        ClassProject acp = myejb.createClassProject(PROJECT_NAME);
        RdbMapping mapping = (RdbMapping)acp.createMapping(MAPPER_NAME);
        RdbClassMultiMapping classmapping = mapping.createClassMultiMapping("to-table");
        String tablename = bd.getJdbcTableName();
        RdbTable mytable = classmapping.createRdbTable(tablename);
        Iterator i = bd.getCmpFieldDescIterator();
        while (i.hasNext()) {
            FieldJdbcDesc fd = (FieldJdbcDesc)i.next();
            String fieldname = fd.getName();
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Create PrimitiveElement for the CMP field: " + fieldname));
            }
            PType pt = JormType.getPType(fd.getFieldType(), fd.isPrimaryKey());
            PrimitiveElement pe = myejb.createPrimitiveElement(fieldname, pt, -1, -1);
            mytable.createPrimitiveElementMapping(pe, fd.getJdbcFieldName(), fd.getSqlType(), fd.isPrimaryKey());
        }
        NameDef nds = myejb.createNameDef();
        if (bd.hasSimplePkField()) {
            nds.setFieldName(bd.getSimplePkField().getName());
        } else {
            boolean newcn = false;
            CompositeName cn = this.manager.getCompositeName(bd.getJormPKClassName());
            if (cn == null) {
                cn = this.manager.createCompositeName(bd.getJormPKClassName());
                cmp.addToJormList(cn);
                newcn = true;
            }
            NameRef nrs = nds.createNameRef(cn);
            Iterator it = bd.getCmpFieldDescIterator();
            while (it.hasNext()) {
                FieldJdbcDesc fd = (FieldJdbcDesc)it.next();
                if (!fd.isPrimaryKey()) continue;
                String fieldName = fd.getName();
                if (newcn) {
                    cn.createCompositeNameField(fieldName, JormType.getPType(fd.getFieldType(), fd.isPrimaryKey()), -1, -1);
                }
                nrs.addProjection(fieldName, fieldName);
            }
        }
        classmapping.createIdentifierMapping(nds);
        this.mip.print("Jorm MI for " + asn + ": ", myejb, (PrintStream)this.pstream);
        this.mip.print("JORM MI Mapping for " + asn + ": ", classmapping, (PrintStream)this.pstream);
        return cmp;
    }

    private void createJormRelationMI(EjbRelationDesc relation) throws PException {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Create Jorm MI for the relation: " + relation.getName()));
        }
        EjbRelationshipRoleDesc role1 = relation.getRelationshipRole1();
        EjbRelationshipRoleDesc role2 = relation.getRelationshipRole2();
        if (role1.isTargetMultiple()) {
            this.createJormRoleMIMulti(role1, role2);
        } else {
            this.createJormRoleMIOne(role1, role2);
        }
        if (role2.isTargetMultiple()) {
            this.createJormRoleMIMulti(role2, role1);
        } else {
            this.createJormRoleMIOne(role2, role1);
        }
    }

    private void createJormRoleMIOne(EjbRelationshipRoleDesc sRole, EjbRelationshipRoleDesc tRole) throws PException {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)sRole.getName());
        }
        EntityJdbcCmp2Desc sEntity = (EntityJdbcCmp2Desc)sRole.getSourceBean();
        String sAsn = sEntity.getJormClassName();
        Class sClass = this.manager.getClass(sAsn);
        EntityJdbcCmp2Desc tEntity = (EntityJdbcCmp2Desc)sRole.getTargetBean();
        String tAsn = tEntity.getJormClassName();
        Class tClass = this.manager.getClass(tAsn);
        ClassProject cpro = sClass.getClassProject(PROJECT_NAME);
        RdbMapping rdbmapping = (RdbMapping)cpro.getMapping(MAPPER_NAME);
        RdbClassMultiMapping classmapping = (RdbClassMultiMapping)rdbmapping.getClassMapping();
        RdbTable rdbtable = classmapping.getRdbTable();
        String sCmr = sRole.getCmrFieldName();
        if (tClass == sClass && sClass.getTypedElement(sCmr) != null) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"Nothing to do, same CMR field.");
            }
            return;
        }
        if (tClass != sClass) {
            classmapping.addDependency(tClass.getFQName());
        }
        ClassRef cr = sClass.createClassRef(sCmr, tClass);
        NameDef rndf = cr.createRefNameDef();
        if (sRole.hasJdbcMapping() || tClass == sClass) {
            classmapping.createReferenceMapping("embedded-target-reference", rndf);
            if (tClass != sClass) {
                rdbtable.setColocated(true);
                rdbtable.setColocatedMaster(true);
            }
            if (tEntity.hasSimplePkField()) {
                FieldJdbcDesc fd = (FieldJdbcDesc)tEntity.getSimplePkField();
                String cmrmappingname = sRole.getForeignKeyJdbcName(fd.getJdbcFieldName());
                PrimitiveElement pe = null;
                String clafn = sCmr + "_" + fd.getName();
                boolean peHasMapping = false;
                if (cmrmappingname != null) {
                    pe = this.getPrimitiveElementByColumn(classmapping, cmrmappingname);
                }
                if (pe == null) {
                    pe = sClass.createHiddenField(clafn, JormType.getPType(fd.getFieldType(), fd.isPrimaryKey()), -1, -1);
                } else {
                    peHasMapping = true;
                }
                rndf.setFieldName(pe.getName());
                if (cmrmappingname != null) {
                    if (!peHasMapping) {
                        rdbtable.createPrimitiveElementMapping(pe, cmrmappingname, fd.getSqlType(), false);
                    }
                } else if (tClass == sClass) {
                    cmrmappingname = tRole.getForeignKeyJdbcName(fd.getJdbcFieldName());
                    PrimitiveElementMapping pem = classmapping.getPrimitiveElementMapping(tRole.getCmrFieldName() + "_" + fd.getName());
                    classmapping.addPrimitiveElementMapping(clafn, pem);
                }
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("CMR " + sCmr + " is mapped over the field: " + clafn + " / columname: " + cmrmappingname));
                }
            } else {
                NameRef cpk = rndf.createNameRef(tClass.getNameDef("").getNameRef().getCompositeName());
                Iterator i = tEntity.getCmpFieldDescIterator();
                while (i.hasNext()) {
                    FieldJdbcDesc fd = (FieldJdbcDesc)i.next();
                    if (!fd.isPrimaryKey()) continue;
                    String cmrmappingname = sRole.getForeignKeyJdbcName(fd.getJdbcFieldName());
                    PrimitiveElement pe = null;
                    String clafn = sCmr + "_" + fd.getName();
                    boolean peHasMapping = false;
                    if (cmrmappingname != null) {
                        pe = this.getPrimitiveElementByColumn(classmapping, cmrmappingname);
                    }
                    if (pe == null) {
                        pe = sClass.createHiddenField(clafn, JormType.getPType(fd.getFieldType(), fd.isPrimaryKey()), -1, -1);
                    } else {
                        peHasMapping = true;
                    }
                    cpk.addProjection(fd.getName(), pe.getName());
                    if (cmrmappingname != null) {
                        if (!peHasMapping) {
                            rdbtable.createPrimitiveElementMapping(pe, cmrmappingname, fd.getSqlType(), false);
                        }
                    } else if (tClass == sClass) {
                        cmrmappingname = tRole.getForeignKeyJdbcName(fd.getJdbcFieldName());
                        PrimitiveElementMapping pem = classmapping.getPrimitiveElementMapping(tRole.getCmrFieldName() + "_" + fd.getName());
                        classmapping.addPrimitiveElementMapping(clafn, pem);
                    }
                    if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                    this.logger.log(BasicLevel.DEBUG, (Object)("CMR " + sCmr + " is mapped over the field: " + clafn + " / columname: " + cmrmappingname));
                }
            }
        } else {
            classmapping.createReferenceMapping("multi-table", rndf);
            RdbExternalTable table2 = classmapping.createRdbExternalTable(tEntity.getJdbcTableName());
            table2.setColocated(true);
            table2.setColocatedMaster(false);
            table2.setReadOnly(true);
            RdbJoin joinTo2 = table2.createRdbJoin(sCmr);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("CMR " + sCmr + " is mapped over the external table: " + tEntity.getJdbcTableName()));
            }
            if (sEntity.hasSimplePkField()) {
                FieldJdbcDesc spk = (FieldJdbcDesc)sEntity.getSimplePkField();
                String cmrmappingname = tRole.getForeignKeyJdbcName(spk.getJdbcFieldName());
                joinTo2.addJoinColumnNames(spk.getJdbcFieldName(), cmrmappingname);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("CMR " + sCmr + ": join: " + spk.getJdbcFieldName() + " = " + cmrmappingname));
                }
            } else {
                Iterator i = sEntity.getCmpFieldDescIterator();
                while (i.hasNext()) {
                    FieldJdbcDesc fd = (FieldJdbcDesc)i.next();
                    if (!fd.isPrimaryKey()) continue;
                    String cmrmappingname = tRole.getForeignKeyJdbcName(fd.getJdbcFieldName());
                    joinTo2.addJoinColumnNames(fd.getJdbcFieldName(), cmrmappingname);
                    if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                    this.logger.log(BasicLevel.DEBUG, (Object)("CMR " + sCmr + ": join: " + fd.getJdbcFieldName() + " = " + cmrmappingname));
                }
            }
            if (tEntity.hasSimplePkField()) {
                FieldJdbcDesc tpk = (FieldJdbcDesc)tEntity.getSimplePkField();
                String clafn = sCmr + "_" + tpk.getName();
                rndf.setFieldName(clafn);
                ScalarField sf = sClass.createHiddenField(clafn, JormType.getPType(tpk.getFieldType(), tpk.isPrimaryKey()), -1, -1);
                table2.createPrimitiveElementMapping(sf, tpk.getJdbcFieldName(), tpk.getSqlType(), false, joinTo2);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("CMR " + sCmr + ": mapped over the field : " + clafn + " column: " + tpk.getJdbcFieldName()));
                }
            } else {
                NameRef cpk = rndf.createNameRef(tClass.getNameDef("").getNameRef().getCompositeName());
                Iterator i = tEntity.getCmpFieldDescIterator();
                while (i.hasNext()) {
                    FieldJdbcDesc fd = (FieldJdbcDesc)i.next();
                    if (!fd.isPrimaryKey()) continue;
                    String clafn = sCmr + "_" + fd.getName();
                    ScalarField sf = sClass.createHiddenField(clafn, JormType.getPType(fd.getFieldType(), fd.isPrimaryKey()), -1, -1);
                    table2.createPrimitiveElementMapping(sf, fd.getJdbcFieldName(), fd.getSqlType(), false, joinTo2);
                    cpk.addProjection(fd.getName(), sf.getName());
                    if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                    this.logger.log(BasicLevel.DEBUG, (Object)("CMR " + sCmr + ": mapped over the field : " + clafn + " column: " + fd.getJdbcFieldName()));
                }
            }
        }
        this.mip.print("JORM MI for " + sAsn + ": ", sClass, (PrintStream)this.pstream);
        this.mip.print("JORM MI Mapping for " + sAsn + ": ", classmapping, (PrintStream)this.pstream);
    }

    private void createJormRoleMIMulti(EjbRelationshipRoleDesc sRole, EjbRelationshipRoleDesc tRole) throws PException {
        FieldJdbcDesc fd;
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)sRole.getName());
        }
        EntityJdbcCmp2Desc sEntity = (EntityJdbcCmp2Desc)sRole.getSourceBean();
        String sAsn = sEntity.getJormClassName();
        Class sClass = this.manager.getClass(sAsn);
        EntityJdbcCmp2Desc tEntity = (EntityJdbcCmp2Desc)sRole.getTargetBean();
        String tAsn = tEntity.getJormClassName();
        Class tClass = this.manager.getClass(tAsn);
        ClassProject cpro = sClass.getClassProject(PROJECT_NAME);
        RdbMapping rdbmapping = (RdbMapping)cpro.getMapping(MAPPER_NAME);
        RdbClassMultiMapping classmapping = (RdbClassMultiMapping)rdbmapping.getClassMapping();
        String sCmr = sRole.getCmrFieldName();
        if (tClass == sClass && sClass.getTypedElement(sCmr) != null) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)"Nothing to do, same CMR field.");
            }
            return;
        }
        if (tClass != sClass) {
            classmapping.addDependency(tClass.getFQName());
        }
        GenClassRef gcr = sClass.createGenClassRef(sCmr, sRole.getCmrFieldType().getName());
        NameDef ndsg = gcr.createRefNameDef();
        RdbGenClassMapping gcm = null;
        RdbTable tableGC = null;
        if (sRole.isSourceMultiple()) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Create GenClassReference for the CMR field (Many-Many): " + sCmr));
            }
            gcm = rdbmapping.createGenClassMapping("embedded-target-references", gcr);
            tableGC = gcm.createRdbTable(sRole.getRelation().getJdbcTableName());
            if (sRole.isSlave()) {
                tableGC.setReadOnly(true);
            }
        } else {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Create GenClassReference for the CMR field (One-Many): " + sCmr));
            }
            gcm = rdbmapping.createGenClassMapping("embedded-target-objects", gcr);
            tableGC = gcm.createRdbTable(tEntity.getJdbcTableName());
            tableGC.setReadOnly(true);
            tableGC.setColocated(true);
        }
        classmapping.createReferenceMapping("embedded-target-reference", ndsg);
        if (sEntity.hasSimplePkField()) {
            FieldJdbcDesc fd2 = (FieldJdbcDesc)sEntity.getSimplePkField();
            ndsg.setFieldName(fd2.getName());
        } else {
            NameRef cpk = ndsg.createNameRef(sClass.getNameDef("").getNameRef().getCompositeName());
            Iterator i = sEntity.getCmpFieldDescIterator();
            while (i.hasNext()) {
                fd = (FieldJdbcDesc)i.next();
                if (!fd.isPrimaryKey()) continue;
                cpk.addProjection(fd.getName(), fd.getName());
            }
        }
        String fieldsuffix = sClass == tClass ? (sRole.isSlave() ? "2" : "1") : "";
        NameDef ndid = gcr.createIdNameDef();
        if (sEntity.hasSimplePkField()) {
            fd = (FieldJdbcDesc)sEntity.getSimplePkField();
            String clafn = sAsn + "_" + fd.getName() + fieldsuffix;
            ndid.setFieldName(clafn);
            ScalarField pe = gcr.createHiddenField(clafn, JormType.getPType(fd.getFieldType(), fd.isPrimaryKey()), -1, -1);
            String fkname = tRole.getForeignKeyJdbcName(fd.getJdbcFieldName());
            tableGC.createPrimitiveElementMapping(pe, fkname, fd.getSqlType(), false);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("GC id is mapped over the field: " + clafn + " / column:" + fkname));
            }
        } else {
            NameRef cpk = ndid.createNameRef(sClass.getNameDef("").getNameRef().getCompositeName());
            Iterator i = sEntity.getCmpFieldDescIterator();
            while (i.hasNext()) {
                FieldJdbcDesc fd3 = (FieldJdbcDesc)i.next();
                if (!fd3.isPrimaryKey()) continue;
                String clafn = sAsn + "_" + fd3.getName() + fieldsuffix;
                ScalarField sf = gcr.createHiddenField(clafn, JormType.getPType(fd3.getFieldType(), fd3.isPrimaryKey()), -1, -1);
                cpk.addProjection(fd3.getName(), sf.getName());
                String fkname = tRole.getForeignKeyJdbcName(fd3.getJdbcFieldName());
                tableGC.createPrimitiveElementMapping(sf, fkname, fd3.getSqlType(), false);
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("GC id is mapped over the field: " + clafn + " / column:" + fkname));
            }
        }
        gcm.createIdentifierMapping(ndid);
        fieldsuffix = sClass == tClass ? (tRole.isSlave() ? "2" : "1") : "";
        NameDef ndr2 = gcr.createClassRef(tClass).createRefNameDef();
        gcm.createReferenceMapping("embedded-target-object", ndr2);
        if (tEntity.hasSimplePkField()) {
            FieldJdbcDesc fd4 = (FieldJdbcDesc)tEntity.getSimplePkField();
            String fkname = sRole.isSourceMultiple() ? sRole.getForeignKeyJdbcName(fd4.getJdbcFieldName()) : fd4.getJdbcFieldName();
            ScalarField pe = this.getPrimitiveElementByColumn(gcm, fkname);
            if (pe == null) {
                String clafn = tAsn + "_" + fd4.getName() + fieldsuffix;
                pe = gcr.createHiddenField(clafn, JormType.getPType(fd4.getFieldType(), fd4.isPrimaryKey()), -1, -1);
                tableGC.createPrimitiveElementMapping(pe, fkname, fd4.getSqlType(), false);
            }
            ndr2.setFieldName(pe.getName());
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("GC elem is mapped over the field: " + pe.getName() + " / column:" + fkname));
            }
        } else {
            NameRef cpk = ndr2.createNameRef(tClass.getNameDef("").getNameRef().getCompositeName());
            Iterator i = tEntity.getCmpFieldDescIterator();
            while (i.hasNext()) {
                FieldJdbcDesc fd5 = (FieldJdbcDesc)i.next();
                if (!fd5.isPrimaryKey()) continue;
                String fkname = sRole.isSourceMultiple() ? sRole.getForeignKeyJdbcName(fd5.getJdbcFieldName()) : fd5.getJdbcFieldName();
                ScalarField pe = this.getPrimitiveElementByColumn(gcm, fkname);
                if (pe == null) {
                    String clafn = tAsn + "_" + fd5.getName() + fieldsuffix;
                    pe = gcr.createHiddenField(clafn, JormType.getPType(fd5.getFieldType(), fd5.isPrimaryKey()), -1, -1);
                    tableGC.createPrimitiveElementMapping(pe, fkname, fd5.getSqlType(), false);
                }
                cpk.addProjection(fd5.getName(), pe.getName());
                if (!this.logger.isLoggable(BasicLevel.DEBUG)) continue;
                this.logger.log(BasicLevel.DEBUG, (Object)("GC elem is mapped over the field: " + pe.getName() + " / column:" + fkname));
            }
        }
        this.mip.print("JORM MI for " + sAsn + ": ", sClass, (PrintStream)this.pstream);
        this.mip.print("JORM MI Mapping for " + sAsn + ": ", classmapping, (PrintStream)this.pstream);
    }

    private PrimitiveElement getPrimitiveElementByColumn(RdbClassMultiMapping cm, String col) {
        PrimitiveElementMapping pem = cm.getRdbTable().getPrimitiveElementMappingByCol(col);
        if (pem == null) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("no " + col));
            }
            return null;
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("yes " + col));
        }
        return (PrimitiveElement)pem.getLinkedMO();
    }

    private ScalarField getPrimitiveElementByColumn(RdbGenClassMapping cm, String col) {
        PrimitiveElementMapping pem = cm.getRdbTable().getPrimitiveElementMappingByCol(col);
        if (pem == null) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("no " + col));
            }
            return null;
        }
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("yes " + col));
        }
        return (ScalarField)pem.getLinkedMO();
    }
}

