/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.multitenant.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.LogInfo;
import org.ow2.carol.jndi.intercept.ContextInterceptor;
import org.ow2.carol.jndi.intercept.manager.SingletonInterceptorManager;
import org.ow2.easybeans.persistence.api.EZBPersistenceUnitManager;
import org.ow2.jonas.jmx.Interceptor;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.tenant.TenantIdInfo;
import org.ow2.jonas.lib.tenant.context.TenantContext;
import org.ow2.jonas.lib.tenant.context.TenantCurrent;
import org.ow2.jonas.lib.tenant.filter.HttpTenantIdFilter;
import org.ow2.jonas.lib.tenant.interceptor.jmx.JMXTenantIdInterceptor;
import org.ow2.jonas.lib.tenant.interceptor.jndi.JNDITenantIdInterceptor;
import org.ow2.jonas.lib.tenant.listener.TenantEventListener;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.multitenant.MultitenantService;
import org.ow2.jonas.multitenant.internal.MultitenantVirtualJNDIBinding;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployableInfo;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.api.IEventService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultitenantServiceImpl
extends AbsServiceImpl
implements MultitenantService,
LogInfo,
Pojo {
    private InstanceManager __IM;
    private static Log logger = LogFactory.getLog(MultitenantServiceImpl.class);
    private static JmxService jmxService = null;
    private static RegistryService registryService = null;
    private boolean __FdefaultPolicy;
    private String defaultPolicy;
    private boolean __Fpattern;
    private char pattern;
    private boolean __FjmxTenantIdInterceptor;
    private JMXTenantIdInterceptor jmxTenantIdInterceptor;
    private boolean __FtenantIdAttributeName;
    private String tenantIdAttributeName;
    private boolean __FallowToAccessPlatformMBeans;
    private boolean allowToAccessPlatformMBeans;
    private boolean __FjndiTenantIdInterceptor;
    private JNDITenantIdInterceptor jndiTenantIdInterceptor;
    private boolean __FJNDI_SEPARATOR;
    private final String JNDI_SEPARATOR = "/";
    private boolean __FeventService;
    private IEventService eventService;
    private boolean __FeventListener;
    private TenantEventListener eventListener;
    private boolean __MgetDefaultDeploymentPolicy;
    private boolean __MsetJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MsetRegistryService$org_ow2_jonas_registry_RegistryService;
    private boolean __MsetEventService$org_ow2_util_event_api_IEventService;
    private boolean __MdoStart;
    private boolean __MdoStop;
    private boolean __MgetTenantIdFilter$java_lang_String;
    private boolean __MgetDefaultTenantID;
    private boolean __McreateJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String;
    private boolean __MgetOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MgarbageCollectJNDIBindingMBeans;
    private boolean __MupdatePersistenceUnitManager$org_ow2_easybeans_persistence_api_EZBPersistenceUnitManager$java_lang_String;
    private boolean __MaddTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String;
    private boolean __MgetTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MisMultitenant$org_ow2_util_ee_deploy_api_deployable_IDeployable;
    private boolean __MgetTenantContext;
    private boolean __MgetTenantIdFromContext;
    private boolean __MsetTenantIdInContext$java_lang_String;
    private boolean __MsetTenantContext$java_lang_Object;
    private boolean __MsetInstanceNameInContext$java_lang_String;
    private boolean __MgetInstanceNameFromContext;
    private boolean __MsetTenantIdAndInstanceNameInContext$java_lang_String$java_lang_String;
    private boolean __MgetValue;

    String __getdefaultPolicy() {
        if (!this.__FdefaultPolicy) {
            return this.defaultPolicy;
        }
        return (String)this.__IM.onGet((Object)this, "defaultPolicy");
    }

    void __setdefaultPolicy(String string) {
        if (!this.__FdefaultPolicy) {
            this.defaultPolicy = string;
            return;
        }
        this.__IM.onSet((Object)this, "defaultPolicy", (Object)string);
    }

    char __getpattern() {
        if (!this.__Fpattern) {
            return this.pattern;
        }
        Object object = this.__IM.onGet((Object)this, "pattern");
        Character c = (Character)object;
        return c.charValue();
    }

    void __setpattern(char c) {
        if (!this.__Fpattern) {
            this.pattern = c;
            return;
        }
        Character c2 = new Character(c);
        this.__IM.onSet((Object)this, "pattern", (Object)c2);
    }

    JMXTenantIdInterceptor __getjmxTenantIdInterceptor() {
        if (!this.__FjmxTenantIdInterceptor) {
            return this.jmxTenantIdInterceptor;
        }
        return (JMXTenantIdInterceptor)this.__IM.onGet((Object)this, "jmxTenantIdInterceptor");
    }

    void __setjmxTenantIdInterceptor(JMXTenantIdInterceptor jMXTenantIdInterceptor) {
        if (!this.__FjmxTenantIdInterceptor) {
            this.jmxTenantIdInterceptor = jMXTenantIdInterceptor;
            return;
        }
        this.__IM.onSet((Object)this, "jmxTenantIdInterceptor", (Object)jMXTenantIdInterceptor);
    }

    String __gettenantIdAttributeName() {
        if (!this.__FtenantIdAttributeName) {
            return this.tenantIdAttributeName;
        }
        return (String)this.__IM.onGet((Object)this, "tenantIdAttributeName");
    }

    void __settenantIdAttributeName(String string) {
        if (!this.__FtenantIdAttributeName) {
            this.tenantIdAttributeName = string;
            return;
        }
        this.__IM.onSet((Object)this, "tenantIdAttributeName", (Object)string);
    }

    boolean __getallowToAccessPlatformMBeans() {
        if (!this.__FallowToAccessPlatformMBeans) {
            return this.allowToAccessPlatformMBeans;
        }
        Object object = this.__IM.onGet((Object)this, "allowToAccessPlatformMBeans");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setallowToAccessPlatformMBeans(boolean bl) {
        if (!this.__FallowToAccessPlatformMBeans) {
            this.allowToAccessPlatformMBeans = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "allowToAccessPlatformMBeans", (Object)bl2);
    }

    JNDITenantIdInterceptor __getjndiTenantIdInterceptor() {
        if (!this.__FjndiTenantIdInterceptor) {
            return this.jndiTenantIdInterceptor;
        }
        return (JNDITenantIdInterceptor)this.__IM.onGet((Object)this, "jndiTenantIdInterceptor");
    }

    void __setjndiTenantIdInterceptor(JNDITenantIdInterceptor jNDITenantIdInterceptor) {
        if (!this.__FjndiTenantIdInterceptor) {
            this.jndiTenantIdInterceptor = jNDITenantIdInterceptor;
            return;
        }
        this.__IM.onSet((Object)this, "jndiTenantIdInterceptor", (Object)jNDITenantIdInterceptor);
    }

    String __getJNDI_SEPARATOR() {
        if (!this.__FJNDI_SEPARATOR) {
            return this.JNDI_SEPARATOR;
        }
        return (String)this.__IM.onGet((Object)this, "JNDI_SEPARATOR");
    }

    void __setJNDI_SEPARATOR(String string) {
        if (!this.__FJNDI_SEPARATOR) {
            this.JNDI_SEPARATOR = string;
            return;
        }
        this.__IM.onSet((Object)this, "JNDI_SEPARATOR", (Object)string);
    }

    IEventService __geteventService() {
        if (!this.__FeventService) {
            return this.eventService;
        }
        return (IEventService)this.__IM.onGet((Object)this, "eventService");
    }

    void __seteventService(IEventService iEventService) {
        if (!this.__FeventService) {
            this.eventService = iEventService;
            return;
        }
        this.__IM.onSet((Object)this, "eventService", (Object)iEventService);
    }

    TenantEventListener __geteventListener() {
        if (!this.__FeventListener) {
            return this.eventListener;
        }
        return (TenantEventListener)this.__IM.onGet((Object)this, "eventListener");
    }

    void __seteventListener(TenantEventListener tenantEventListener) {
        if (!this.__FeventListener) {
            this.eventListener = tenantEventListener;
            return;
        }
        this.__IM.onSet((Object)this, "eventListener", (Object)tenantEventListener);
    }

    public MultitenantServiceImpl() {
        this(null);
    }

    private MultitenantServiceImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setdefaultPolicy("Reserved");
        this.__setpattern('T');
        this.__setjmxTenantIdInterceptor(null);
        this.__settenantIdAttributeName("tenant-id");
        this.__setallowToAccessPlatformMBeans(true);
        this.__setjndiTenantIdInterceptor(null);
        this.__setJNDI_SEPARATOR("/");
        this.__seteventService(null);
        this.__seteventListener(null);
    }

    @Override
    public String getDefaultDeploymentPolicy() {
        String string;
        if (!this.__MgetDefaultDeploymentPolicy) {
            return this.__M_getDefaultDeploymentPolicy();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultDeploymentPolicy", new Object[0]);
            string = this.__M_getDefaultDeploymentPolicy();
            this.__IM.onExit((Object)this, "getDefaultDeploymentPolicy", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultDeploymentPolicy", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getDefaultDeploymentPolicy() {
        return this.__getdefaultPolicy();
    }

    public void setJmxService(JmxService jmxService) {
        if (!this.__MsetJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__M_setJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__M_setJmxService(jmxService);
            this.__IM.onExit((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __M_setJmxService(JmxService jmxService) {
        MultitenantServiceImpl.jmxService = jmxService;
    }

    public void setRegistryService(RegistryService registryService) {
        if (!this.__MsetRegistryService$org_ow2_jonas_registry_RegistryService) {
            this.__M_setRegistryService(registryService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", new Object[]{registryService});
            this.__M_setRegistryService(registryService);
            this.__IM.onExit((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", throwable);
            throw throwable;
        }
    }

    private void __M_setRegistryService(RegistryService registryService) {
        MultitenantServiceImpl.registryService = registryService;
    }

    public void setEventService(IEventService iEventService) {
        if (!this.__MsetEventService$org_ow2_util_event_api_IEventService) {
            this.__M_setEventService(iEventService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setEventService$org_ow2_util_event_api_IEventService", new Object[]{iEventService});
            this.__M_setEventService(iEventService);
            this.__IM.onExit((Object)this, "setEventService$org_ow2_util_event_api_IEventService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setEventService$org_ow2_util_event_api_IEventService", throwable);
            throw throwable;
        }
    }

    private void __M_setEventService(IEventService eventService) {
        this.__seteventService(eventService);
    }

    protected void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__M_doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__M_doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __M_doStart() throws ServiceException {
        MultitenantVirtualJNDIBinding.initialize(jmxService, registryService, this);
        jmxService.loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        try {
            jmxService.registerModelMBean((Object)this, JonasObjectName.multitenant((String)this.getDomainName()));
        }
        catch (Exception e) {
            throw new ServiceException("Cannot register 'multitenant' service MBean", (Throwable)e);
        }
        logger.info((Object)"Multitenant service management bean has been registered successfully", new Object[0]);
        this.__seteventListener(new TenantEventListener("/"));
        this.__geteventService().registerListener((IEventListener)this.__geteventListener(), "/easybeans/container/factory/context");
        this.__geteventService().registerListener((IEventListener)this.__geteventListener(), "/easybeans/.*");
        this.__setjmxTenantIdInterceptor(new JMXTenantIdInterceptor(this.__gettenantIdAttributeName(), this.__getallowToAccessPlatformMBeans()));
        jmxService.addInterceptor((Interceptor)this.__getjmxTenantIdInterceptor());
        this.__setjndiTenantIdInterceptor(new JNDITenantIdInterceptor("/"));
        SingletonInterceptorManager.getInterceptorManager().registerContextInterceptor((ContextInterceptor)this.__getjndiTenantIdInterceptor());
    }

    protected void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__M_doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__M_doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __M_doStop() throws ServiceException {
        jmxService.removeInterceptor((Interceptor)this.__getjmxTenantIdInterceptor());
        SingletonInterceptorManager.getInterceptorManager().unregisterContextInterceptor((ContextInterceptor)this.__getjndiTenantIdInterceptor());
        this.__geteventService().unregisterListener((IEventListener)this.__geteventListener());
        jmxService.unregisterMBean(JonasObjectName.multitenant((String)this.getDomainName()));
        logger.info((Object)"Multitenant service management bean has been unregistered successfully", new Object[0]);
    }

    @Override
    public Filter getTenantIdFilter(String string) {
        Filter filter;
        if (!this.__MgetTenantIdFilter$java_lang_String) {
            return this.__M_getTenantIdFilter(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getTenantIdFilter$java_lang_String", new Object[]{string});
            filter = this.__M_getTenantIdFilter(string);
            this.__IM.onExit((Object)this, "getTenantIdFilter$java_lang_String", (Object)filter);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTenantIdFilter$java_lang_String", throwable);
            throw throwable;
        }
        return filter;
    }

    private Filter __M_getTenantIdFilter(String tenantId) {
        return new HttpTenantIdFilter(tenantId);
    }

    @Override
    public String getDefaultTenantID() {
        String string;
        if (!this.__MgetDefaultTenantID) {
            return this.__M_getDefaultTenantID();
        }
        try {
            this.__IM.onEntry((Object)this, "getDefaultTenantID", new Object[0]);
            string = this.__M_getDefaultTenantID();
            this.__IM.onExit((Object)this, "getDefaultTenantID", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDefaultTenantID", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getDefaultTenantID() {
        return "T0";
    }

    @Override
    public void createJNDIBindingMBeans(IDeployable<?> iDeployable, String string) {
        if (!this.__McreateJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String) {
            this.__M_createJNDIBindingMBeans(iDeployable, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String", new Object[]{iDeployable, string});
            this.__M_createJNDIBindingMBeans(iDeployable, string);
            this.__IM.onExit((Object)this, "createJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_createJNDIBindingMBeans(IDeployable<?> deployable, String tenantId) {
        if (this.getDefaultTenantID().equals(tenantId)) {
            logger.warn((Object)"This application has not a specific tenant identifier. Default tenant identifier is used", new Object[0]);
        }
        if (tenantId != null) {
            String applicationName = this.getOriginalDeployable(deployable).getModuleName();
            String prefix = tenantId;
            MultitenantVirtualJNDIBinding.createJNDIBindingMBeans(applicationName, prefix);
        }
    }

    private IDeployable<?> getOriginalDeployable(IDeployable<?> iDeployable) {
        IDeployable<?> iDeployable2;
        if (!this.__MgetOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            return this.__M_getOriginalDeployable(iDeployable);
        }
        try {
            this.__IM.onEntry((Object)this, "getOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            iDeployable2 = this.__M_getOriginalDeployable(iDeployable);
            this.__IM.onExit((Object)this, "getOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable", iDeployable2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
        return iDeployable2;
    }

    private IDeployable<?> __M_getOriginalDeployable(IDeployable<?> deployable) {
        IDeployable originalDeployable = deployable;
        while (originalDeployable.getOriginalDeployable() != null) {
            originalDeployable = originalDeployable.getOriginalDeployable();
        }
        return originalDeployable;
    }

    @Override
    public void garbageCollectJNDIBindingMBeans() {
        if (!this.__MgarbageCollectJNDIBindingMBeans) {
            this.__M_garbageCollectJNDIBindingMBeans();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "garbageCollectJNDIBindingMBeans", new Object[0]);
            this.__M_garbageCollectJNDIBindingMBeans();
            this.__IM.onExit((Object)this, "garbageCollectJNDIBindingMBeans", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "garbageCollectJNDIBindingMBeans", throwable);
            throw throwable;
        }
    }

    private void __M_garbageCollectJNDIBindingMBeans() {
        MultitenantVirtualJNDIBinding.garbageCollectJNDIBindingMBeans();
    }

    @Override
    public void updatePersistenceUnitManager(EZBPersistenceUnitManager eZBPersistenceUnitManager, String string) {
        if (!this.__MupdatePersistenceUnitManager$org_ow2_easybeans_persistence_api_EZBPersistenceUnitManager$java_lang_String) {
            this.__M_updatePersistenceUnitManager(eZBPersistenceUnitManager, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updatePersistenceUnitManager$org_ow2_easybeans_persistence_api_EZBPersistenceUnitManager$java_lang_String", new Object[]{eZBPersistenceUnitManager, string});
            this.__M_updatePersistenceUnitManager(eZBPersistenceUnitManager, string);
            this.__IM.onExit((Object)this, "updatePersistenceUnitManager$org_ow2_easybeans_persistence_api_EZBPersistenceUnitManager$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updatePersistenceUnitManager$org_ow2_easybeans_persistence_api_EZBPersistenceUnitManager$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_updatePersistenceUnitManager(EZBPersistenceUnitManager persistenceUnitManager, String tenantId) {
        String sessionCustomizerProperty = "eclipselink.session.customizer";
        String sessionCustomizerClass = "org.ow2.easybeans.persistence.eclipselink.MultitenantEntitiesSessionCustomizer";
        persistenceUnitManager.setProperty(sessionCustomizerProperty, sessionCustomizerClass);
        String createTablesProperty = "eclipselink.ddl-generation";
        String dropAndCreateTablesValue = "drop-and-create-tables";
        String createTablesValue = "create-tables";
        Map properties = persistenceUnitManager.getProperty(createTablesProperty);
        for (Map.Entry property : properties.entrySet()) {
            if (!((String)property.getValue()).equals(dropAndCreateTablesValue)) continue;
            logger.warn((Object)"This tenant was enabled to drop and create tables. Eclipselink property is changed to only create tables", new Object[0]);
            persistenceUnitManager.setProperty(createTablesProperty, createTablesValue, (String)property.getKey());
        }
        String tenantIdProperty = "eclipselink.tenant-id";
        String tenantIdValue = tenantId;
        persistenceUnitManager.setProperty(tenantIdProperty, tenantIdValue);
        logger.debug((Object)"Tenant id ''{0}'' was propagate to eclipselink", new Object[]{tenantId});
    }

    @Override
    public void addTenantIdDeployableInfo(IDeployable iDeployable, String string) {
        if (!this.__MaddTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String) {
            this.__M_addTenantIdDeployableInfo(iDeployable, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String", new Object[]{iDeployable, string});
            this.__M_addTenantIdDeployableInfo(iDeployable, string);
            this.__IM.onExit((Object)this, "addTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_addTenantIdDeployableInfo(IDeployable deployable, String tenantId) {
        TenantIdInfo tenantIdInfo = new TenantIdInfo();
        tenantIdInfo.setTenantIdInfo(tenantId);
        deployable.addExtension((IDeployableInfo)tenantIdInfo);
    }

    @Override
    public String getTenantIdDeployableInfo(IDeployable iDeployable) {
        String string;
        if (!this.__MgetTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            return this.__M_getTenantIdDeployableInfo(iDeployable);
        }
        try {
            this.__IM.onEntry((Object)this, "getTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            string = this.__M_getTenantIdDeployableInfo(iDeployable);
            this.__IM.onExit((Object)this, "getTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getTenantIdDeployableInfo(IDeployable deployable) {
        if (deployable == null) {
            logger.debug((Object)"Deployable is null", new Object[0]);
            return null;
        }
        IDeployableInfo tenantIdInfo = deployable.getExtension(TenantIdInfo.class);
        String tenantId = null;
        try {
            if (tenantIdInfo != null) {
                tenantId = (String)tenantIdInfo.getClass().getDeclaredMethod("getTenantIdInfo", new Class[0]).invoke((Object)tenantIdInfo, new Object[0]);
            } else {
                logger.debug((Object)"TenantIdInfo was not found in ''{0}''", new Object[]{deployable});
            }
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException("Method was not found", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException("Invocation method fail ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException("Method access fail", (Throwable)e);
        }
        return tenantId;
    }

    @Override
    public boolean isMultitenant(IDeployable iDeployable) {
        boolean bl;
        if (!this.__MisMultitenant$org_ow2_util_ee_deploy_api_deployable_IDeployable) {
            return this.__M_isMultitenant(iDeployable);
        }
        try {
            this.__IM.onEntry((Object)this, "isMultitenant$org_ow2_util_ee_deploy_api_deployable_IDeployable", new Object[]{iDeployable});
            bl = this.__M_isMultitenant(iDeployable);
            this.__IM.onExit((Object)this, "isMultitenant$org_ow2_util_ee_deploy_api_deployable_IDeployable", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isMultitenant$org_ow2_util_ee_deploy_api_deployable_IDeployable", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isMultitenant(IDeployable deployable) {
        String tenantId = this.getTenantIdDeployableInfo(deployable);
        return tenantId != null && !tenantId.equals(this.getDefaultTenantID());
    }

    @Override
    public Object getTenantContext() {
        Object object;
        if (!this.__MgetTenantContext) {
            return this.__M_getTenantContext();
        }
        try {
            this.__IM.onEntry((Object)this, "getTenantContext", new Object[0]);
            object = this.__M_getTenantContext();
            this.__IM.onExit((Object)this, "getTenantContext", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTenantContext", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_getTenantContext() {
        return TenantCurrent.getCurrent().getTenantContext();
    }

    @Override
    public String getTenantIdFromContext() {
        String string;
        if (!this.__MgetTenantIdFromContext) {
            return this.__M_getTenantIdFromContext();
        }
        try {
            this.__IM.onEntry((Object)this, "getTenantIdFromContext", new Object[0]);
            string = this.__M_getTenantIdFromContext();
            this.__IM.onExit((Object)this, "getTenantIdFromContext", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTenantIdFromContext", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getTenantIdFromContext() {
        if (TenantCurrent.getCurrent().getTenantContext() != null) {
            return TenantCurrent.getCurrent().getTenantContext().getTenantId();
        }
        return null;
    }

    @Override
    public void setTenantIdInContext(String string) {
        if (!this.__MsetTenantIdInContext$java_lang_String) {
            this.__M_setTenantIdInContext(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setTenantIdInContext$java_lang_String", new Object[]{string});
            this.__M_setTenantIdInContext(string);
            this.__IM.onExit((Object)this, "setTenantIdInContext$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setTenantIdInContext$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setTenantIdInContext(String tenantId) {
        TenantContext tmp = new TenantContext(tenantId);
        this.setTenantContext(tmp);
    }

    @Override
    public void setTenantContext(Object object) {
        if (!this.__MsetTenantContext$java_lang_Object) {
            this.__M_setTenantContext(object);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setTenantContext$java_lang_Object", new Object[]{object});
            this.__M_setTenantContext(object);
            this.__IM.onExit((Object)this, "setTenantContext$java_lang_Object", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setTenantContext$java_lang_Object", throwable);
            throw throwable;
        }
    }

    private void __M_setTenantContext(Object ctx) {
        TenantCurrent.getCurrent().setTenantContext((TenantContext)ctx);
    }

    @Override
    public void setInstanceNameInContext(String string) {
        if (!this.__MsetInstanceNameInContext$java_lang_String) {
            this.__M_setInstanceNameInContext(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setInstanceNameInContext$java_lang_String", new Object[]{string});
            this.__M_setInstanceNameInContext(string);
            this.__IM.onExit((Object)this, "setInstanceNameInContext$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setInstanceNameInContext$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setInstanceNameInContext(String instanceName) {
        String tenantId = null;
        String jmxSessionTenantId = null;
        if (TenantCurrent.getCurrent().getTenantContext() != null) {
            tenantId = TenantCurrent.getCurrent().getTenantContext().getTenantId();
            jmxSessionTenantId = TenantCurrent.getCurrent().getTenantContext().getJmxSessionTenantId();
        }
        TenantContext tmp = new TenantContext(tenantId, jmxSessionTenantId, instanceName);
        this.setTenantContext(tmp);
    }

    @Override
    public String getInstanceNameFromContext() {
        String string;
        if (!this.__MgetInstanceNameFromContext) {
            return this.__M_getInstanceNameFromContext();
        }
        try {
            this.__IM.onEntry((Object)this, "getInstanceNameFromContext", new Object[0]);
            string = this.__M_getInstanceNameFromContext();
            this.__IM.onExit((Object)this, "getInstanceNameFromContext", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getInstanceNameFromContext", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getInstanceNameFromContext() {
        if (TenantCurrent.getCurrent().getTenantContext() != null) {
            return TenantCurrent.getCurrent().getTenantContext().getInstanceName();
        }
        return null;
    }

    @Override
    public void setTenantIdAndInstanceNameInContext(String string, String string2) {
        if (!this.__MsetTenantIdAndInstanceNameInContext$java_lang_String$java_lang_String) {
            this.__M_setTenantIdAndInstanceNameInContext(string, string2);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setTenantIdAndInstanceNameInContext$java_lang_String$java_lang_String", new Object[]{string, string2});
            this.__M_setTenantIdAndInstanceNameInContext(string, string2);
            this.__IM.onExit((Object)this, "setTenantIdAndInstanceNameInContext$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setTenantIdAndInstanceNameInContext$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setTenantIdAndInstanceNameInContext(String tenantId, String instanceName) {
        TenantContext tmp = new TenantContext(tenantId, null, instanceName);
        this.setTenantContext(tmp);
    }

    public String getValue() {
        String string;
        if (!this.__MgetValue) {
            return this.__M_getValue();
        }
        try {
            this.__IM.onEntry((Object)this, "getValue", new Object[0]);
            string = this.__M_getValue();
            this.__IM.onExit((Object)this, "getValue", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getValue", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getValue() {
        String tenantId = null;
        if (TenantCurrent.getCurrent().getTenantContext() != null) {
            tenantId = TenantCurrent.getCurrent().getTenantContext().getTenantId();
        }
        if (tenantId == null) {
            return "";
        }
        return tenantId;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("JNDI_SEPARATOR")) {
                this.__FJNDI_SEPARATOR = true;
            }
            if (set.contains("allowToAccessPlatformMBeans")) {
                this.__FallowToAccessPlatformMBeans = true;
            }
            if (set.contains("defaultPolicy")) {
                this.__FdefaultPolicy = true;
            }
            if (set.contains("eventListener")) {
                this.__FeventListener = true;
            }
            if (set.contains("eventService")) {
                this.__FeventService = true;
            }
            if (set.contains("jmxTenantIdInterceptor")) {
                this.__FjmxTenantIdInterceptor = true;
            }
            if (set.contains("jndiTenantIdInterceptor")) {
                this.__FjndiTenantIdInterceptor = true;
            }
            if (set.contains("pattern")) {
                this.__Fpattern = true;
            }
            if (set.contains("tenantIdAttributeName")) {
                this.__FtenantIdAttributeName = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getDefaultDeploymentPolicy")) {
                this.__MgetDefaultDeploymentPolicy = true;
            }
            if (set.contains("setJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MsetJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("setRegistryService$org_ow2_jonas_registry_RegistryService")) {
                this.__MsetRegistryService$org_ow2_jonas_registry_RegistryService = true;
            }
            if (set.contains("setEventService$org_ow2_util_event_api_IEventService")) {
                this.__MsetEventService$org_ow2_util_event_api_IEventService = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("getTenantIdFilter$java_lang_String")) {
                this.__MgetTenantIdFilter$java_lang_String = true;
            }
            if (set.contains("getDefaultTenantID")) {
                this.__MgetDefaultTenantID = true;
            }
            if (set.contains("createJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String")) {
                this.__McreateJNDIBindingMBeans$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String = true;
            }
            if (set.contains("getOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MgetOriginalDeployable$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("garbageCollectJNDIBindingMBeans")) {
                this.__MgarbageCollectJNDIBindingMBeans = true;
            }
            if (set.contains("updatePersistenceUnitManager$org_ow2_easybeans_persistence_api_EZBPersistenceUnitManager$java_lang_String")) {
                this.__MupdatePersistenceUnitManager$org_ow2_easybeans_persistence_api_EZBPersistenceUnitManager$java_lang_String = true;
            }
            if (set.contains("addTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String")) {
                this.__MaddTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable$java_lang_String = true;
            }
            if (set.contains("getTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MgetTenantIdDeployableInfo$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("isMultitenant$org_ow2_util_ee_deploy_api_deployable_IDeployable")) {
                this.__MisMultitenant$org_ow2_util_ee_deploy_api_deployable_IDeployable = true;
            }
            if (set.contains("getTenantContext")) {
                this.__MgetTenantContext = true;
            }
            if (set.contains("getTenantIdFromContext")) {
                this.__MgetTenantIdFromContext = true;
            }
            if (set.contains("setTenantIdInContext$java_lang_String")) {
                this.__MsetTenantIdInContext$java_lang_String = true;
            }
            if (set.contains("setTenantContext$java_lang_Object")) {
                this.__MsetTenantContext$java_lang_Object = true;
            }
            if (set.contains("setInstanceNameInContext$java_lang_String")) {
                this.__MsetInstanceNameInContext$java_lang_String = true;
            }
            if (set.contains("getInstanceNameFromContext")) {
                this.__MgetInstanceNameFromContext = true;
            }
            if (set.contains("setTenantIdAndInstanceNameInContext$java_lang_String$java_lang_String")) {
                this.__MsetTenantIdAndInstanceNameInContext$java_lang_String$java_lang_String = true;
            }
            if (set.contains("getValue")) {
                this.__MgetValue = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

