/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.deployment.ws.ServiceRefDesc;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.wsgen.WsGenException;
import org.ow2.jonas.generators.wsgen.ddmodifier.WebServicesDDModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.WsClientDDModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.WsEndpointDDModifier;
import org.ow2.jonas.generators.wsgen.generator.WsClientGenerator;
import org.ow2.jonas.generators.wsgen.generator.WsEndpointGenerator;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;

public abstract class GeneratorFactory
implements org.ow2.jonas.generators.genbase.generator.GeneratorFactory {
    public static final String GENERATOR_FACTORY = "jonas.service.jaxrpc.wsgen.generator.factory";
    public static final String GENERATOR_FACTORY_DEFAULT = "org.ow2.jonas.generators.wsgen.generator.ews.EWSGeneratorFactory";
    private static GeneratorFactory instance = null;
    private static I18n i18n = I18n.getInstance(GeneratorFactory.class);
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.generators.wsgen");
    private Config configuration;

    public static GeneratorFactory getInstance() throws WsGenException {
        if (instance == null) {
            instance = GeneratorFactory.newInstance();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GeneratorFactory newInstance() throws WsGenException {
        String classname = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("jonas.properties");
        if (is == null) {
            classname = GENERATOR_FACTORY_DEFAULT;
        } else {
            Properties jprop = new Properties();
            try {
                jprop.load(is);
                classname = jprop.getProperty(GENERATOR_FACTORY, GENERATOR_FACTORY_DEFAULT);
            }
            catch (IOException e) {
                logger.log(BasicLevel.WARN, (Object)"Cannot get 'jonas.service.jaxrpc.wsgen.generator.factory' value, default used : 'org.ow2.jonas.generators.wsgen.generator.ews.EWSGeneratorFactory'");
                classname = GENERATOR_FACTORY_DEFAULT;
            }
            finally {
                block18: {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (classname != null) break block18;
                        classname = GENERATOR_FACTORY_DEFAULT;
                    }
                }
            }
        }
        GeneratorFactory gf = null;
        try {
            Class<GeneratorFactory> gfc = cl.loadClass(classname).asSubclass(GeneratorFactory.class);
            gf = gfc.newInstance();
        }
        catch (Exception e) {
            cl = GeneratorFactory.class.getClassLoader();
            try {
                Class<GeneratorFactory> gfc = cl.loadClass(classname).asSubclass(GeneratorFactory.class);
                gf = gfc.newInstance();
            }
            catch (Exception e2) {
                String err = i18n.getMessage("GeneratorFactory.newInstance.instance", (Object)classname);
                throw new WsGenException(err, e2);
            }
        }
        return gf;
    }

    public abstract WsClientGenerator newGenerator(ServiceRefDesc var1, WsClientDDModifier var2, Archive var3) throws GenBaseException;

    public abstract WsEndpointGenerator newGenerator(ServiceDesc var1, WsEndpointDDModifier var2, WebServicesDDModifier var3, Archive var4) throws GenBaseException;

    public void setConfiguration(Config config) {
        this.configuration = config;
    }

    public Config getConfiguration() {
        return this.configuration;
    }
}

