/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import org.apache.PeriodicEventListener;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.Constants;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.DummyRequest;
import org.apache.catalina.core.DummyResponse;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapperFacade;
import org.apache.catalina.core.StandardWrapperValve;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.InstanceSupport;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.apache.tomcat.util.modeler.Registry;

public class StandardWrapper
extends ContainerBase
implements ServletConfig,
Wrapper,
NotificationEmitter {
    protected static Log log = LogFactory.getLog(StandardWrapper.class);
    protected static final String[] DEFAULT_SERVLET_METHODS = new String[]{"GET", "HEAD", "POST"};
    protected long available = 0L;
    protected NotificationBroadcasterSupport broadcaster = null;
    protected AtomicInteger countAllocated = new AtomicInteger(0);
    protected StandardWrapperFacade facade = new StandardWrapperFacade(this);
    protected static final String info = "org.apache.catalina.core.StandardWrapper/1.0";
    protected Servlet instance = null;
    protected InstanceSupport instanceSupport = new InstanceSupport(this);
    protected String jspFile = null;
    protected int loadOnStartup = -1;
    protected ArrayList mappings = new ArrayList();
    protected HashMap parameters = new HashMap();
    protected HashMap references = new HashMap();
    protected String runAs = null;
    protected long sequenceNumber = 0L;
    protected String servletClass = null;
    protected boolean singleThreadModel = false;
    protected boolean unloading = false;
    protected int maxInstances = 20;
    protected int nInstances = 0;
    protected Stack instancePool = null;
    protected long unloadDelay = 2000L;
    protected boolean isJspServlet;
    protected ObjectName jspMonitorON;
    protected boolean swallowOutput = false;
    protected StandardWrapperValve swValve;
    protected long loadTime = 0L;
    protected int classLoadTime = 0;
    protected static Class[] classType = new Class[]{ServletConfig.class};
    protected static Class[] classTypeUsedInService = new Class[]{ServletRequest.class, ServletResponse.class};
    protected static Properties restrictedServlets = null;
    private final ReentrantReadWriteLock parametersLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock mappingsLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock referencesLock = new ReentrantReadWriteLock();
    protected MBeanNotificationInfo[] notificationInfo;

    public StandardWrapper() {
        this.swValve = new StandardWrapperValve();
        this.pipeline.setBasic(this.swValve);
        this.broadcaster = new NotificationBroadcasterSupport();
        if (restrictedServlets == null) {
            restrictedServlets = new Properties();
            try {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/core/RestrictedServlets.properties");
                if (is != null) {
                    restrictedServlets.load(is);
                } else {
                    log.error(sm.getString("standardWrapper.restrictedServletsResource"));
                }
            }
            catch (IOException e) {
                log.error(sm.getString("standardWrapper.restrictedServletsResource"), e);
            }
        }
    }

    public long getAvailable() {
        return this.available;
    }

    public void setAvailable(long available) {
        long oldAvailable = this.available;
        this.available = available > System.currentTimeMillis() ? available : 0L;
        this.support.firePropertyChange("available", new Long(oldAvailable), new Long(this.available));
    }

    public int getCountAllocated() {
        return this.countAllocated.get();
    }

    public String getEngineName() {
        return ((StandardContext)this.getParent()).getEngineName();
    }

    public String getInfo() {
        return info;
    }

    public InstanceSupport getInstanceSupport() {
        return this.instanceSupport;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public void setJspFile(String jspFile) {
        String oldJspFile = this.jspFile;
        this.jspFile = jspFile;
        this.support.firePropertyChange("jspFile", oldJspFile, this.jspFile);
        this.isJspServlet = true;
    }

    public int getLoadOnStartup() {
        if (this.isJspServlet && this.loadOnStartup < 0) {
            return Integer.MAX_VALUE;
        }
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(int value) {
        int oldLoadOnStartup = this.loadOnStartup;
        this.loadOnStartup = value;
        this.support.firePropertyChange("loadOnStartup", new Integer(oldLoadOnStartup), new Integer(this.loadOnStartup));
    }

    public void setLoadOnStartupString(String value) {
        try {
            this.setLoadOnStartup(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            this.setLoadOnStartup(0);
        }
    }

    public String getLoadOnStartupString() {
        return Integer.toString(this.getLoadOnStartup());
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public void setMaxInstances(int maxInstances) {
        int oldMaxInstances = this.maxInstances;
        this.maxInstances = maxInstances;
        this.support.firePropertyChange("maxInstances", oldMaxInstances, this.maxInstances);
    }

    public void setParent(Container container) {
        if (container != null && !(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("standardWrapper.notContext"));
        }
        if (container instanceof StandardContext) {
            this.swallowOutput = ((StandardContext)container).getSwallowOutput();
            this.unloadDelay = ((StandardContext)container).getUnloadDelay();
        }
        super.setParent(container);
    }

    public String getRunAs() {
        return this.runAs;
    }

    public void setRunAs(String runAs) {
        String oldRunAs = this.runAs;
        this.runAs = runAs;
        this.support.firePropertyChange("runAs", oldRunAs, this.runAs);
    }

    public String getServletClass() {
        return this.servletClass;
    }

    public void setServletClass(String servletClass) {
        String oldServletClass = this.servletClass;
        this.servletClass = servletClass;
        this.support.firePropertyChange("servletClass", oldServletClass, this.servletClass);
        if ("org.apache.jasper.servlet.JspServlet".equals(servletClass)) {
            this.isJspServlet = true;
        }
    }

    public void setServletName(String name) {
        this.setName(name);
    }

    public boolean isSingleThreadModel() {
        try {
            this.loadServlet();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.singleThreadModel;
    }

    public boolean isUnavailable() {
        if (this.available == 0L) {
            return false;
        }
        if (this.available <= System.currentTimeMillis()) {
            this.available = 0L;
            return false;
        }
        return true;
    }

    public String[] getServletMethods() throws ServletException {
        Class<?> servletClazz = this.loadServlet().getClass();
        if (!HttpServlet.class.isAssignableFrom(servletClazz)) {
            return DEFAULT_SERVLET_METHODS;
        }
        HashSet<String> allow = new HashSet<String>();
        allow.add("TRACE");
        allow.add("OPTIONS");
        Method[] methods = this.getAllDeclaredMethods(servletClazz);
        for (int i = 0; methods != null && i < methods.length; ++i) {
            Method m = methods[i];
            if (m.getName().equals("doGet")) {
                allow.add("GET");
                allow.add("HEAD");
                continue;
            }
            if (m.getName().equals("doPost")) {
                allow.add("POST");
                continue;
            }
            if (m.getName().equals("doPut")) {
                allow.add("PUT");
                continue;
            }
            if (!m.getName().equals("doDelete")) continue;
            allow.add("DELETE");
        }
        String[] methodNames = new String[allow.size()];
        return allow.toArray(methodNames);
    }

    public void backgroundProcess() {
        super.backgroundProcess();
        if (!this.started) {
            return;
        }
        if (this.getServlet() != null && this.getServlet() instanceof PeriodicEventListener) {
            ((PeriodicEventListener)this.getServlet()).periodicEvent();
        }
    }

    public static Throwable getRootCause(ServletException e) {
        Throwable rootCause = e;
        Throwable rootCauseCheck = null;
        int loops = 0;
        do {
            ++loops;
            rootCauseCheck = rootCause.getCause();
            if (rootCauseCheck == null) continue;
            rootCause = rootCauseCheck;
        } while (rootCauseCheck != null && loops < 20);
        return rootCause;
    }

    public void addChild(Container child) {
        throw new IllegalStateException(sm.getString("standardWrapper.notChild"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitParameter(String name, String value) {
        try {
            this.parametersLock.writeLock().lock();
            this.parameters.put(name, value);
        }
        finally {
            this.parametersLock.writeLock().unlock();
        }
        this.fireContainerEvent("addInitParameter", name);
    }

    public void addInstanceListener(InstanceListener listener) {
        this.instanceSupport.addInstanceListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMapping(String mapping) {
        try {
            this.mappingsLock.writeLock().lock();
            this.mappings.add(mapping);
        }
        finally {
            this.mappingsLock.writeLock().unlock();
        }
        this.fireContainerEvent("addMapping", mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecurityReference(String name, String link) {
        try {
            this.referencesLock.writeLock().lock();
            this.references.put(name, link);
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
        this.fireContainerEvent("addSecurityReference", name);
    }

    public Servlet getServlet() {
        return this.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet allocate() throws ServletException {
        Serializable serializable;
        if (this.unloading) {
            throw new ServletException(sm.getString("standardWrapper.unloading", this.getName()));
        }
        boolean newInstance = false;
        if (!this.singleThreadModel) {
            if (this.instance == null) {
                serializable = this;
                synchronized (serializable) {
                    if (this.instance == null) {
                        try {
                            if (log.isDebugEnabled()) {
                                log.debug("Allocating non-STM instance");
                            }
                            this.instance = this.loadServlet();
                            if (!this.singleThreadModel) {
                                newInstance = true;
                                this.countAllocated.incrementAndGet();
                            }
                        }
                        catch (ServletException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            throw new ServletException(sm.getString("standardWrapper.allocate"), e);
                        }
                    }
                }
            }
            if (!this.singleThreadModel) {
                if (log.isTraceEnabled()) {
                    log.trace("  Returning non-STM instance");
                }
                if (!newInstance) {
                    this.countAllocated.incrementAndGet();
                }
                return this.instance;
            }
        }
        serializable = this.instancePool;
        synchronized (serializable) {
            while (this.countAllocated.get() >= this.nInstances) {
                if (this.nInstances < this.maxInstances) {
                    try {
                        this.instancePool.push(this.loadServlet());
                        ++this.nInstances;
                        continue;
                    }
                    catch (ServletException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new ServletException(sm.getString("standardWrapper.allocate"), e);
                    }
                }
                try {
                    this.instancePool.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (log.isTraceEnabled()) {
                log.trace("  Returning allocated STM instance");
            }
            this.countAllocated.incrementAndGet();
            return (Servlet)this.instancePool.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate(Servlet servlet) throws ServletException {
        if (!this.singleThreadModel) {
            this.countAllocated.decrementAndGet();
            return;
        }
        Stack stack = this.instancePool;
        synchronized (stack) {
            this.countAllocated.decrementAndGet();
            this.instancePool.push(servlet);
            this.instancePool.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findInitParameter(String name) {
        try {
            this.parametersLock.readLock().lock();
            String string = (String)this.parameters.get(name);
            return string;
        }
        finally {
            this.parametersLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findInitParameters() {
        try {
            this.parametersLock.readLock().lock();
            String[] results = new String[this.parameters.size()];
            String[] stringArray = this.parameters.keySet().toArray(results);
            return stringArray;
        }
        finally {
            this.parametersLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findMappings() {
        try {
            this.mappingsLock.readLock().lock();
            String[] stringArray = this.mappings.toArray(new String[this.mappings.size()]);
            return stringArray;
        }
        finally {
            this.mappingsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findSecurityReference(String name) {
        try {
            this.referencesLock.readLock().lock();
            String string = (String)this.references.get(name);
            return string;
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findSecurityReferences() {
        try {
            this.referencesLock.readLock().lock();
            String[] results = new String[this.references.size()];
            String[] stringArray = this.references.keySet().toArray(results);
            return stringArray;
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
    }

    public Wrapper findMappingObject() {
        return (Wrapper)this.getMappingObject();
    }

    public synchronized void load() throws ServletException {
        this.instance = this.loadServlet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Servlet loadServlet() throws ServletException {
        Servlet servlet;
        if (!this.singleThreadModel && this.instance != null) {
            return this.instance;
        }
        PrintStream out = System.out;
        if (this.swallowOutput) {
            SystemLogHandler.startCapture();
        }
        try {
            Wrapper jspWrapper;
            long t1 = System.currentTimeMillis();
            String actualClass = this.servletClass;
            if (actualClass == null && this.jspFile != null && (jspWrapper = (Wrapper)((Context)this.getParent()).findChild("jsp")) != null) {
                actualClass = jspWrapper.getServletClass();
                String[] paramNames = jspWrapper.findInitParameters();
                for (int i = 0; i < paramNames.length; ++i) {
                    if (this.parameters.get(paramNames[i]) != null) continue;
                    this.parameters.put(paramNames[i], jspWrapper.findInitParameter(paramNames[i]));
                }
            }
            if (actualClass == null) {
                this.unavailable(null);
                throw new ServletException(sm.getString("standardWrapper.notClass", this.getName()));
            }
            Loader loader = this.getLoader();
            if (loader == null) {
                this.unavailable(null);
                throw new ServletException(sm.getString("standardWrapper.missingLoader", this.getName()));
            }
            ClassLoader classLoader = loader.getClassLoader();
            if (this.isContainerProvidedServlet(actualClass) && !((Context)this.getParent()).getPrivileged()) {
                classLoader = this.getClass().getClassLoader();
            }
            Class<Object> classClass = null;
            try {
                if (SecurityUtil.isPackageProtectionEnabled()) {
                    final ClassLoader fclassLoader = classLoader;
                    final String factualClass = actualClass;
                    try {
                        classClass = (Class<Object>)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                if (fclassLoader != null) {
                                    return fclassLoader.loadClass(factualClass);
                                }
                                return Class.forName(factualClass);
                            }
                        });
                    }
                    catch (PrivilegedActionException pax) {
                        Exception ex = pax.getException();
                        if (ex instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)ex;
                        }
                        this.getServletContext().log("Error loading " + fclassLoader + " " + factualClass, (Throwable)ex);
                    }
                } else {
                    classClass = classLoader != null ? classLoader.loadClass(actualClass) : Class.forName(actualClass);
                }
            }
            catch (ClassNotFoundException e) {
                this.unavailable(null);
                this.getServletContext().log("Error loading " + classLoader + " " + actualClass, (Throwable)e);
                throw new ServletException(sm.getString("standardWrapper.missingClass", actualClass), (Throwable)e);
            }
            if (classClass == null) {
                this.unavailable(null);
                throw new ServletException(sm.getString("standardWrapper.missingClass", actualClass));
            }
            try {
                servlet = (Servlet)classClass.newInstance();
                if (!((Context)this.getParent()).getIgnoreAnnotations() && this.getParent() instanceof StandardContext) {
                    ((StandardContext)this.getParent()).getAnnotationProcessor().processAnnotations(servlet);
                    ((StandardContext)this.getParent()).getAnnotationProcessor().postConstruct(servlet);
                }
            }
            catch (ClassCastException e) {
                this.unavailable(null);
                throw new ServletException(sm.getString("standardWrapper.notServlet", actualClass), (Throwable)e);
            }
            catch (Throwable e) {
                this.unavailable(null);
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("standardWrapper.instantiate", actualClass), e);
                }
                throw new ServletException(sm.getString("standardWrapper.instantiate", actualClass), e);
            }
            if (!this.isServletAllowed(servlet)) {
                throw new SecurityException(sm.getString("standardWrapper.privilegedServlet", actualClass));
            }
            if (servlet instanceof ContainerServlet && (this.isContainerProvidedServlet(actualClass) || ((Context)this.getParent()).getPrivileged())) {
                ((ContainerServlet)servlet).setWrapper(this);
            }
            this.classLoadTime = (int)(System.currentTimeMillis() - t1);
            try {
                this.instanceSupport.fireInstanceEvent("beforeInit", servlet);
                if (Globals.IS_SECURITY_ENABLED) {
                    Object[] args = new Object[]{this.facade};
                    SecurityUtil.doAsPrivilege("init", servlet, classType, args);
                    args = null;
                } else {
                    servlet.init((ServletConfig)this.facade);
                }
                if (this.loadOnStartup >= 0 && this.jspFile != null) {
                    DummyRequest req = new DummyRequest();
                    req.setServletPath(this.jspFile);
                    req.setQueryString(Constants.PRECOMPILE + "=true");
                    DummyResponse res = new DummyResponse();
                    if (Globals.IS_SECURITY_ENABLED) {
                        Object[] args = new Object[]{req, res};
                        SecurityUtil.doAsPrivilege("service", servlet, classTypeUsedInService, args);
                        args = null;
                    } else {
                        servlet.service((ServletRequest)req, (ServletResponse)res);
                    }
                }
                this.instanceSupport.fireInstanceEvent("afterInit", servlet);
            }
            catch (UnavailableException f) {
                this.instanceSupport.fireInstanceEvent("afterInit", servlet, (Throwable)f);
                this.unavailable(f);
                throw f;
            }
            catch (ServletException f) {
                this.instanceSupport.fireInstanceEvent("afterInit", servlet, (Throwable)f);
                throw f;
            }
            catch (Throwable f) {
                this.getServletContext().log("StandardWrapper.Throwable", f);
                this.instanceSupport.fireInstanceEvent("afterInit", servlet, f);
                throw new ServletException(sm.getString("standardWrapper.initException", this.getName()), f);
            }
            this.singleThreadModel = servlet instanceof SingleThreadModel;
            if (this.singleThreadModel && this.instancePool == null) {
                this.instancePool = new Stack();
            }
            this.fireContainerEvent("load", this);
            this.loadTime = System.currentTimeMillis() - t1;
        }
        finally {
            String log;
            if (this.swallowOutput && (log = SystemLogHandler.stopCapture()) != null && log.length() > 0) {
                if (this.getServletContext() != null) {
                    this.getServletContext().log(log);
                } else {
                    out.println(log);
                }
            }
        }
        return servlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInitParameter(String name) {
        try {
            this.parametersLock.writeLock().lock();
            this.parameters.remove(name);
        }
        finally {
            this.parametersLock.writeLock().unlock();
        }
        this.fireContainerEvent("removeInitParameter", name);
    }

    public void removeInstanceListener(InstanceListener listener) {
        this.instanceSupport.removeInstanceListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapping(String mapping) {
        try {
            this.mappingsLock.writeLock().lock();
            this.mappings.remove(mapping);
        }
        finally {
            this.mappingsLock.writeLock().unlock();
        }
        this.fireContainerEvent("removeMapping", mapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityReference(String name) {
        try {
            this.referencesLock.writeLock().lock();
            this.references.remove(name);
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
        this.fireContainerEvent("removeSecurityReference", name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardWrapper[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public void unavailable(UnavailableException unavailable) {
        this.getServletContext().log(sm.getString("standardWrapper.unavailable", this.getName()));
        if (unavailable == null) {
            this.setAvailable(Long.MAX_VALUE);
        } else if (unavailable.isPermanent()) {
            this.setAvailable(Long.MAX_VALUE);
        } else {
            int unavailableSeconds = unavailable.getUnavailableSeconds();
            if (unavailableSeconds <= 0) {
                unavailableSeconds = 60;
            }
            this.setAvailable(System.currentTimeMillis() + (long)unavailableSeconds * 1000L);
        }
    }

    public synchronized void unload() throws ServletException {
        if (!this.singleThreadModel && this.instance == null) {
            return;
        }
        this.unloading = true;
        if (this.countAllocated.get() > 0) {
            long delay = this.unloadDelay / 20L;
            for (int nRetries = 0; nRetries < 21 && this.countAllocated.get() > 0; ++nRetries) {
                if (nRetries % 10 == 0) {
                    log.info(sm.getString("standardWrapper.waiting", this.countAllocated.toString()));
                }
                try {
                    Thread.sleep(delay);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        PrintStream out = System.out;
        if (this.swallowOutput) {
            SystemLogHandler.startCapture();
        }
        try {
            this.instanceSupport.fireInstanceEvent("beforeDestroy", this.instance);
            if (Globals.IS_SECURITY_ENABLED) {
                SecurityUtil.doAsPrivilege("destroy", this.instance);
                SecurityUtil.remove(this.instance);
            } else {
                this.instance.destroy();
            }
            this.instanceSupport.fireInstanceEvent("afterDestroy", this.instance);
            if (!((Context)this.getParent()).getIgnoreAnnotations()) {
                ((StandardContext)this.getParent()).getAnnotationProcessor().preDestroy(this.instance);
            }
        }
        catch (Throwable t) {
            this.instanceSupport.fireInstanceEvent("afterDestroy", this.instance, t);
            this.instance = null;
            this.instancePool = null;
            this.nInstances = 0;
            this.fireContainerEvent("unload", this);
            this.unloading = false;
            throw new ServletException(sm.getString("standardWrapper.destroyException", this.getName()), t);
        }
        finally {
            String log;
            if (this.swallowOutput && (log = SystemLogHandler.stopCapture()) != null && log.length() > 0) {
                if (this.getServletContext() != null) {
                    this.getServletContext().log(log);
                } else {
                    out.println(log);
                }
            }
        }
        this.instance = null;
        if (this.singleThreadModel && this.instancePool != null) {
            try {
                while (!this.instancePool.isEmpty()) {
                    Servlet s = (Servlet)this.instancePool.pop();
                    if (Globals.IS_SECURITY_ENABLED) {
                        SecurityUtil.doAsPrivilege("destroy", s);
                        SecurityUtil.remove(this.instance);
                    } else {
                        s.destroy();
                    }
                    if (((Context)this.getParent()).getIgnoreAnnotations()) continue;
                    ((StandardContext)this.getParent()).getAnnotationProcessor().preDestroy(s);
                }
            }
            catch (Throwable t) {
                this.instancePool = null;
                this.nInstances = 0;
                this.unloading = false;
                this.fireContainerEvent("unload", this);
                throw new ServletException(sm.getString("standardWrapper.destroyException", this.getName()), t);
            }
            this.instancePool = null;
            this.nInstances = 0;
        }
        this.singleThreadModel = false;
        this.unloading = false;
        this.fireContainerEvent("unload", this);
    }

    public String getInitParameter(String name) {
        return this.findInitParameter(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getInitParameterNames() {
        try {
            this.parametersLock.readLock().lock();
            Enumerator enumerator = new Enumerator(this.parameters.keySet());
            return enumerator;
        }
        finally {
            this.parametersLock.readLock().unlock();
        }
    }

    public ServletContext getServletContext() {
        if (this.parent == null) {
            return null;
        }
        if (!(this.parent instanceof Context)) {
            return null;
        }
        return ((Context)this.parent).getServletContext();
    }

    public String getServletName() {
        return this.getName();
    }

    public long getProcessingTime() {
        return this.swValve.getProcessingTime();
    }

    public void setProcessingTime(long processingTime) {
        this.swValve.setProcessingTime(processingTime);
    }

    public long getMaxTime() {
        return this.swValve.getMaxTime();
    }

    public void setMaxTime(long maxTime) {
        this.swValve.setMaxTime(maxTime);
    }

    public long getMinTime() {
        return this.swValve.getMinTime();
    }

    public void setMinTime(long minTime) {
        this.swValve.setMinTime(minTime);
    }

    public int getRequestCount() {
        return this.swValve.getRequestCount();
    }

    public void setRequestCount(int requestCount) {
        this.swValve.setRequestCount(requestCount);
    }

    public int getErrorCount() {
        return this.swValve.getErrorCount();
    }

    public void setErrorCount(int errorCount) {
        this.swValve.setErrorCount(errorCount);
    }

    public void incrementErrorCount() {
        this.swValve.setErrorCount(this.swValve.getErrorCount() + 1);
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public void setLoadTime(long loadTime) {
        this.loadTime = loadTime;
    }

    public int getClassLoadTime() {
        return this.classLoadTime;
    }

    protected void addDefaultMapper(String mapperClass) {
    }

    protected boolean isContainerProvidedServlet(String classname) {
        if (classname.startsWith("org.apache.catalina.")) {
            return true;
        }
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(classname);
            return ContainerServlet.class.isAssignableFrom(clazz);
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected boolean isServletAllowed(Object servlet) {
        if (((Context)this.getParent()).getPrivileged()) {
            return true;
        }
        if (servlet instanceof ContainerServlet) {
            return false;
        }
        for (Class<?> clazz = servlet.getClass(); clazz != null && !clazz.getName().equals("javax.servlet.http.HttpServlet"); clazz = clazz.getSuperclass()) {
            if (!"restricted".equals(restrictedServlets.getProperty(clazz.getName()))) continue;
            return false;
        }
        return true;
    }

    protected Method[] getAllDeclaredMethods(Class c) {
        if (c.equals(HttpServlet.class)) {
            return null;
        }
        Method[] parentMethods = this.getAllDeclaredMethods(c.getSuperclass());
        Method[] thisMethods = c.getDeclaredMethods();
        if (thisMethods == null) {
            return parentMethods;
        }
        if (parentMethods != null && parentMethods.length > 0) {
            Method[] allMethods = new Method[parentMethods.length + thisMethods.length];
            System.arraycopy(parentMethods, 0, allMethods, 0, parentMethods.length);
            System.arraycopy(thisMethods, 0, allMethods, parentMethods.length, thisMethods.length);
            thisMethods = allMethods;
        }
        return thisMethods;
    }

    public void start() throws LifecycleException {
        Notification notification;
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.starting", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        super.start();
        if (this.oname != null) {
            this.registerJMX((StandardContext)this.getParent());
        }
        this.setAvailable(0L);
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.running", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
    }

    public void stop() throws LifecycleException {
        Notification notification;
        this.setAvailable(Long.MAX_VALUE);
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.stopping", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        try {
            this.unload();
        }
        catch (ServletException e) {
            this.getServletContext().log(sm.getString("standardWrapper.unloadException", this.getName()), (Throwable)e);
        }
        super.stop();
        if (this.getObjectName() != null) {
            notification = new Notification("j2ee.state.stopped", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        if (this.oname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.oname);
            notification = new Notification("j2ee.object.deleted", this.getObjectName(), this.sequenceNumber++);
            this.broadcaster.sendNotification(notification);
        }
        if (this.isJspServlet && this.jspMonitorON != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.jspMonitorON);
        }
    }

    protected void registerJMX(StandardContext ctx) {
        String parentName = ctx.getName();
        parentName = "".equals(parentName) ? "/" : parentName;
        String hostName = ctx.getParent().getName();
        hostName = hostName == null ? "DEFAULT" : hostName;
        String domain = ctx.getDomain();
        String webMod = "//" + hostName + parentName;
        String onameStr = domain + ":j2eeType=Servlet,name=" + this.getName() + ",WebModule=" + webMod + ",J2EEApplication=" + ctx.getJ2EEApplication() + ",J2EEServer=" + ctx.getJ2EEServer();
        try {
            this.controller = this.oname = new ObjectName(onameStr);
            Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            if (this.getObjectName() != null) {
                Notification notification = new Notification("j2ee.object.created", this.getObjectName(), this.sequenceNumber++);
                this.broadcaster.sendNotification(notification);
            }
        }
        catch (Exception ex) {
            log.info("Error registering servlet with jmx " + this, ex);
        }
        if (this.isJspServlet) {
            onameStr = domain + ":type=JspMonitor,name=" + this.getName() + ",WebModule=" + webMod + ",J2EEApplication=" + ctx.getJ2EEApplication() + ",J2EEServer=" + ctx.getJ2EEServer();
            try {
                this.jspMonitorON = new ObjectName(onameStr);
                Registry.getRegistry(null, null).registerComponent((Object)this.instance, this.jspMonitorON, null);
            }
            catch (Exception ex) {
                log.info("Error registering JSP monitoring with jmx " + this.instance, ex);
            }
        }
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, object);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notificationInfo == null) {
            this.notificationInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"j2ee.object.created"}, Notification.class.getName(), "servlet is created"), new MBeanNotificationInfo(new String[]{"j2ee.state.starting"}, Notification.class.getName(), "servlet is starting"), new MBeanNotificationInfo(new String[]{"j2ee.state.running"}, Notification.class.getName(), "servlet is running"), new MBeanNotificationInfo(new String[]{"j2ee.state.stopped"}, Notification.class.getName(), "servlet start to stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.stopped"}, Notification.class.getName(), "servlet is stopped"), new MBeanNotificationInfo(new String[]{"j2ee.object.deleted"}, Notification.class.getName(), "servlet is deleted")};
        }
        return this.notificationInfo;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, object);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    public boolean isEventProvider() {
        return false;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }
}

