/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.jsf.mojarra20.vendor;

import com.sun.faces.spi.DiscoverableInjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;

public class Tomcat7InjectionProvider
extends DiscoverableInjectionProvider {
    private ServletContext servletContext;
    private Object instanceManager = null;
    private Method newInstanceMethod = null;
    private Method destroyInstanceMethod = null;

    public Tomcat7InjectionProvider(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.instanceManager = servletContext.getAttribute("org.apache.tomcat.InstanceManager");
        if (this.instanceManager != null) {
            try {
                this.newInstanceMethod = this.instanceManager.getClass().getMethod("newInstance", Object.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to get method", e);
            }
            try {
                this.destroyInstanceMethod = this.instanceManager.getClass().getMethod("destroyInstance", Object.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to get method", e);
            }
        }
    }

    public void inject(Object managedBean) throws InjectionProviderException {
        if (this.newInstanceMethod == null) {
            throw new InjectionProviderException(new Exception("The newInstance method has not been initialized. Check that you're using Tomcat7"));
        }
        try {
            this.newInstanceMethod.invoke(this.instanceManager, managedBean);
        }
        catch (Exception e) {
            throw new InjectionProviderException(e);
        }
    }

    public void invokePreDestroy(Object managedBean) throws InjectionProviderException {
        if (this.destroyInstanceMethod == null) {
            throw new InjectionProviderException(new Exception("The destroyInstance method has not been initialized. Check that you're using Tomcat7"));
        }
        try {
            this.destroyInstanceMethod.invoke(this.instanceManager, managedBean);
        }
        catch (Exception e) {
            throw new InjectionProviderException(e);
        }
    }

    public void invokePostConstruct(Object managedBean) throws InjectionProviderException {
    }
}

