/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.prompt;

import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.service.command.CommandSession;
import org.fusesource.jansi.Ansi;
import org.ow2.shelbie.core.IPromptProvider;
import org.ow2.shelbie.core.internal.prompt.CommandSessionResolver;
import org.ow2.util.substitution.ISubstitutionEngine;
import org.ow2.util.substitution.engine.DefaultSubstitutionEngine;
import org.ow2.util.substitution.resolver.ChainedResolver;
import org.ow2.util.substitution.resolver.FallbackResolver;
import org.ow2.util.substitution.resolver.PropertiesResolver;
import org.ow2.util.substitution.resolver.RecursiveResolver;

@Component
@Provides
public class DefaultPromptProvider
implements IPromptProvider,
Pojo {
    private InstanceManager __IM;
    private static final String DEFAULT_PROMPT = "${user.name}@${application.name}$ ";
    private static final String ERROR_PROMPT = "[gogo]$ ";
    private boolean __MgetPrompt$org_apache_felix_service_command_CommandSession;
    private boolean __McreateEngine$org_apache_felix_service_command_CommandSession;
    private boolean __MprintDebug$org_apache_felix_service_command_CommandSession$java_lang_String;

    public DefaultPromptProvider() {
        this(null);
    }

    private DefaultPromptProvider(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public String getPrompt(CommandSession commandSession) {
        String string;
        if (!this.__MgetPrompt$org_apache_felix_service_command_CommandSession) {
            return this.__M_getPrompt(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "getPrompt$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            string = this.__M_getPrompt(commandSession);
            this.__IM.onExit((Object)this, "getPrompt$org_apache_felix_service_command_CommandSession", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getPrompt$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getPrompt(CommandSession session) {
        String prompt = (String)session.get("prompt");
        if (prompt == null) {
            prompt = DEFAULT_PROMPT;
        }
        ISubstitutionEngine engine = this.createEngine(session);
        try {
            return engine.substitute(prompt);
        }
        catch (Throwable t) {
            this.printDebug(session, "Cannot interpolate prompt '" + prompt + "'. Error: " + t.getMessage());
            return ERROR_PROMPT;
        }
    }

    private ISubstitutionEngine createEngine(CommandSession commandSession) {
        ISubstitutionEngine iSubstitutionEngine;
        if (!this.__McreateEngine$org_apache_felix_service_command_CommandSession) {
            return this.__M_createEngine(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "createEngine$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            iSubstitutionEngine = this.__M_createEngine(commandSession);
            this.__IM.onExit((Object)this, "createEngine$org_apache_felix_service_command_CommandSession", (Object)iSubstitutionEngine);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createEngine$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return iSubstitutionEngine;
    }

    private ISubstitutionEngine __M_createEngine(CommandSession session) {
        DefaultSubstitutionEngine engine = new DefaultSubstitutionEngine();
        engine.setMarkerChar('$');
        engine.setOpeningChar('{');
        engine.setEndingChar('}');
        ChainedResolver chained = new ChainedResolver();
        chained.getResolvers().add(new CommandSessionResolver(session));
        chained.getResolvers().add(new PropertiesResolver(System.getProperties()));
        chained.getResolvers().add(new FallbackResolver());
        RecursiveResolver recursive = new RecursiveResolver(engine, chained);
        engine.setResolver(recursive);
        return engine;
    }

    private void printDebug(CommandSession commandSession, String string) {
        if (!this.__MprintDebug$org_apache_felix_service_command_CommandSession$java_lang_String) {
            this.__M_printDebug(commandSession, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printDebug$org_apache_felix_service_command_CommandSession$java_lang_String", new Object[]{commandSession, string});
            this.__M_printDebug(commandSession, string);
            this.__IM.onExit((Object)this, "printDebug$org_apache_felix_service_command_CommandSession$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printDebug$org_apache_felix_service_command_CommandSession$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_printDebug(CommandSession session, String message) {
        String error = Ansi.ansi().fg(Ansi.Color.GREEN).a("Debug: ").reset().toString();
        session.getConsole().println(error + message);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            // empty if block
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getPrompt$org_apache_felix_service_command_CommandSession")) {
                this.__MgetPrompt$org_apache_felix_service_command_CommandSession = true;
            }
            if (set.contains("createEngine$org_apache_felix_service_command_CommandSession")) {
                this.__McreateEngine$org_apache_felix_service_command_CommandSession = true;
            }
            if (set.contains("printDebug$org_apache_felix_service_command_CommandSession$java_lang_String")) {
                this.__MprintDebug$org_apache_felix_service_command_CommandSession$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

