/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.security;

import fr.dyade.aaa.common.stream.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.util.monolog.api.BasicLevel;

public class SimpleIdentity
extends Identity {
    private static final long serialVersionUID = 1L;
    private String user;
    private String passwd;

    public String getUserName() {
        return this.user;
    }

    public void setUserName(String userName) {
        this.user = userName;
    }

    public void setIdentity(String user, String passwd) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("setIdentity(" + user + ", ****)"));
        }
        this.user = user;
        this.passwd = passwd;
    }

    public boolean check(Identity identity) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SimpleIdentity.check(" + identity + ')'));
        }
        if (!(identity instanceof SimpleIdentity)) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)("check : SimpleIdentity is expected for " + identity));
            }
            throw new Exception("check : SimpleIdentity is expected for " + identity);
        }
        if (!this.getUserName().equals(identity.getUserName())) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)("Invalid user [" + this.getUserName() + "] wait [" + identity.getUserName() + "]"));
            }
            throw new Exception("Invalid user [" + this.getUserName() + "] wait [" + identity.getUserName() + "]");
        }
        if (!this.passwd.equals(((SimpleIdentity)identity).passwd)) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)("Invalid credential for user [" + identity.getUserName() + "]"));
            }
            throw new Exception("Invalid credential for user [" + identity.getUserName() + "]");
        }
        return true;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(super.toString()).append('(');
        buff.append("user=").append(this.user);
        buff.append(')');
        return buff.toString();
    }

    public void readFrom(InputStream is) throws IOException {
        this.user = StreamUtil.readStringFrom((InputStream)is);
        this.passwd = StreamUtil.readStringFrom((InputStream)is);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SimpleIdentity.readFrom: user=" + this.user));
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("SimpleIdentity.writeTo: user=" + this.user));
        }
        StreamUtil.writeTo((String)this.user, (OutputStream)os);
        StreamUtil.writeTo((String)this.passwd, (OutputStream)os);
    }
}

