/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.raconfig;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.naming.Context;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.rar.ConfigPropertyDesc;
import org.ow2.jonas.deployment.rar.RarDeploymentDesc;
import org.ow2.jonas.deployment.rar.RarDeploymentDescException;
import org.ow2.jonas.deployment.rar.lib.RarDeploymentDescManager;
import org.ow2.jonas.deployment.rar.xml.Activationspec;
import org.ow2.jonas.deployment.rar.xml.Adminobject;
import org.ow2.jonas.deployment.rar.xml.ConfigProperty;
import org.ow2.jonas.deployment.rar.xml.ConnectionDefinition;
import org.ow2.jonas.deployment.rar.xml.Connector;
import org.ow2.jonas.deployment.rar.xml.InboundResourceadapter;
import org.ow2.jonas.deployment.rar.xml.JdbcConnParams;
import org.ow2.jonas.deployment.rar.xml.JonasActivationspec;
import org.ow2.jonas.deployment.rar.xml.JonasAdminobject;
import org.ow2.jonas.deployment.rar.xml.JonasConfigProperty;
import org.ow2.jonas.deployment.rar.xml.JonasConnectionDefinition;
import org.ow2.jonas.deployment.rar.xml.JonasConnector;
import org.ow2.jonas.deployment.rar.xml.JonasSecurityMapping;
import org.ow2.jonas.deployment.rar.xml.Messageadapter;
import org.ow2.jonas.deployment.rar.xml.Messagelistener;
import org.ow2.jonas.deployment.rar.xml.OutboundResourceadapter;
import org.ow2.jonas.deployment.rar.xml.PoolParams;
import org.ow2.jonas.deployment.rar.xml.Resourceadapter;
import org.ow2.jonas.deployment.rar.xml.SecurityEntry;
import org.ow2.jonas.generators.raconfig.RAConfigException;
import org.ow2.jonas.lib.naming.ComponentContext;
import org.ow2.jonas.lib.util.Base64;

public class RAConfig {
    private static final int BUFFER_SIZE = 500;
    private static final double JCA_1_5 = 1.5;
    private static final double JCA_1_0 = 1.0;
    RarDeploymentDesc rarDD = null;
    private static boolean validation = true;
    private static final String JONAS_RA_FILENAME = "META-INF/jonas-ra.xml";

    public RAConfig(String fileName) throws RAConfigException {
        ClassLoader curLoader = Thread.currentThread().getContextClassLoader();
        try {
            RarDeploymentDescManager.setParsingWithValidation((boolean)validation);
            this.rarDD = this.getRarDD(fileName, curLoader);
        }
        catch (Exception e) {
            throw new RAConfigException(e);
        }
    }

    private RarDeploymentDesc getRarDD(String rarFileName, ClassLoader classLoader) throws DeploymentDescException {
        ComponentContext contctx = null;
        try {
            contctx = new ComponentContext(rarFileName);
            contctx.rebind("rarFileName", (Object)rarFileName);
            contctx.rebind("classloader", (Object)classLoader);
        }
        catch (Exception e) {
            throw new RarDeploymentDescException("Error during the deployment", (Throwable)e);
        }
        return RarDeploymentDescManager.getInstance((Context)contctx);
    }

    public RarDeploymentDesc getRarDeploymentDesc() {
        return this.rarDD;
    }

    private static void buildXML(String fileInputName, String jndiname, String rarlink, Properties dbProps, boolean encrypt, String securityfile, String path, boolean isVerbose, boolean createNew) throws RAConfigException {
        boolean ext;
        if (!createNew && (ext = RAConfig.extractJonasRAXml(fileInputName, path))) {
            return;
        }
        RAConfig raxml = new RAConfig(fileInputName);
        Connector conn = raxml.getRarDeploymentDesc().getConnector();
        double specVersion = 0.0;
        ConfigPropertyDesc[] raProps = raxml.getRarDeploymentDesc().getRaConfigPropTags();
        if (raProps == null) {
            throw new RAConfigException("RAR file doesn't contain ra.xml");
        }
        if (conn.getSpecVersion().equals("1.0")) {
            specVersion = 1.0;
        } else if (conn.getSpecVersion().equals("1.5")) {
            specVersion = 1.5;
        } else {
            throw new RAConfigException("ra.xml doesn't correct spec version");
        }
        JonasConnector jConn = new JonasConnector();
        PoolParams jPool = new PoolParams();
        JdbcConnParams jConnParams = new JdbcConnParams();
        JonasConfigProperty jCfg = null;
        String val = "";
        String str = "";
        val = "0";
        if (dbProps.getProperty("jdbc.initconpool") != null && dbProps.getProperty("jdbc.initconpool").length() > 0) {
            val = dbProps.getProperty("jdbc.initconpool").trim();
        }
        jPool.setPoolInit(val);
        val = "0";
        if (dbProps.getProperty("jdbc.minconpool") != null && dbProps.getProperty("jdbc.minconpool").length() > 0) {
            val = dbProps.getProperty("jdbc.minconpool").trim();
        }
        jPool.setPoolMin(val);
        val = "-1";
        if (dbProps.getProperty("jdbc.maxconpool") != null && dbProps.getProperty("jdbc.maxconpool").length() > 0) {
            val = dbProps.getProperty("jdbc.maxconpool").trim();
        }
        jPool.setPoolMax(val);
        val = "0";
        if (dbProps.getProperty("jdbc.connmaxage") != null && dbProps.getProperty("jdbc.connmaxage").length() > 0) {
            val = dbProps.getProperty("jdbc.connmaxage").trim();
        }
        jPool.setPoolMaxAgeMinutes(val);
        val = "0";
        if (dbProps.getProperty("jdbc.maxopentime") != null && dbProps.getProperty("jdbc.maxopentime").length() > 0) {
            val = dbProps.getProperty("jdbc.maxopentime").trim();
        }
        jPool.setPoolMaxOpentime(val);
        val = "0";
        if (dbProps.getProperty("jdbc.maxwaiters") != null && dbProps.getProperty("jdbc.maxwaiters").length() > 0) {
            val = dbProps.getProperty("jdbc.maxwaiters").trim();
        }
        jPool.setPoolMaxWaiters(val);
        val = "0";
        if (dbProps.getProperty("jdbc.maxwaittime") != null && dbProps.getProperty("jdbc.maxwaittime").length() > 0) {
            val = dbProps.getProperty("jdbc.maxwaittime").trim();
        }
        jPool.setPoolMaxWaittime(val);
        val = "30";
        if (dbProps.getProperty("jdbc.samplingperiod") != null && dbProps.getProperty("jdbc.samplingperiod").length() > 0) {
            val = dbProps.getProperty("jdbc.samplingperiod").trim();
        }
        jPool.setPoolSamplingPeriod(val);
        val = "10";
        if (dbProps.getProperty("jdbc.pstmtmax") != null && dbProps.getProperty("jdbc.pstmtmax").length() > 0) {
            val = dbProps.getProperty("jdbc.pstmtmax").trim();
        }
        jPool.setPstmtMax(val);
        val = "List";
        if (dbProps.getProperty("jdbc.pstmtcachepolicy") != null && dbProps.getProperty("jdbc.pstmtcachepolicy").length() > 0) {
            val = dbProps.getProperty("jdbc.pstmtcachepolicy").trim();
        }
        jPool.setPstmtCachePolicy(val);
        jConn.setLogEnabled("false");
        jConn.setLogTopic("");
        jConn.setNativeLib("");
        if (jndiname.length() == 0) {
            jndiname = dbProps.getProperty("datasource.name", "").trim();
        }
        val = "0";
        if (dbProps.getProperty("jdbc.connchecklevel") != null && dbProps.getProperty("jdbc.connchecklevel").length() > 0) {
            val = dbProps.getProperty("jdbc.connchecklevel").trim();
        }
        jConnParams.setJdbcCheckLevel(val);
        val = "";
        if (dbProps.getProperty("jdbc.connteststmt") != null && dbProps.getProperty("jdbc.connteststmt").length() > 0) {
            val = dbProps.getProperty("jdbc.connteststmt").trim();
            jConnParams.setJdbcTestStatement(val);
        }
        if (specVersion == 1.0) {
            jConn.setJndiName(jndiname);
        }
        jConn.setRarlink(rarlink);
        jConn.setPoolParams(jPool);
        jConn.setJdbcConnParams(jConnParams);
        if (specVersion == 1.0) {
            val = "";
            str = "";
            for (int i = 0; i < raProps.length; ++i) {
                jCfg = new JonasConfigProperty();
                str = raProps[i].getConfigPropertyName();
                jCfg.setJonasConfigPropertyName(str);
                val = dbProps.size() > 0 ? RAConfig.getProp(dbProps, str) : "";
                jCfg.setJonasConfigPropertyValue(val);
                jConn.addJonasConfigProperty(jCfg);
            }
        } else if (specVersion == 1.5) {
            Messageadapter mAdapter;
            InboundResourceadapter iRes;
            Resourceadapter rAdapter = conn.getResourceadapter();
            ConfigProperty cProperty2 = null;
            Object rProperty = null;
            for (ConfigProperty cProperty2 : rAdapter.getConfigPropertyList()) {
                jCfg = new JonasConfigProperty();
                str = cProperty2.getConfigPropertyName();
                jCfg.setJonasConfigPropertyName(str);
                val = dbProps.size() > 0 ? RAConfig.getProp(dbProps, str) : "";
                jCfg.setJonasConfigPropertyValue(val);
                jConn.addJonasConfigProperty(jCfg);
            }
            boolean first = true;
            OutboundResourceadapter oRes = rAdapter.getOutboundResourceadapter();
            if (oRes != null) {
                ConnectionDefinition cDef2 = null;
                JonasConnectionDefinition jcDef = null;
                for (ConnectionDefinition cDef2 : oRes.getConnectionDefinitionList()) {
                    jcDef = new JonasConnectionDefinition();
                    jcDef.setId(cDef2.getId());
                    jcDef.addDescription(cDef2.getManagedconnectionfactoryClass());
                    if (first && jndiname.length() != 0) {
                        jcDef.setJndiName(jndiname);
                        first = false;
                    } else {
                        jcDef.setJndiName("");
                    }
                    for (ConfigProperty cProperty2 : cDef2.getConfigPropertyList()) {
                        jCfg = new JonasConfigProperty();
                        str = cProperty2.getConfigPropertyName();
                        jCfg.setJonasConfigPropertyName(str);
                        jCfg.setJonasConfigPropertyValue("");
                        jcDef.addJonasConfigProperty(jCfg);
                    }
                    jConn.addJonasConnectionDefinition(jcDef);
                }
            }
            if ((iRes = rAdapter.getInboundResourceadapter()) != null && (mAdapter = iRes.getMessageadapter()) != null) {
                Messagelistener mList2 = null;
                JonasActivationspec jaSpec = null;
                Activationspec aSpec = null;
                for (Messagelistener mList2 : mAdapter.getMessagelistenerList()) {
                    aSpec = mList2.getActivationspec();
                    if (aSpec == null) continue;
                    jaSpec = new JonasActivationspec();
                    jaSpec.setId(mList2.getId());
                    jaSpec.addDescription(mList2.getMessagelistenerType());
                    jaSpec.setJndiName("");
                    jConn.addJonasActivationspec(jaSpec);
                }
            }
            for (Adminobject aObj : rAdapter.getAdminobjectList()) {
                JonasAdminobject jaObj = null;
                if (aObj == null) continue;
                jaObj = new JonasAdminobject();
                jaObj.setId(aObj.getId());
                jaObj.addDescription(aObj.getAdminobjectClass());
                jaObj.setJndiName("");
                for (ConfigProperty cProperty2 : aObj.getConfigPropertyList()) {
                    jCfg = new JonasConfigProperty();
                    str = cProperty2.getConfigPropertyName();
                    jCfg.setJonasConfigPropertyName(str);
                    jCfg.setJonasConfigPropertyValue("");
                    jaObj.addJonasConfigProperty(jCfg);
                }
                jConn.addJonasAdminobject(jaObj);
            }
        }
        if (securityfile != null) {
            Properties secProps = new Properties();
            File f = null;
            try {
                f = new File(securityfile);
                FileInputStream is = new FileInputStream(f);
                secProps.load(is);
            }
            catch (FileNotFoundException e) {
                System.err.println("Cannot find security properties file: " + securityfile);
                System.err.println("Continuing with creation of jonas-ra.xml");
            }
            catch (IOException e) {
                System.err.println(e);
            }
            JonasSecurityMapping jsMap = new JonasSecurityMapping();
            String pName = null;
            String user = null;
            String pass = null;
            String tmp = null;
            int offset = 0;
            SecurityEntry sEnt = null;
            Enumeration<?> e = secProps.propertyNames();
            while (e.hasMoreElements()) {
                pName = (String)e.nextElement();
                tmp = secProps.getProperty(pName);
                offset = tmp.indexOf("::");
                if (offset < 0) {
                    System.err.println("Error in format of file:  principalName = user::password");
                    continue;
                }
                user = tmp.substring(0, offset);
                pass = tmp.substring(offset + 2);
                sEnt = new SecurityEntry();
                sEnt.setPrincipalName(pName);
                sEnt.setUser(user);
                if (encrypt) {
                    try {
                        pass = new String(Base64.encode((byte[])pass.getBytes()));
                        sEnt.setEncrypted("" + encrypt);
                    }
                    catch (Exception ex) {
                        System.err.println("Unable to encrypt the password.");
                    }
                }
                sEnt.setPassword(pass);
                jsMap.addSecurityEntry(sEnt);
            }
            jConn.setJonasSecurityMapping(jsMap);
        }
        try {
            int fileLen;
            String fileName;
            String tmpDir = path;
            if (path.length() == 0) {
                tmpDir = System.getProperty("java.io.tmpdir");
            }
            if ((fileName = tmpDir).charAt((fileLen = fileName.length()) - 1) != File.separatorChar) {
                fileName = fileName + File.separatorChar;
            }
            fileName = fileName + "jonas-ra.xml";
            FileWriter fw = new FileWriter(fileName);
            fw.write(jConn.toXML());
            fw.close();
            if (isVerbose) {
                System.out.println("Build Jonas Specific DD File '" + fileName + "' OK");
            }
        }
        catch (Exception e) {
            throw new RAConfigException("Error writing output", e);
        }
    }

    private static String getProp(Properties prop, String str) {
        String[][] mapping = new String[][]{{"connCheckLevel", "jdbc.connchecklevel"}, {"connMaxAge", "jdbc.connmaxage"}, {"connTestStmt", "jdbc.connteststmt"}, {"URL", "datasource.url"}, {"dsClass", "datasource.classname"}, {"user", "datasource.username"}, {"password", "datasource.password"}, {"isolationLevel", "datasource.isolationlevel"}, {"mapperName", "datasource.mapper"}, {"databaseName", "datasource.databaseName"}, {"loginTimeout", "datasource.loginTimeout"}, {"description", "datasource.description"}, {"portNumber", "datasource.portNumber"}, {"serverName", "datasource.serverName"}};
        String ret = "";
        for (int i = 0; i < mapping.length; ++i) {
            if (!mapping[i][0].equalsIgnoreCase(str)) continue;
            String value = prop.getProperty(mapping[i][1]);
            ret = value == null ? "" : value.trim();
        }
        return ret;
    }

    private static void updateRAR(String infile, String outfile, String updatename, String rarlink) throws RAConfigException {
        ZipOutputStream zipOutput = null;
        ZipFile zipFile = null;
        Enumeration<? extends ZipEntry> zippedFiles = null;
        ZipEntry currEntry = null;
        ZipEntry entry = null;
        byte[] buffer = new byte[500];
        int num = 0;
        String filename = infile;
        String outfilename = infile;
        boolean outNew = false;
        if (outfile != null && outfile.length() != 0) {
            outfilename = outfile;
            outNew = true;
        }
        try {
            File file = new File(filename);
            if (file.exists()) {
                Closeable reader;
                zipFile = new ZipFile(file.getAbsolutePath());
                zippedFiles = zipFile.entries();
                if (!outNew) {
                    zipOutput = new ZipOutputStream(new FileOutputStream(new File(file.getAbsolutePath() + "NEW")));
                } else {
                    File ofile = new File(outfilename);
                    if (ofile.exists()) {
                        ofile.delete();
                    }
                    zipOutput = new ZipOutputStream(new FileOutputStream(new File(outfilename)));
                }
                if ((outfile == null || outfile.length() == 0) && rarlink.length() == 0) {
                    while (zippedFiles.hasMoreElements()) {
                        currEntry = zippedFiles.nextElement();
                        if (currEntry.getName().equalsIgnoreCase(JONAS_RA_FILENAME)) continue;
                        zipOutput.putNextEntry(new ZipEntry(currEntry.getName()));
                        reader = zipFile.getInputStream(currEntry);
                        while ((num = ((InputStream)reader).read(buffer)) != -1) {
                            zipOutput.write(buffer, 0, num);
                        }
                        zipOutput.flush();
                        zipOutput.closeEntry();
                    }
                }
                zipFile.close();
                entry = new ZipEntry(JONAS_RA_FILENAME);
                zipOutput.putNextEntry(entry);
                try {
                    reader = new BufferedReader(new FileReader(updatename));
                    int ch = 0;
                    while ((ch = ((BufferedReader)reader).read()) != -1) {
                        zipOutput.write(ch);
                    }
                }
                catch (Exception ex) {
                    System.out.println("Error reading input file: " + updatename + " " + ex);
                    zipOutput.flush();
                    zipOutput.closeEntry();
                    zipOutput.finish();
                    zipOutput.close();
                }
                zipOutput.flush();
                zipOutput.closeEntry();
                zipOutput.finish();
                zipOutput.close();
                if (!outNew) {
                    File toBeDeleted = new File(file.getAbsolutePath());
                    toBeDeleted.delete();
                    File toBeRenamed = new File(file.getAbsolutePath() + "NEW");
                    toBeRenamed.renameTo(file);
                }
            } else {
                zipOutput = new ZipOutputStream(new FileOutputStream(new File(outfilename)));
                entry = new ZipEntry(JONAS_RA_FILENAME);
                zipOutput.putNextEntry(entry);
                BufferedReader reader = new BufferedReader(new FileReader(updatename));
                int ch = 0;
                while ((ch = reader.read()) != -1) {
                    zipOutput.write(ch);
                }
                zipOutput.flush();
                zipOutput.closeEntry();
                zipOutput.finish();
                zipOutput.close();
            }
            new File(updatename).delete();
        }
        catch (Exception ex) {
            throw new RAConfigException(ex);
        }
    }

    private static boolean extractJonasRAXml(String infile, String path) {
        ZipFile zipFile = null;
        ZipEntry entry = null;
        byte[] buffer = new byte[500];
        String filename = infile;
        File file = new File(filename);
        if (file.exists()) {
            try {
                zipFile = new ZipFile(file.getAbsolutePath());
                entry = zipFile.getEntry(JONAS_RA_FILENAME);
                if (entry != null) {
                    int length;
                    int fileLen;
                    String fileName;
                    InputStream input = zipFile.getInputStream(entry);
                    String tmpDir = path;
                    if (path.length() == 0) {
                        tmpDir = System.getProperty("java.io.tmpdir");
                    }
                    if ((fileName = tmpDir).charAt((fileLen = fileName.length()) - 1) != File.separatorChar) {
                        fileName = fileName + File.separatorChar;
                    }
                    fileName = fileName + "jonas-ra.xml";
                    FileOutputStream output = new FileOutputStream(fileName);
                    boolean j = false;
                    while ((length = input.read(buffer)) > 0) {
                        output.write(buffer, 0, length);
                    }
                    output.close();
                    return true;
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    public static void usage() {
        System.out.println("");
        System.out.println("Usage: java org.ow2.jonas.generators.raconfig.RAConfig <Options> <Input_File> [Output_File]");
        System.out.println("     to generate the jonas-ra.xml file for a Resource Adapter.");
        System.out.println("   The output file will be written to the default location of the java ");
        System.out.println("     system property 'java.io.tmpdir' unless the -path parameter is specified");
        System.out.println("");
        System.out.println("   Note: for a parameter either the whole name must be used or only the");
        System.out.println("         the capital letters, e.g.  -jndiname or -j are equivalent");
        System.out.println("");
        System.out.println("       With Options:");
        System.out.println("         -? or -help                print this help message");
        System.out.println("         -DM,-DS,-CP,-XA            DriverManager, Datasource, ConnectionPoolDatasource,");
        System.out.println("                                    XAConnection only used with -p.  Additional");
        System.out.println("                                    user configuration of the jonas-ra.xml file");
        System.out.println("                                    will be necessary for any option but -DM.");
        System.out.println("         -Jndiname <jndiname>       specifies the jndiname RA");
        System.out.println("         -Property <property file>  specifies the database property file");
        System.out.println("                                     to process");
        System.out.println("         -Rarlink <rarlink>         specifies the rar file to link to");
        System.out.println("         -Update <input name>       update the input rar with the specified file");
        System.out.println("                                    unless an output_file named is specified");
        System.out.println("         -ENcrypt                   used with -sf to encrypt the passwords ");
        System.out.println("         -SecurityFile              security xml file to add to jonas-ra.xml ");
        System.out.println("         -Verbose                   output the contents of the  deployment descriptor ");
        System.out.println("         -NoValidation              turn off xml dtd/schema validation ");
        System.out.println("         -PATH <path>               path where jonas-ra.xml should be written to ");
        System.out.println("                                     default is System.property('java.io.tmpdir')");
        System.out.println("         -NEW                       don't extract jonas-ra.xml create a new one ");
        System.out.println("");
        System.out.println("       Input_File     Resource Adapter RAR file");
        System.out.println("       Output_File    Resource Adapter RAR file only used with ");
        System.out.println("                          -p(required) or -u(optional)");
        System.out.println("");
    }

    public static void main(String[] args) throws RAConfigException {
        boolean isHelp = false;
        boolean isVerbose = false;
        boolean doProperty = false;
        boolean doUpdate = false;
        boolean encrypt = false;
        boolean newXml = false;
        String fileInputName = null;
        String fileOutputName = null;
        String securityfile = null;
        String jndiname = "";
        String rarlink = "";
        String updatename = "";
        String jdbcRarLink = "";
        String jonasRarStr = "JOnASJDBC_";
        String propertyFile = "";
        String path = "";
        Properties dbProps = null;
        if (args.length < 1) {
            isHelp = true;
        }
        for (int argn = 0; argn < args.length; ++argn) {
            String arg = args[argn].toLowerCase();
            if (arg.equals("-help") || arg.equals("-?")) {
                isHelp = true;
                continue;
            }
            if (arg.equals("-verbose") || arg.equals("-v")) {
                isVerbose = true;
                continue;
            }
            if (arg.equals("-encrypt") || arg.equals("-en")) {
                encrypt = true;
                continue;
            }
            if (arg.equals("-securityfile") || arg.equals("-sf")) {
                if (argn + 1 == args.length || args[++argn].startsWith("-")) {
                    RAConfig.usage();
                    throw new RAConfigException("Error with -sf input");
                }
                securityfile = args[argn];
                continue;
            }
            if (arg.equals("-novalidation") || arg.equals("-nv")) {
                validation = false;
                continue;
            }
            if (arg.equals("-update") || arg.equals("-u")) {
                doUpdate = true;
                if (argn + 1 == args.length || args[++argn].startsWith("-")) {
                    RAConfig.usage();
                    throw new RAConfigException("Error with -u input");
                }
                updatename = args[argn];
                continue;
            }
            if (arg.equals("-jndiname") || arg.equals("-j")) {
                if (argn + 1 == args.length || args[++argn].startsWith("-")) {
                    RAConfig.usage();
                    throw new RAConfigException("Error with -j input");
                }
                jndiname = args[argn];
                continue;
            }
            if (arg.equals("-rarlink") || arg.equals("-r")) {
                if (argn + 1 == args.length || args[++argn].startsWith("-")) {
                    RAConfig.usage();
                    throw new RAConfigException("Error with -r input");
                }
                rarlink = args[argn];
                continue;
            }
            if (arg.equals("-property") || arg.equals("-p")) {
                doProperty = true;
                if (argn + 1 == args.length || args[++argn].startsWith("-")) {
                    RAConfig.usage();
                    throw new RAConfigException("Error with -p input");
                }
                propertyFile = args[argn];
                continue;
            }
            if (arg.equals("-dm")) {
                jdbcRarLink = jonasRarStr + "DM";
                continue;
            }
            if (arg.equals("-ds")) {
                jdbcRarLink = jonasRarStr + "DS";
                continue;
            }
            if (arg.equals("-xa")) {
                jdbcRarLink = jonasRarStr + "XA";
                continue;
            }
            if (arg.equals("-cp")) {
                jdbcRarLink = jonasRarStr + "CP";
                continue;
            }
            if (arg.equals("-path")) {
                if (argn + 1 == args.length || args[++argn].startsWith("-")) {
                    RAConfig.usage();
                    throw new RAConfigException("Error with -path");
                }
                path = args[argn];
                continue;
            }
            if (arg.equals("-new")) {
                newXml = true;
                continue;
            }
            if (fileInputName == null) {
                fileInputName = args[argn];
                if (fileInputName.endsWith(".rar")) continue;
                fileInputName = fileInputName + ".rar";
                continue;
            }
            if (doProperty || doUpdate) {
                if (fileOutputName != null || (fileOutputName = args[argn]).endsWith(".rar")) continue;
                fileOutputName = fileOutputName + ".rar";
                continue;
            }
            RAConfig.usage();
            throw new RAConfigException("Error multiple input files specified without -property or -update");
        }
        if (isHelp) {
            RAConfig.usage();
            System.exit(0);
        }
        if (fileInputName == null) {
            RAConfig.usage();
            throw new RAConfigException("Error missing input file");
        }
        if (doProperty && fileOutputName == null) {
            RAConfig.usage();
            throw new RAConfigException("Error missing output file");
        }
        if (fileInputName.equals(fileOutputName)) {
            throw new RAConfigException("Input and Output filenames cannot be the same");
        }
        dbProps = new Properties();
        if (doProperty) {
            if (jdbcRarLink.length() > 0 && rarlink.length() == 0) {
                rarlink = jdbcRarLink;
            }
            try {
                dbProps.load(new FileInputStream(propertyFile));
            }
            catch (Exception ex) {
                if (propertyFile.endsWith(".properties")) {
                    System.out.println("Error reading " + propertyFile + " " + ex);
                }
                try {
                    dbProps.load(new FileInputStream(propertyFile + ".properties"));
                }
                catch (Exception ex1) {
                    System.out.println("Error reading " + propertyFile + " " + ex);
                }
            }
            RAConfig.buildXML(fileInputName, jndiname, rarlink, dbProps, encrypt, securityfile, path, isVerbose, true);
            if (updatename.length() == 0) {
                updatename = System.getProperty("java.io.tmpdir") + File.separator + "jonas-ra.xml";
            }
            RAConfig.updateRAR(fileInputName, fileOutputName, updatename, rarlink);
        } else if (doUpdate) {
            RAConfig.updateRAR(fileInputName, fileOutputName, updatename, rarlink);
        } else {
            RAConfig.buildXML(fileInputName, jndiname, rarlink, dbProps, encrypt, securityfile, path, isVerbose, newXml);
        }
    }

    public static void generateRars(Properties props, String rarLink, String inputfile, String outputfile) throws RAConfigException {
        String jndiname = "";
        Boolean encrypt = false;
        String securityfile = null;
        String path = "";
        Boolean isVerbose = false;
        String updatename = "";
        RAConfig.buildXML(inputfile, jndiname, rarLink, props, encrypt, securityfile, path, isVerbose, true);
        if (updatename.length() == 0) {
            updatename = System.getProperty("java.io.tmpdir") + File.separator + "jonas-ra.xml";
        }
        RAConfig.updateRAR(inputfile, outputfile, updatename, rarLink);
    }
}

