/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.command;

import aQute.libg.reporter.Reporter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command {
    boolean trace;
    Reporter reporter;
    List<String> arguments = new ArrayList<String>();
    long timeout = 0L;
    File cwd = new File("").getAbsoluteFile().getParentFile().getAbsoluteFile();
    static Timer timer = new Timer();
    Process process;
    volatile boolean timedout;

    public int execute(Appendable stdout, Appendable stderr) throws Exception {
        return this.execute((InputStream)null, stdout, stderr);
    }

    public int execute(String input, Appendable stdout, Appendable stderr) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(input.getBytes("UTF-8"));
        return this.execute(in, stdout, stderr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(InputStream in, Appendable stdout, Appendable stderr) throws Exception {
        int result;
        InputStreamHandler handler;
        if (this.reporter != null) {
            this.reporter.trace("executing cmd: %s", this.arguments);
        }
        String[] args = this.arguments.toArray(new String[this.arguments.size()]);
        this.process = Runtime.getRuntime().exec(args, null, this.cwd);
        Runnable r = new Runnable(){

            public void run() {
                Command.this.process.destroy();
            }
        };
        Thread hook = new Thread(r, this.arguments.toString());
        Runtime.getRuntime().addShutdownHook(hook);
        TimerTask timer = null;
        OutputStream stdin = this.process.getOutputStream();
        InputStreamHandler inputStreamHandler = handler = in != null ? new InputStreamHandler(in, stdin) : null;
        if (this.timeout != 0L) {
            timer = new TimerTask(){

                public void run() {
                    Command.this.timedout = true;
                    Command.this.process.destroy();
                    if (handler != null) {
                        handler.interrupt();
                    }
                }
            };
            Command.timer.schedule(timer, this.timeout);
        }
        InputStream out = this.process.getInputStream();
        try {
            InputStream err = this.process.getErrorStream();
            try {
                new Collector(out, stdout).start();
                new Collector(err, stdout).start();
                if (handler != null) {
                    handler.start();
                }
                result = this.process.waitFor();
            }
            finally {
                err.close();
            }
        }
        finally {
            out.close();
            if (timer != null) {
                timer.cancel();
            }
            Runtime.getRuntime().removeShutdownHook(hook);
            if (handler != null) {
                handler.interrupt();
            }
        }
        if (this.reporter != null) {
            this.reporter.trace("cmd %s executed with result=%d, result: %s/%s", this.arguments, result, stdout, stderr);
        }
        if (this.timedout) {
            return Integer.MIN_VALUE;
        }
        byte exitValue = (byte)this.process.exitValue();
        return exitValue;
    }

    public void add(String ... args) {
        for (String arg : args) {
            this.arguments.add(arg);
        }
    }

    public void addAll(Collection<String> args) {
        this.arguments.addAll(args);
    }

    public void setTimeout(long duration, TimeUnit unit) {
        this.timeout = unit.toMillis(duration);
    }

    public void setTrace() {
        this.trace = true;
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public void setCwd(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Working directory must be a directory: " + dir);
        }
        this.cwd = dir;
    }

    public void cancel() {
        this.process.destroy();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (String argument : this.arguments) {
            sb.append(del);
            sb.append(argument);
            del = " ";
        }
        return sb.toString();
    }

    class InputStreamHandler
    extends Thread {
        final InputStream in;
        final OutputStream stdin;

        public InputStreamHandler(InputStream in, OutputStream stdin) {
            this.stdin = stdin;
            this.in = in;
        }

        public void run() {
            try {
                int c = this.in.read();
                while (c >= 0) {
                    this.stdin.write(c);
                    c = this.in.read();
                }
            }
            catch (InterruptedIOException e) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class Collector
    extends Thread {
        final InputStream in;
        final Appendable sb;

        public Collector(InputStream inputStream, Appendable sb) {
            this.in = inputStream;
            this.sb = sb;
        }

        public void run() {
            block6: {
                try {
                    int c = this.in.read();
                    while (c >= 0) {
                        if (Command.this.trace) {
                            System.out.print((char)c);
                        }
                        this.sb.append((char)c);
                        c = this.in.read();
                    }
                }
                catch (Exception e) {
                    try {
                        this.sb.append("\n**************************************\n");
                        this.sb.append(e.toString());
                        this.sb.append("\n**************************************\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (Command.this.reporter == null) break block6;
                    Command.this.reporter.trace("cmd exec: %s", e);
                }
            }
        }
    }
}

