/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util.management;

import fr.dyade.aaa.util.management.MXServer;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MXWrapper {
    public static final String NO_JMX = "JoramNoJMX";
    private static MXServer mxserver = null;

    public static String objectName(String domain, String name) {
        return new StringBuffer().append(domain).append(':').append(name).toString();
    }

    public static void registerMBean(Object bean, String domain, String name) throws Exception {
        MXWrapper.registerMBean(bean, MXWrapper.objectName(domain, name));
    }

    public static void registerMBean(Object bean, String fullName) throws Exception {
        if (mxserver != null) {
            mxserver.registerMBean(bean, fullName);
        }
    }

    public static void unregisterMBean(String domain, String name) throws Exception {
        MXWrapper.unregisterMBean(MXWrapper.objectName(domain, name));
    }

    public static void unregisterMBean(String fullName) throws Exception {
        if (mxserver != null) {
            mxserver.unregisterMBean(fullName);
        }
    }

    public static void setMXServer(MXServer server) {
        mxserver = server;
    }

    public static Object getAttribute(String objectName, String attribute) throws Exception {
        if (mxserver != null) {
            return mxserver.getAttribute(objectName, attribute);
        }
        return null;
    }

    public static Set<String> queryNames(String objectName) throws Exception {
        if (mxserver != null) {
            return mxserver.queryNames(objectName);
        }
        return null;
    }

    public static List<String> getAttributeNames(String mBean) throws Exception {
        if (mxserver != null) {
            return mxserver.getAttributeNames(mBean);
        }
        return null;
    }

    static {
        if (!Boolean.getBoolean(NO_JMX)) {
            try {
                mxserver = (MXServer)Class.forName(System.getProperty("MXServer", "com.scalagent.jmx.JMXServer")).newInstance();
            }
            catch (Exception exc) {
                mxserver = null;
            }
        }
    }
}

