/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import org.objectweb.joram.client.connector.InboundConsumerMBean;
import org.objectweb.joram.client.connector.InboundSession;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class InboundConsumer
implements ServerSessionPool,
InboundConsumerMBean {
    public static Logger logger = Debug.getLogger((String)InboundConsumer.class.getName());
    private WorkManager workManager;
    MessageEndpointFactory endpointFactory;
    private XAConnection cnx;
    private String subName = null;
    private boolean transacted;
    private int maxWorks;
    private int ackMode;
    private boolean closeDurSub;
    private ConnectionConsumer cnxConsumer;
    private int serverSessions = 0;
    private Vector pool;

    public InboundConsumer(WorkManager workManager, MessageEndpointFactory endpointFactory, XAConnection cnx, Destination dest, String selector, boolean durable, String subName, boolean transacted, int maxWorks, int maxMessages, int ackMode, boolean closeDurSub) throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("InboundConsumer(" + workManager + ", " + endpointFactory + ", " + cnx + ", " + dest + ", " + selector + ", " + durable + ", " + subName + ", " + transacted + ", " + maxWorks + ", " + maxMessages + "," + ackMode + "," + closeDurSub + ")"));
        }
        this.workManager = workManager;
        this.endpointFactory = endpointFactory;
        this.cnx = cnx;
        this.transacted = transacted;
        this.ackMode = ackMode;
        this.closeDurSub = closeDurSub;
        if (maxWorks < 0) {
            maxWorks = 0;
        }
        this.maxWorks = maxWorks;
        this.pool = new Vector(maxWorks);
        try {
            if (durable) {
                if (!(dest instanceof Topic)) {
                    throw new NotSupportedException("Can't set a durable subscription on a JMS queue.");
                }
                if (subName == null) {
                    throw new NotSupportedException("Missing durable subscription name.");
                }
                this.subName = subName;
                this.cnxConsumer = cnx.createDurableConnectionConsumer((Topic)dest, subName, selector, (ServerSessionPool)this, maxMessages);
            } else {
                this.cnxConsumer = cnx.createConnectionConsumer(dest, selector, (ServerSessionPool)this, maxMessages);
            }
            cnx.start();
            this.registerMBean();
        }
        catch (JMSSecurityException exc) {
            throw new SecurityException("Target destination not readble: " + (Object)((Object)exc));
        }
        catch (IllegalStateException exc) {
            throw new CommException("Connection with the JORAM server is lost.");
        }
        catch (JMSException exc) {
            throw new ResourceException("Could not set asynchronous consumer: " + (Object)((Object)exc));
        }
    }

    public String getJMXBeanName(XAConnection cnx) {
        if (!(cnx instanceof Connection)) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(((Connection)cnx).getJMXBeanName());
        buf.append(",location=InboundConsumer");
        buf.append(",InboundConsumer=").append(this.endpointFactory.getClass().getSimpleName()).append("@").append(this.endpointFactory.hashCode());
        return buf.toString();
    }

    public String registerMBean() {
        String JMXBeanName;
        block3: {
            JMXBeanName = this.getJMXBeanName(this.cnx);
            try {
                if (JMXBeanName != null) {
                    MXWrapper.registerMBean((Object)this, (String)JMXBeanName);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, (Object)("InboundConsumer.registerMBean: " + JMXBeanName), (Throwable)e);
            }
        }
        return JMXBeanName;
    }

    public void unregisterMBean() {
        block2: {
            try {
                MXWrapper.unregisterMBean((String)this.getJMXBeanName(this.cnx));
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block2;
                logger.log(BasicLevel.DEBUG, (Object)("InboundConsumer.unregisterMBean: " + this.getJMXBeanName(this.cnx)), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession getServerSession() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getServerSession()"));
        }
        try {
            Vector vector = this.pool;
            synchronized (vector) {
                if (this.pool.isEmpty()) {
                    if (this.maxWorks > 0) {
                        if (this.serverSessions < this.maxWorks) {
                            return this.newSession();
                        }
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)"ServerSessionPool waits for a free ServerSession.");
                        }
                        this.pool.wait();
                        return (ServerSession)this.pool.remove(0);
                    }
                    return this.newSession();
                }
                return (ServerSession)this.pool.remove(0);
            }
        }
        catch (Exception exc) {
            throw new JMSException("Error while getting server session from pool: " + exc);
        }
    }

    private InboundSession newSession() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ServerSessionPool provides new ServerSession.");
        }
        ++this.serverSessions;
        return new InboundSession(this, this.workManager, this.endpointFactory, this.cnx, this.transacted, this.ackMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseSession(InboundSession session) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " releaseSession(" + session + ")"));
        }
        try {
            Vector vector = this.pool;
            synchronized (vector) {
                this.pool.add(session);
                this.pool.notify();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void close() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " close() unsubscribe subscription: " + this.closeDurSub));
        }
        try {
            this.cnx.setExceptionListener(null);
        }
        catch (JMSException e) {
            // empty catch block
        }
        this.unregisterMBean();
        try {
            this.cnxConsumer.close();
            if (this.closeDurSub && this.subName != null) {
                Session session = this.cnx.createSession(true, 0);
                session.unsubscribe(this.subName);
            }
            this.cnx.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public String getSubName() {
        return this.subName;
    }

    public boolean getTransacted() {
        return this.transacted;
    }

    public int getMaxWorks() {
        return this.maxWorks;
    }

    public String getAckMode() {
        switch (this.ackMode) {
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
            case 0: {
                return "SESSION_TRANSACTED";
            }
        }
        return "unknown";
    }

    public boolean getCloseDurSub() {
        return this.closeDurSub;
    }

    public int getServerSessions() {
        return this.serverSessions;
    }

    public int getPoolSize() {
        return this.pool.size();
    }

    public String[] getSessions() {
        String[] sessionsName = new String[this.pool.size()];
        for (int i = 0; i < this.pool.size(); ++i) {
            InboundSession sess = (InboundSession)this.pool.get(i);
            try {
                sessionsName[i] = sess.getSession().toString();
                continue;
            }
            catch (Exception e) {
                sessionsName[i] = "unknown";
            }
        }
        return sessionsName;
    }
}

