/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import java.io.Serializable;
import java.util.Properties;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.client.jms.XAConnectionFactory;
import org.objectweb.joram.shared.security.SimpleIdentity;

public class ManagedConnectionFactoryConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean collocated = false;
    private String hostName = "localhost";
    private int serverPort = -1;
    private String userName = "anonymous";
    private String password = "anonymous";
    private String identityClass = SimpleIdentity.class.getName();
    private int connectingTimer = 0;
    private int txPendingTimer = 0;
    private int cnxPendingTimer = 0;
    public boolean asyncSend = false;
    private boolean multiThreadSync = false;
    private int multiThreadSyncDelay = 1;
    private String outLocalAddress = null;
    private int outLocalPort = 0;
    private String inInterceptors = null;
    private String outInterceptors = null;
    private String mode = "Unified";
    private String name = null;

    public Integer getConnectingTimer() {
        return new Integer(this.connectingTimer);
    }

    public void setConnectingTimer(Integer connectingTimer) {
        this.connectingTimer = connectingTimer;
    }

    public Integer getTxPendingTimer() {
        return new Integer(this.txPendingTimer);
    }

    public void setTxPendingTimer(Integer txPendingTimer) {
        this.txPendingTimer = txPendingTimer;
    }

    public Integer getCnxPendingTimer() {
        return new Integer(this.cnxPendingTimer);
    }

    public void setCnxPendingTimer(Integer cnxPendingTimer) {
        this.cnxPendingTimer = cnxPendingTimer;
    }

    public Boolean getAsyncSend() {
        return new Boolean(this.asyncSend);
    }

    public void setAsyncSend(Boolean asyncSend) {
        this.asyncSend = asyncSend;
    }

    public boolean isAsyncSend() {
        return this.asyncSend;
    }

    public Boolean getMultiThreadSync() {
        return new Boolean(this.multiThreadSync);
    }

    public void setMultiThreadSync(Boolean multiThreadSync) {
        this.multiThreadSync = multiThreadSync;
    }

    public boolean isMultiThreadSync() {
        return this.multiThreadSync;
    }

    public Integer getMultiThreadSyncDelay() {
        return new Integer(this.multiThreadSyncDelay);
    }

    public void setMultiThreadSyncDelay(Integer multiThreadSyncDelay) {
        this.multiThreadSyncDelay = multiThreadSyncDelay;
    }

    protected void setParameters(Object factory) {
        ConnectionFactory f;
        FactoryParameters fp = null;
        if (factory instanceof ConnectionFactory) {
            f = (ConnectionFactory)factory;
            fp = f.getParameters();
        } else if (factory instanceof XAConnectionFactory) {
            f = (XAConnectionFactory)factory;
            fp = f.getParameters();
        }
        if (fp != null) {
            String interceptorName;
            String[] interceptorArray;
            fp.connectingTimer = this.connectingTimer;
            fp.cnxPendingTimer = this.cnxPendingTimer;
            fp.txPendingTimer = this.txPendingTimer;
            if (this.asyncSend) {
                fp.asyncSend = this.asyncSend;
            }
            if (this.multiThreadSync) {
                fp.multiThreadSync = this.multiThreadSync;
            }
            if (this.multiThreadSyncDelay > 0) {
                fp.multiThreadSyncDelay = this.multiThreadSyncDelay;
            }
            if (this.outLocalPort > 0) {
                fp.outLocalPort = this.outLocalPort;
            }
            if (this.outLocalAddress != null) {
                fp.outLocalAddress = this.outLocalAddress;
            }
            if (this.inInterceptors != null && (interceptorArray = this.inInterceptors.split(",")) != null) {
                for (String interceptorClassName : interceptorArray) {
                    interceptorName = interceptorClassName.trim();
                    if (interceptorName.length() <= 0) continue;
                    fp.addInInterceptor(interceptorName);
                }
            }
            if (this.outInterceptors != null && (interceptorArray = this.outInterceptors.split(",")) != null) {
                for (String interceptorClassName : interceptorArray) {
                    interceptorName = interceptorClassName.trim();
                    if (interceptorName.length() <= 0) continue;
                    fp.addOutInterceptor(interceptorName);
                }
            }
        }
    }

    public void setCollocated(Boolean collocated) {
        this.collocated = collocated;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setIdentityClass(String identityClass) {
        this.identityClass = identityClass;
    }

    public Boolean isCollocated() {
        return new Boolean(this.collocated);
    }

    public String getHostName() {
        return this.hostName;
    }

    public Integer getServerPort() {
        return new Integer(this.serverPort);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getIdentityClass() {
        return this.identityClass;
    }

    public String getOutLocalAddress() {
        return this.outLocalAddress;
    }

    public Integer getOutLocalPort() {
        return new Integer(this.outLocalPort);
    }

    public void setOutLocalAddress(String outLocalAddress) {
        this.outLocalAddress = null;
        if (outLocalAddress != null && outLocalAddress.length() > 0) {
            this.outLocalAddress = outLocalAddress;
        }
    }

    public void setOutLocalPort(Integer outLocalPort) {
        this.outLocalPort = outLocalPort;
    }

    public void setOutInterceptors(String outInterceptors) {
        this.outInterceptors = outInterceptors;
    }

    public void setInInterceptors(String inInterceptors) {
        this.inInterceptors = inInterceptors;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setManagedConnectionFactoryConfig(Properties props) {
        this.name = props.getProperty("name");
        this.hostName = props.getProperty("HostName", "localhost");
        this.serverPort = new Integer(props.getProperty("ServerPort", "-1"));
        this.userName = props.getProperty("UserName", "anonymous");
        this.password = props.getProperty("Password", "anonymous");
        this.identityClass = props.getProperty("IdentityClass", "org.objectweb.joram.shared.security.SimpleIdentity");
        this.collocated = new Boolean(props.getProperty("Collocated", "true"));
        this.outInterceptors = props.getProperty("OutInterceptors");
        this.inInterceptors = props.getProperty("InInterceptors");
        this.outLocalAddress = props.getProperty("outLocalAddress");
        this.outLocalPort = new Integer(props.getProperty("outLocalPort", "0"));
        this.connectingTimer = new Integer(props.getProperty("ConnectingTimer", "0"));
        this.cnxPendingTimer = new Integer(props.getProperty("CnxPendingTimer", "0"));
        this.txPendingTimer = new Integer(props.getProperty("TxPendingTimer", "0"));
        this.multiThreadSync = new Boolean(props.getProperty("multiThreadSync", "false"));
        this.multiThreadSyncDelay = new Integer(props.getProperty("multiThreadSyncDelay", "1"));
        this.mode = props.getProperty("mode", "Unified");
    }
}

