/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.common.Debug;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.SecurityException;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.objectweb.joram.client.connector.ConnectionRequest;
import org.objectweb.joram.client.connector.JoramAdapter;
import org.objectweb.joram.client.connector.JoramResourceAdapter;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryConfig;
import org.objectweb.joram.client.connector.ManagedConnectionImpl;
import org.objectweb.joram.client.connector.ManagedQueueConnectionFactoryImpl;
import org.objectweb.joram.client.connector.ManagedTopicConnectionFactoryImpl;
import org.objectweb.joram.client.connector.OutboundConnectionFactory;
import org.objectweb.joram.client.connector.QueueConnectionRequest;
import org.objectweb.joram.client.connector.TopicConnectionRequest;
import org.objectweb.joram.client.jms.admin.AbstractConnectionFactory;
import org.objectweb.joram.client.jms.local.XALocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.XATcpConnectionFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ManagedConnectionFactoryImpl
extends ManagedConnectionFactoryConfig
implements ManagedConnectionFactory,
ResourceAdapterAssociation,
ValidatingManagedConnectionFactory,
Serializable {
    public static Logger logger = Debug.getLogger((String)ManagedConnectionFactoryImpl.class.getName());
    private static final long serialVersionUID = 1L;
    protected transient PrintWriter out = null;
    transient JoramResourceAdapter ra = null;

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createConnectionFactory(" + cxManager + ")"));
        }
        return new OutboundConnectionFactory(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createConnectionFactory()"));
        }
        OutboundConnectionFactory factory = new OutboundConnectionFactory(this, null);
        Reference ref = new Reference(factory.getClass().getName(), "org.objectweb.joram.client.connector.ObjectFactoryImpl", null);
        ref.add(new StringRefAddr("hostName", this.getHostName()));
        ref.add(new StringRefAddr("serverPort", "" + this.getServerPort()));
        ref.add(new StringRefAddr("userName", this.getUserName()));
        ref.add(new StringRefAddr("password", this.getPassword()));
        ref.add(new StringRefAddr("identityClass", this.getIdentityClass()));
        factory.setReference(ref);
        return factory;
    }

    protected XAConnectionFactory createFactory(ConnectionRequestInfo cxRequest) throws ResourceException {
        XAConnectionFactory factory = null;
        String hostName = this.getHostName();
        int serverPort = this.getServerPort();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createFactory hostName = " + hostName + ", serverPort = " + serverPort));
        }
        factory = this.isCollocated() != false ? XALocalConnectionFactory.create() : XATcpConnectionFactory.create((String)hostName, (int)serverPort);
        ((AbstractConnectionFactory)factory).setCnxJMXBeanBaseName(JoramResourceAdapter.jmxRootName + "#" + this.ra.getName());
        return factory;
    }

    protected XAConnection createXAConnection(XAConnectionFactory factory, String userName, String password) throws ResourceException {
        XAConnection cnx = null;
        try {
            cnx = factory.createXAConnection(userName, password);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " createManagedConnection cnx = " + cnx));
            }
        }
        catch (IllegalStateException exc) {
            if (this.out != null) {
                this.out.print("Could not access the JORAM server: " + (Object)((Object)exc));
            }
            throw new CommException("Could not access the JORAM server: " + (Object)((Object)exc));
        }
        catch (JMSSecurityException exc) {
            if (this.out != null) {
                this.out.print("Invalid user identification: " + (Object)((Object)exc));
            }
            throw new SecurityException("Invalid user identification: " + (Object)((Object)exc));
        }
        catch (JMSException exc) {
            if (this.out != null) {
                this.out.print("Failed connecting process: " + (Object)((Object)exc));
            }
            throw new ResourceException("Failed connecting process: " + (Object)((Object)exc));
        }
        return cnx;
    }

    public final ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequest) throws ResourceException {
        String identityClass;
        String password;
        String userName;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createManagedConnection(" + subject + ", " + cxRequest + ")"));
        }
        String hostName = this.getHostName();
        int serverPort = this.getServerPort();
        if (cxRequest == null) {
            userName = this.getUserName();
            password = this.getPassword();
            identityClass = this.getIdentityClass();
        } else {
            if (!(cxRequest instanceof ConnectionRequest)) {
                if (this.out != null) {
                    this.out.print("Provided ConnectionRequestInfo instance is not a JORAM object.");
                }
                throw new ResourceException("Provided ConnectionRequestInfo instance is not a JORAM object.");
            }
            userName = ((ConnectionRequest)cxRequest).getUserName();
            password = ((ConnectionRequest)cxRequest).getPassword();
            identityClass = ((ConnectionRequest)cxRequest).getIdentityClass();
        }
        XAConnectionFactory factory = this.createFactory(cxRequest);
        this.setParameters(factory);
        ((AbstractConnectionFactory)factory).setIdentityClassName(identityClass);
        XAConnection cnx = this.createXAConnection(factory, userName, password);
        ManagedConnectionImpl managedCx = new ManagedConnectionImpl(this.ra, this, cnx, hostName, serverPort, userName);
        managedCx.setLogWriter(this.out);
        managedCx.subject = subject;
        managedCx.cxRequest = cxRequest;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createManagedConnection managedCx = " + managedCx));
        }
        return managedCx;
    }

    public final ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequest) throws ResourceException {
        String userName;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " matchManagedConnections(" + connectionSet + ", " + subject + ", " + cxRequest + ")"));
        }
        String mode = "Unified";
        if (cxRequest == null) {
            userName = this.getUserName();
        } else {
            if (!(cxRequest instanceof ConnectionRequest)) {
                this.out.print("Provided ConnectionRequestInfo instance is not a JORAM object.");
                throw new ResourceException("Provided ConnectionRequestInfo instance is not a JORAM object.");
            }
            if (cxRequest instanceof QueueConnectionRequest) {
                mode = "PTP";
            } else if (cxRequest instanceof TopicConnectionRequest) {
                mode = "PubSub";
            }
            userName = ((ConnectionRequest)cxRequest).getUserName();
        }
        ManagedConnectionImpl managedCx = null;
        boolean matching = false;
        Iterator it = connectionSet.iterator();
        String hostName = this.getHostName();
        int serverPort = this.getServerPort();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " hostName = " + hostName + ", serverPort = " + serverPort));
        }
        if (this.isCollocated().booleanValue()) {
            hostName = "localhost";
            serverPort = -1;
        }
        while (!matching && it.hasNext()) {
            try {
                managedCx = (ManagedConnectionImpl)it.next();
                matching = managedCx.matches(hostName, serverPort, userName, mode);
            }
            catch (ClassCastException exc) {}
        }
        if (matching) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " matchManagedConnections managedCx = " + managedCx));
            }
            managedCx.setLogWriter(this.out);
            return managedCx;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.out = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.out;
    }

    public int hashCode() {
        return ("Unified:" + this.getHostName() + ":" + this.getServerPort() + "-" + this.getUserName()).hashCode();
    }

    public boolean equals(Object o) {
        boolean res;
        if (!(o instanceof ManagedConnectionFactoryImpl) || o instanceof ManagedQueueConnectionFactoryImpl || o instanceof ManagedTopicConnectionFactoryImpl) {
            return false;
        }
        ManagedConnectionFactoryImpl other = (ManagedConnectionFactoryImpl)o;
        boolean bl = res = this.getHostName().equals(other.getHostName()) && this.getServerPort() == other.getServerPort() && this.getUserName().equals(other.getUserName());
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " equals " + res));
        }
        return res;
    }

    public ResourceAdapter getResourceAdapter() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getResourceAdapter() = " + this.ra));
        }
        return this.ra;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " setResourceAdapter(" + ra + ")"));
        }
        if (this.ra != null) {
            this.out.print("ResourceAdapter instance already associated.");
            throw new javax.resource.spi.IllegalStateException("ResourceAdapter instance already associated.");
        }
        if (!(ra instanceof JoramAdapter)) {
            this.out.print("Provided ResourceAdapter is not a JORAM ResourceAdapter object: " + ra.getClass().getName());
            throw new ResourceException("Provided ResourceAdapter is not a JORAM ResourceAdapter object: " + ra.getClass().getName());
        }
        this.ra = (JoramAdapter)ra;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " setResourceAdapter isCollocated = " + ((JoramAdapter)ra).collocated + ", serverPort = " + ((JoramAdapter)ra).getServerPort()));
        }
        if (((JoramAdapter)ra).collocated && this.getServerPort() < 0) {
            this.setServerPort(((JoramAdapter)ra).getServerPort());
        }
    }

    public Set getInvalidConnections(Set connectionSet) throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getInvalidConnections(" + connectionSet + ")"));
        }
        Iterator it = connectionSet.iterator();
        HashSet<ManagedConnectionImpl> invalidConnections = new HashSet<ManagedConnectionImpl>();
        while (it.hasNext()) {
            try {
                ManagedConnectionImpl managedCx = (ManagedConnectionImpl)it.next();
                if (managedCx.isValid()) continue;
                invalidConnections.add(managedCx);
            }
            catch (ClassCastException exc) {}
        }
        return invalidConnections;
    }
}

