/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import org.objectweb.joram.client.connector.ManagedConnectionImpl;
import org.objectweb.joram.client.connector.OutboundConnectionMBean;
import org.objectweb.joram.client.connector.OutboundSession;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class OutboundConnection
implements Connection,
OutboundConnectionMBean {
    public static Logger logger = Debug.getLogger((String)OutboundConnection.class.getName());
    ManagedConnectionImpl managedCx;
    XAConnection xac;
    boolean valid = true;
    Vector sessions;

    OutboundConnection(ManagedConnectionImpl managedCx, XAConnection xac) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("OutboundConnection(" + managedCx + ", " + xac + ")"));
        }
        this.managedCx = managedCx;
        this.xac = xac;
        this.sessions = new Vector();
        this.registerMBean();
    }

    public void setClientID(String clientID) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " setClientID(" + clientID + ")"));
        }
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " setExceptionListener(" + listener + ")"));
        }
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        Session sess;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createSession(" + transacted + ", " + acknowledgeMode + ")"));
        }
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createSession managedCx.session = " + this.managedCx.session));
        }
        if ((sess = this.managedCx.session) == null) {
            block12: {
                try {
                    sess = this.xac.createSession(false, acknowledgeMode);
                }
                catch (IllegalStateException e) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)(this + " createSession (IllegalStateException)" + (Object)((Object)e)));
                    }
                    logger.log(BasicLevel.WARN, (Object)(this + " createSession reconnection in progress..."));
                    try {
                        if (!this.managedCx.isReconnected()) {
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)(this + " createSession : managed connection is not reconnected."));
                            }
                            throw new JMSException(this + " createSession : managed connection is not reconnected.");
                        }
                        ManagedConnection mc = this.managedCx.mcf.createManagedConnection(this.managedCx.subject, this.managedCx.cxRequest);
                        OutboundConnection outboundConnection = (OutboundConnection)mc.getConnection(this.managedCx.subject, this.managedCx.cxRequest);
                        outboundConnection.managedCx.associateConnection(this);
                        sess = this.xac.createSession(false, acknowledgeMode);
                    }
                    catch (ResourceException exc) {
                        if (!logger.isLoggable(BasicLevel.WARN)) break block12;
                        logger.log(BasicLevel.WARN, (Object)(this + " createSession (ResourceException)"), (Throwable)exc);
                    }
                }
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " createSession sess = " + sess));
            }
        }
        return new OutboundSession(sess, this, transacted);
    }

    public String getClientID() throws JMSException {
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        return this.xac.getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }

    public void start() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " start()"));
        }
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        this.xac.start();
        for (int i = 0; i < this.sessions.size(); ++i) {
            OutboundSession session = (OutboundSession)this.sessions.get(i);
            session.start();
            if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
            logger.log(BasicLevel.DEBUG, (Object)(this + " start session = " + session));
        }
    }

    public void stop() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " stop()"));
        }
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }

    public synchronized void close() throws JMSException {
        this.valid = false;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " close()"));
        }
        for (int i = 0; i < this.sessions.size(); ++i) {
            OutboundSession session = (OutboundSession)this.sessions.get(i);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " close() session = " + session));
            }
            session.close();
        }
        this.managedCx.closeHandle(this);
        this.unregisterMBean();
    }

    public boolean cnxEquals(Object obj) {
        return obj instanceof Connection && this.xac.equals(obj);
    }

    public void cleanup() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " cleanup()"));
        }
        org.objectweb.joram.client.jms.Connection cnx = (org.objectweb.joram.client.jms.Connection)this.xac;
        cnx.cleanup();
    }

    public String toString() {
        return "OutboundConnection[" + this.xac.toString() + "]@" + this.hashCode();
    }

    public String getJMXBeanName(XAConnection cnx) {
        if (!(cnx instanceof org.objectweb.joram.client.jms.Connection)) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(((org.objectweb.joram.client.jms.Connection)cnx).getJMXBeanName());
        buf.append(",location=OutboundConnection");
        buf.append(",OutboundConnection=").append("OutboundConnection@").append(this.hashCode());
        return buf.toString();
    }

    public String registerMBean() {
        String JMXBeanName;
        block4: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("OutboundConnection.registerMBean: " + this));
            }
            JMXBeanName = this.getJMXBeanName(this.xac);
            try {
                if (JMXBeanName != null) {
                    MXWrapper.registerMBean((Object)this, (String)JMXBeanName);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block4;
                logger.log(BasicLevel.DEBUG, (Object)("OutboundConnection.registerMBean: " + JMXBeanName), (Throwable)e);
            }
        }
        return JMXBeanName;
    }

    public void unregisterMBean() {
        block3: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("OutboundConnection.unregisterMBean: " + this));
            }
            try {
                MXWrapper.unregisterMBean((String)this.getJMXBeanName(this.xac));
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, (Object)("OutboundConnection.unregisterMBean: " + this.getJMXBeanName(this.xac)), (Throwable)e);
            }
        }
    }

    public int getNumberOfSession() {
        return this.sessions.size();
    }

    public String[] getSessions() {
        String[] sessTab = new String[this.sessions.size()];
        for (int i = 0; i < this.sessions.size(); ++i) {
            OutboundSession outboundSess = (OutboundSession)this.sessions.get(i);
            try {
                sessTab[i] = outboundSess.sess.toString();
                continue;
            }
            catch (Exception e) {
                sessTab[i] = "unknown";
            }
        }
        return sessTab;
    }
}

