/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.ChannelReceiver;
import org.apache.catalina.tribes.MessageListener;
import org.apache.catalina.tribes.io.ListenCallback;
import org.apache.catalina.tribes.transport.RxTaskPool;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class ReceiverBase
implements ChannelReceiver,
ListenCallback,
RxTaskPool.TaskCreator {
    public static final int OPTION_DIRECT_BUFFER = 4;
    protected static Log log = LogFactory.getLog(ReceiverBase.class);
    private MessageListener listener;
    private String host = "auto";
    private InetAddress bind;
    private int port = 4000;
    private int securePort = -1;
    private int rxBufSize = 43800;
    private int txBufSize = 25188;
    private boolean listen = false;
    private RxTaskPool pool;
    private boolean direct = true;
    private long tcpSelectorTimeout = 5000L;
    private int autoBind = 100;
    private int maxThreads = Integer.MAX_VALUE;
    private int minThreads = 6;
    private int maxTasks = 100;
    private int minTasks = 10;
    private boolean tcpNoDelay = true;
    private boolean soKeepAlive = false;
    private boolean ooBInline = true;
    private boolean soReuseAddress = true;
    private boolean soLingerOn = true;
    private int soLingerTime = 3;
    private int soTrafficClass = 28;
    private int timeout = 3000;
    private boolean useBufferPool = true;
    private ExecutorService executor;

    public void start() throws IOException {
        if (this.executor == null) {
            this.executor = new ThreadPoolExecutor(this.minThreads, this.maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }
    }

    public void stop() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.executor = null;
    }

    public MessageListener getMessageListener() {
        return this.listener;
    }

    public int getPort() {
        return this.port;
    }

    public int getRxBufSize() {
        return this.rxBufSize;
    }

    public int getTxBufSize() {
        return this.txBufSize;
    }

    public int getTcpThreadCount() {
        return this.getMaxThreads();
    }

    public void setMessageListener(MessageListener listener) {
        this.listener = listener;
    }

    public void setTcpListenPort(int tcpListenPort) {
        this.setPort(tcpListenPort);
    }

    public void setTcpListenAddress(String tcpListenHost) {
        this.setAddress(tcpListenHost);
    }

    public void setRxBufSize(int rxBufSize) {
        this.rxBufSize = rxBufSize;
    }

    public void setTxBufSize(int txBufSize) {
        this.txBufSize = txBufSize;
    }

    public void setTcpThreadCount(int tcpThreadCount) {
        this.setMaxThreads(tcpThreadCount);
        this.setMinThreads(tcpThreadCount);
    }

    public InetAddress getBind() {
        if (this.bind == null) {
            try {
                if ("auto".equals(this.host)) {
                    this.host = InetAddress.getLocalHost().getHostAddress();
                }
                if (log.isDebugEnabled()) {
                    log.debug("Starting replication listener on address:" + this.host);
                }
                this.bind = InetAddress.getByName(this.host);
            }
            catch (IOException ioe) {
                log.error("Failed bind replication listener on address:" + this.host, ioe);
            }
        }
        return this.bind;
    }

    protected int bind(ServerSocket socket, int portstart, int retries) throws IOException {
        InetSocketAddress addr = null;
        while (retries > 0) {
            try {
                addr = new InetSocketAddress(this.getBind(), portstart);
                socket.bind(addr);
                this.setPort(portstart);
                log.info("Receiver Server Socket bound to:" + addr);
                return 0;
            }
            catch (IOException x) {
                if (--retries <= 0) {
                    log.info("Unable to bind server socket to:" + addr + " throwing error.");
                    throw x;
                }
                ++portstart;
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException ti) {
                    Thread.currentThread();
                    Thread.interrupted();
                }
                retries = this.bind(socket, portstart, retries);
            }
        }
        return retries;
    }

    public void messageDataReceived(ChannelMessage data) {
        if (this.listener != null && this.listener.accept(data)) {
            this.listener.messageReceived(data);
        }
    }

    public int getWorkerThreadOptions() {
        int options = 0;
        if (this.getDirect()) {
            options |= 4;
        }
        return options;
    }

    public void setBind(InetAddress bind) {
        this.bind = bind;
    }

    public int getTcpListenPort() {
        return this.getPort();
    }

    public boolean getDirect() {
        return this.direct;
    }

    public void setDirect(boolean direct) {
        this.direct = direct;
    }

    public String getAddress() {
        this.getBind();
        return this.host;
    }

    public String getHost() {
        return this.getAddress();
    }

    public long getSelectorTimeout() {
        return this.tcpSelectorTimeout;
    }

    public long getTcpSelectorTimeout() {
        return this.getSelectorTimeout();
    }

    public boolean doListen() {
        return this.listen;
    }

    public MessageListener getListener() {
        return this.listener;
    }

    public RxTaskPool getTaskPool() {
        return this.pool;
    }

    public String getTcpListenAddress() {
        return this.getAddress();
    }

    public int getAutoBind() {
        return this.autoBind;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public boolean getSoKeepAlive() {
        return this.soKeepAlive;
    }

    public boolean getOoBInline() {
        return this.ooBInline;
    }

    public boolean getSoLingerOn() {
        return this.soLingerOn;
    }

    public int getSoLingerTime() {
        return this.soLingerTime;
    }

    public boolean getSoReuseAddress() {
        return this.soReuseAddress;
    }

    public int getSoTrafficClass() {
        return this.soTrafficClass;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean getUseBufferPool() {
        return this.useBufferPool;
    }

    public int getSecurePort() {
        return this.securePort;
    }

    public int getMinTasks() {
        return this.minTasks;
    }

    public int getMaxTasks() {
        return this.maxTasks;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public boolean isListening() {
        return this.listen;
    }

    public void setTcpSelectorTimeout(long selTimeout) {
        this.setSelectorTimeout(selTimeout);
    }

    public void setSelectorTimeout(long selTimeout) {
        this.tcpSelectorTimeout = selTimeout;
    }

    public void setListen(boolean doListen) {
        this.listen = doListen;
    }

    public void setAddress(String host) {
        this.host = host;
    }

    public void setHost(String host) {
        this.setAddress(host);
    }

    public void setListener(MessageListener listener) {
        this.listener = listener;
    }

    public void setLog(Log log) {
        ReceiverBase.log = log;
    }

    public void setPool(RxTaskPool pool) {
        this.pool = pool;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAutoBind(int autoBind) {
        this.autoBind = autoBind;
        if (this.autoBind <= 0) {
            this.autoBind = 1;
        }
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public void setSoKeepAlive(boolean soKeepAlive) {
        this.soKeepAlive = soKeepAlive;
    }

    public void setOoBInline(boolean ooBInline) {
        this.ooBInline = ooBInline;
    }

    public void setSoLingerOn(boolean soLingerOn) {
        this.soLingerOn = soLingerOn;
    }

    public void setSoLingerTime(int soLingerTime) {
        this.soLingerTime = soLingerTime;
    }

    public void setSoReuseAddress(boolean soReuseAddress) {
        this.soReuseAddress = soReuseAddress;
    }

    public void setSoTrafficClass(int soTrafficClass) {
        this.soTrafficClass = soTrafficClass;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setUseBufferPool(boolean useBufferPool) {
        this.useBufferPool = useBufferPool;
    }

    public void setSecurePort(int securePort) {
        this.securePort = securePort;
    }

    public void setMinTasks(int minTasks) {
        this.minTasks = minTasks;
    }

    public void setMaxTasks(int maxTasks) {
        this.maxTasks = maxTasks;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void heartbeat() {
    }
}

