/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.List;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.jasper.EmbeddedServletOptions;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.servlet.JspServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiInstanceTldCacheListener
implements InstanceListener {
    private List<URL> resourcesToMonitor = null;

    public OSGiInstanceTldCacheListener(List<URL> resourcesToMonitor) {
        this.resourcesToMonitor = resourcesToMonitor;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void instanceEvent(InstanceEvent event) {
        if (!"afterInit".equals(event.getType())) return;
        try {
            JspServlet jspServlet = (JspServlet)event.getServlet();
            Field optionsField = JspServlet.class.getDeclaredField("options");
            optionsField.setAccessible(true);
            EmbeddedServletOptions options = (EmbeddedServletOptions)optionsField.get(jspServlet);
            TldLocationsCache tldLocationCache = options.getTldLocationsCache();
            Method getUriFromTldMethod = TldLocationsCache.class.getDeclaredMethod("getUriFromTld", String.class, InputStream.class);
            getUriFromTldMethod.setAccessible(true);
            Field mappingsField = TldLocationsCache.class.getDeclaredField("mappings");
            mappingsField.setAccessible(true);
            if (this.resourcesToMonitor == null) return;
            for (URL url : this.resourcesToMonitor) {
                InputStream stream;
                block16: {
                    stream = null;
                    URLConnection urlConnection = url.openConnection();
                    urlConnection.setDefaultUseCaches(false);
                    stream = urlConnection.getInputStream();
                    String uri = (String)getUriFromTldMethod.invoke((Object)tldLocationCache, url.toString(), stream);
                    Hashtable mappings = (Hashtable)mappingsField.get(tldLocationCache);
                    if (uri == null || mappings.get(uri) != null) break block16;
                    mappings.put(uri, new String[]{url.toString(), url.getPath().substring(1)});
                }
                Object var15_22 = null;
                try {
                    stream.close();
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to add the TLD", e);
                }
                {
                    catch (IOException e) {
                        throw new IllegalStateException("Unable to add the TLD", e);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Unable to add the TLD", e);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException("Unable to add the TLD", e);
                    }
                }
                catch (Throwable throwable) {
                    var15_22 = null;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Unable to add the TLD", e);
                    }
                    return;
                }
            }
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Unable to get TLDCache", e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Unable to get TLDCache", e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unable to get TLDCache", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to get TLDCache", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to get TLDCache", e);
        }
    }
}

