/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import net.jcip.annotations.ThreadSafe;
import org.ow2.cmi.controller.client.CMIClientClassLoader;
import org.ow2.cmi.controller.client.ClientClusterViewCache;
import org.ow2.cmi.controller.client.ClientClusterViewManager;
import org.ow2.cmi.controller.client.ClientClusterViewManagerException;
import org.ow2.cmi.controller.client.ClientClusteredObjectView;
import org.ow2.cmi.controller.client.IClientConfig;
import org.ow2.cmi.controller.client.IUpdatedClientConfig;
import org.ow2.cmi.controller.common.AbsClusterViewManager;
import org.ow2.cmi.controller.common.CMIThreadFactory;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.common.ClusterViewManagerException;
import org.ow2.cmi.controller.common.ClusteredDummyRegistry;
import org.ow2.cmi.controller.common.ImmutableClusteredObjectInfos;
import org.ow2.cmi.controller.provider.ClientClusterViewProvider;
import org.ow2.cmi.controller.provider.ClusteredClientClusterViewProvider;
import org.ow2.cmi.info.CMIInfoExtractor;
import org.ow2.cmi.info.CMIInfoExtractorException;
import org.ow2.cmi.info.ClusteredObjectInfo;
import org.ow2.cmi.lb.data.PolicyData;
import org.ow2.cmi.lb.policy.IPolicy;
import org.ow2.cmi.lb.strategy.IStrategy;
import org.ow2.cmi.pool.StubOrProxyFactory;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.reference.ServerId;
import org.ow2.cmi.reference.ServerNotFoundException;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.cmi.rpc.CMIProxy;
import org.ow2.cmi.rpc.POJOInvocationHandler;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.PoolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class ClientClusterViewManagerImpl
extends AbsClusterViewManager
implements ClientClusterViewManager {
    private static final Log LOGGER = LogFactory.getLog(ClientClusterViewManagerImpl.class);
    private final String initialContextFactoryName;
    private final String protocol;
    private final Thread clientClusterViewUpdater;
    private volatile ClientClusterViewProvider clientClusterViewProvider;
    private final ClientClusterViewCache clientClusterViewCache = new ClientClusterViewCache();
    private List<CMIReference> providerServerRefs;
    private volatile boolean clusterViewProviderAvailable = false;
    private long configDate = -1L;
    private volatile boolean refreshed;
    private boolean started = false;
    private int delayToRefresh = 10000;
    private final ServerId localRegistryId;

    public ClientClusterViewManagerImpl(String initialContextFactoryName, String protocol, List<ServerRef> serverRefs, ServerId localRegistryId) throws ClientClusterViewManagerException {
        this.initialContextFactoryName = initialContextFactoryName;
        this.protocol = protocol;
        this.localRegistryId = localRegistryId;
        CMIThreadFactory cmiThreadFactory = this.getCmiThreadFactory();
        this.clientClusterViewUpdater = cmiThreadFactory.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ClientClusterViewManagerImpl.this.clientClusterViewProvider.registerClient(ClientClusterViewManagerImpl.this.getUUID());
                }
                catch (Exception e) {
                    LOGGER.debug((Object)"Thread {0}> Cannot register the client", new Object[]{Thread.currentThread().getName(), e});
                }
                ClientClusterViewManagerImpl.this.refreshed = true;
                do {
                    LOGGER.debug((Object)"Thread {0}> Updating the client cluster view...", new Object[]{Thread.currentThread().getName()});
                    try {
                        ClientClusterViewManagerImpl.this.updateClusterView();
                        if (ClientClusterViewManagerImpl.this.getState().equals((Object)ClusterViewManager.State.STARTED)) {
                            ClientClusterViewManagerImpl.this.setState(ClusterViewManager.State.AVAILABLE);
                        }
                        ClientClusterViewManagerImpl.this.clusterViewProviderAvailable = true;
                    }
                    catch (Exception e) {
                        if (ClientClusterViewManagerImpl.this.getState().equals((Object)ClusterViewManager.State.AVAILABLE)) {
                            ClientClusterViewManagerImpl.this.setState(ClusterViewManager.State.STARTED);
                        }
                        LOGGER.warn((Object)"Thread {0}> Cannot update the cluster view", new Object[]{Thread.currentThread().getName(), e});
                    }
                    ClientClusterViewManagerImpl e = ClientClusterViewManagerImpl.this;
                    synchronized (e) {
                        if (!ClientClusterViewManagerImpl.this.started) {
                            ClientClusterViewManagerImpl.this.started = true;
                            ClientClusterViewManagerImpl.this.notify();
                        }
                    }
                    int refreshTime = ClientClusterViewManagerImpl.this.getDelayToRefresh();
                    LOGGER.debug((Object)"Thread {0} is sleeping for {1} millis...", new Object[]{Thread.currentThread().getName(), refreshTime});
                    try {
                        Thread.sleep(refreshTime);
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                    }
                } while (ClientClusterViewManagerImpl.this.refreshed);
            }
        }, "Cluster View Updater");
        this.initDataOfProvider(serverRefs);
        this.initDataOfDummyRegistry();
    }

    private void initDataOfProvider(List<ServerRef> serverRefs) throws ClientClusterViewManagerException {
        ClusteredObjectInfo clusteredObjectInfo;
        LOGGER.debug((Object)"**** Begin of initialization of the connection at provider...", new Object[0]);
        String providerName = this.getConfig().getClientProviderName();
        try {
            clusteredObjectInfo = CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(providerName, ClientClusterViewProvider.class, ClusteredClientClusterViewProvider.class, false, null);
        }
        catch (CMIInfoExtractorException e) {
            LOGGER.error((Object)"Cannot extract the informations about provider", new Object[]{e});
            throw new ClientClusterViewManagerException("Cannot extract the informations about provider", e);
        }
        Class<?> itfClass = clusteredObjectInfo.getItfClass();
        Class<? extends EJBObject> businessClass = clusteredObjectInfo.getBusinessClass();
        String businessName = null;
        if (businessClass != null) {
            businessName = businessClass.getName();
        }
        ClientClusteredObjectView clusteredObjectView = this.clientClusterViewCache.addClusteredObject(clusteredObjectInfo.getClusterName(), clusteredObjectInfo.isProxyEnabled(), providerName, itfClass.getName(), businessName, clusteredObjectInfo.hasState(), clusteredObjectInfo.getApplicationExceptionNames());
        ArrayList<CMIReference> cmiReferences = new ArrayList<CMIReference>();
        for (ServerRef serverRef : serverRefs) {
            cmiReferences.add(new CMIReference(serverRef, providerName));
        }
        this.providerServerRefs = cmiReferences;
        clusteredObjectView.setCMIReferences(cmiReferences);
        clusteredObjectView.setItfClass(ClientClusterViewProvider.class);
        Class<IPolicy<?>> policyClass = clusteredObjectInfo.getPolicyType();
        Class<IStrategy<?>> strategyClass = clusteredObjectInfo.getStrategyType();
        String policyClassname = policyClass.getName();
        String strategyClassname = strategyClass.getName();
        PolicyData policyDataForProvider = new PolicyData(policyClassname, strategyClassname, clusteredObjectInfo.getProperties());
        clusteredObjectView.setPolicyData(policyDataForProvider);
        this.clientClusterViewCache.setPolicyClass(policyClassname, policyClass);
        this.clientClusterViewCache.setStrategyClass(strategyClassname, strategyClass);
        this.watch(providerName);
        try {
            this.updatePolicy(providerName);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error((Object)"Cannot initialize informations of the provider", new Object[]{e});
            throw new ClientClusterViewManagerException("Cannot initialize informations of the provider", e);
        }
        JPool pool = new JPool((PoolFactory)new StubOrProxyFactory(this));
        pool.setPoolConfiguration(clusteredObjectInfo.getPoolConfiguration());
        this.setPool(providerName, (Pool<CMIReferenceable<?>, CMIReference>)pool);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        POJOInvocationHandler invocationHandler = new POJOInvocationHandler(classLoader, this, providerName, this.protocol, ClientClusterViewProvider.class);
        this.clientClusterViewProvider = (ClientClusterViewProvider)Proxy.newProxyInstance(classLoader, new Class[]{ClientClusterViewProvider.class, CMIProxy.class}, (InvocationHandler)invocationHandler);
        LOGGER.debug((Object)"**** End of initialization of the connection at provider.", new Object[0]);
    }

    private void initDataOfDummyRegistry() throws ClientClusterViewManagerException {
        ClusteredObjectInfo clusteredObjectInfo;
        String dummyName = this.getConfig().getDummyRegistryName();
        try {
            clusteredObjectInfo = CMIInfoExtractor.extractClusteringInfoFromAnnotatedPOJO(dummyName, null, ClusteredDummyRegistry.class, false, null);
        }
        catch (CMIInfoExtractorException e) {
            LOGGER.error((Object)"Cannot get infos for dummy registry", new Object[]{e});
            throw new ClientClusterViewManagerException("Cannot get infos for dummy registry", e);
        }
        this.clientClusterViewCache.addClusteredObject(clusteredObjectInfo.getClusterName(), clusteredObjectInfo.isProxyEnabled(), dummyName, null, null, clusteredObjectInfo.hasState(), clusteredObjectInfo.getApplicationExceptionNames());
        this.watch(dummyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObjectToWatch(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        if (!this.isWatched(objectName)) {
            ImmutableClusteredObjectInfos immutableInfos;
            LOGGER.debug((Object)"Initializing local data for object with name {0}", new Object[]{objectName});
            try {
                immutableInfos = this.clientClusterViewProvider.getImmutableInfos(objectName);
            }
            catch (RemoteException e) {
                LOGGER.error((Object)"Cannot get the immutable infos for {0}", new Object[]{objectName, e});
                throw new ClientClusterViewManagerException("Cannot get the immutable infos for " + objectName, e);
            }
            ClassLoader currentCLoader = Thread.currentThread().getContextClassLoader();
            ClientClusterViewCache clientClusterViewCache = this.clientClusterViewCache;
            synchronized (clientClusterViewCache) {
                Class<?> itfClass;
                ClientClusteredObjectView clusteredObjectView = this.clientClusterViewCache.addClusteredObject(immutableInfos);
                String itfName = immutableInfos.getItfName();
                try {
                    itfClass = Class.forName(itfName, true, currentCLoader);
                    clusteredObjectView.setItfClass(itfClass);
                }
                catch (ClassNotFoundException e) {
                    throw new ClientClusterViewManagerException("Cannot load the interface for name " + itfName, e);
                }
                if (Arrays.asList(itfClass.getInterfaces()).contains(EJBHome.class)) {
                    String businessName = immutableInfos.getBusinessName();
                    try {
                        Class<?> businessClass = Class.forName(businessName, true, currentCLoader);
                        clusteredObjectView.setBusinessClass(businessClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ClientClusterViewManagerException("Cannot load the business interface for name " + businessName, e);
                    }
                }
                this.watch(objectName);
                try {
                    this.pullAndUpdateObjectInfos(objectName);
                }
                catch (Exception e) {
                    LOGGER.warn((Object)"Cannot get object infos for {0}", new Object[]{objectName, e});
                }
            }
        }
    }

    @Override
    public boolean starting() {
        this.clientClusterViewUpdater.start();
        while (!this.started) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.clusterViewProviderAvailable) {
            this.setState(ClusterViewManager.State.AVAILABLE);
        } else {
            this.setState(ClusterViewManager.State.STARTED);
        }
        LOGGER.info((Object)"The CMI client was successfully started.", new Object[0]);
        return this.clusterViewProviderAvailable;
    }

    @Override
    public void stopping() {
        this.refreshed = false;
        this.providerServerRefs = null;
        this.clientClusterViewCache.clear();
        this.clientClusterViewProvider = null;
    }

    @Override
    public Class<?> getInterface(String objectName) throws ObjectNotFoundException {
        try {
            return this.clientClusterViewCache.getClusteredObject(objectName).getItfClass();
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
    }

    @Override
    public Class<? extends EJBObject> getRemoteClass(String objectName) throws ObjectNotFoundException {
        try {
            return this.clientClusterViewCache.getClusteredObject(objectName).getBusinessClass();
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<? extends IPolicy<?>> getPolicyClass(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        ClientClusterViewCache clientClusterViewCache = this.clientClusterViewCache;
        synchronized (clientClusterViewCache) {
            String classname = this.getPolicyClassName(objectName);
            Class<? extends IPolicy<?>> policy = this.clientClusterViewCache.getPolicyClass(classname);
            if (policy == null) {
                try {
                    policy = this.pullPolicyClass(objectName);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Cannot set the class of policy for {0}", new Object[]{objectName, e});
                    throw new ClientClusterViewManagerException("Cannot set the class of policy for " + objectName, e);
                }
                this.clientClusterViewCache.setPolicyClass(classname, policy);
            }
            return policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<? extends IStrategy<?>> getStrategyClass(String objectName) throws ObjectNotFoundException, ClientClusterViewManagerException {
        ClientClusterViewCache clientClusterViewCache = this.clientClusterViewCache;
        synchronized (clientClusterViewCache) {
            String classname = this.getStrategyClassName(objectName);
            Class<? extends IStrategy<?>> strategy = this.clientClusterViewCache.getStrategyClass(classname);
            if (strategy == null) {
                try {
                    strategy = this.pullStrategyClass(objectName);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Cannot set the class of strategy for {0}", new Object[]{objectName, e});
                    throw new ClientClusterViewManagerException("Cannot set the class of strategy for " + objectName, e);
                }
                this.clientClusterViewCache.setStrategyClass(classname, strategy);
            }
            return strategy;
        }
    }

    public List<CMIReference> getCMIReferences(String objectName, String protocolName) throws ObjectNotFoundException {
        try {
            return this.clientClusterViewCache.getClusteredObject(objectName).getCMIReferences();
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
    }

    @Override
    public long getDateOfProperties(String objectName) throws ObjectNotFoundException {
        try {
            return this.clientClusterViewCache.getClusteredObject(objectName).getPolicyData().getDateOfProperties();
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
    }

    @Override
    public Map<String, Object> getPropertiesForPolicy(String objectName) throws ObjectNotFoundException {
        try {
            return this.clientClusterViewCache.getClusteredObject(objectName).getPolicyData().getProperties();
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
    }

    @Override
    public Object getPropertyForPolicy(String objectName, String propertyName) throws ObjectNotFoundException {
        try {
            return this.clientClusterViewCache.getClusteredObject(objectName).getPolicyData().getProperties().get(propertyName);
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
    }

    @Override
    public String getInitialContextFactoryName(String protocolName) {
        return this.initialContextFactoryName;
    }

    @Override
    public Set<String> getProtocols() {
        return Collections.singleton(this.protocol);
    }

    @Override
    public String getInitialContextFactoryName() {
        return this.initialContextFactoryName;
    }

    @Override
    public String getProtocolName() {
        return this.protocol;
    }

    @Override
    public ServerId getLocalRegistryId() {
        return this.localRegistryId;
    }

    @Override
    public List<ServerRef> getProviderURLs() {
        ArrayList<ServerRef> serverRefs = new ArrayList<ServerRef>(this.providerServerRefs.size());
        for (CMIReference cmiRef : this.providerServerRefs) {
            serverRefs.add(cmiRef.getServerRef());
        }
        return serverRefs;
    }

    @Override
    public byte[] getBytecode(String binaryName) throws ClientClusterViewManagerException {
        try {
            return this.clientClusterViewProvider.getBytecode(binaryName);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot get bytecode for {0}", new Object[]{binaryName, e});
            throw new ClientClusterViewManagerException("Cannot get bytecode for " + binaryName, e);
        }
    }

    @Override
    public boolean isClustered(String objectName) {
        try {
            return this.clientClusterViewProvider.isClustered(objectName);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Connection has failed: {0} non clustered", new Object[]{objectName, e});
            return false;
        }
    }

    @Override
    public int getDelayToRefresh() {
        try {
            return this.clientClusterViewProvider.getDelayToRefresh();
        }
        catch (RemoteException e) {
            LOGGER.warn((Object)"Cannot update delay to refresh", new Object[]{e});
            return this.delayToRefresh;
        }
    }

    @Override
    public String getPolicyClassName(String objectName) throws ObjectNotFoundException {
        try {
            return this.clientClusterViewCache.getClusteredObject(objectName).getPolicyData().getPolicyType();
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
    }

    @Override
    public String getStrategyClassName(String objectName) throws ObjectNotFoundException {
        try {
            return this.clientClusterViewCache.getClusteredObject(objectName).getPolicyData().getStrategyType();
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
    }

    @Override
    public String getClusterName(String objectName) throws ObjectNotFoundException {
        try {
            return this.clientClusterViewCache.getClusteredObject(objectName).getClusterName();
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
    }

    @Override
    public boolean isProxyEnabled(String objectName) throws ObjectNotFoundException {
        try {
            return this.clientClusterViewCache.getClusteredObject(objectName).isProxyEnabled();
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
    }

    @Override
    public int getLoadFactor(ServerRef serverRef) {
        return this.clientClusterViewCache.getLoadFactor(serverRef);
    }

    @Override
    public boolean hasState(String objectName) throws ObjectNotFoundException {
        try {
            return this.clientClusterViewCache.getClusteredObject(objectName).isStateful();
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
    }

    @Override
    public boolean isReplicated(String objectName) throws ObjectNotFoundException {
        try {
            return this.clientClusterViewCache.getClusteredObject(objectName).isReplicated();
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
    }

    @Override
    public Set<String> getApplicationExceptionNames(String objectName) throws ObjectNotFoundException {
        try {
            return this.clientClusterViewCache.getClusteredObject(objectName).getApplicationExceptionNames();
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)"Object is unknown: {0}", new Object[]{objectName});
            throw new ObjectNotFoundException("Object is unknown: " + objectName);
        }
    }

    @Override
    public Set<String> getObjectNames() {
        return this.clientClusterViewCache.getObjectNames();
    }

    @Override
    public boolean isPoolToEmpty(String objectName) {
        return false;
    }

    @Override
    public IPoolConfiguration getPoolConfiguration(String objectName) throws ObjectNotFoundException {
        try {
            return this.clientClusterViewProvider.getPoolConfiguration(objectName);
        }
        catch (RemoteException e) {
            LOGGER.error((Object)"Cannot get the configuration of pool for object with name {0}", new Object[]{objectName, e});
            throw new RuntimeException("Cannot get the configuration of pool for object with name " + objectName, e);
        }
    }

    @Override
    public void updateClusterView() throws ClientClusterViewManagerException, RemoteException {
        this.pullAndUpdateConfiguration();
        for (String objectName : this.getNamesOfWatchedObject()) {
            try {
                this.pullAndUpdateObjectInfos(objectName);
            }
            catch (ObjectNotFoundException e) {
                LOGGER.error((Object)"The object with name {0} is unknown", new Object[]{objectName, e});
                throw new ClientClusterViewManagerException("The object with name " + objectName + " is unknown", e);
            }
        }
        this.pullAndUpdateLoadFactors();
    }

    private void pullAndUpdateConfiguration() throws RemoteException {
        long configDate = this.clientClusterViewProvider.getDateOfConfiguration();
        if (configDate > this.configDate) {
            this.setConfiguration(this.clientClusterViewProvider.getConfiguration());
            this.configDate = configDate;
        }
    }

    private void setConfiguration(IUpdatedClientConfig updatedClientConfig) {
        ((IClientConfig)this.getConfig()).setUpdatedConfig(updatedClientConfig);
    }

    private Class<? extends IPolicy<?>> pullPolicyClass(String objectName) throws ObjectNotFoundException, RemoteException, ClientClusterViewManagerException {
        Class<? extends IPolicy<?>> policyClass;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new CMIClientClassLoader(oldClassLoader, this));
        try {
            policyClass = this.clientClusterViewProvider.getPolicyClass(objectName);
        }
        catch (ClusterViewManagerException e) {
            LOGGER.error((Object)"Cannot download the policy class for {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot download the policy class for " + objectName, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return policyClass;
    }

    private Class<? extends IStrategy<?>> pullStrategyClass(String objectName) throws RemoteException, ObjectNotFoundException, ClientClusterViewManagerException {
        Class<? extends IStrategy<?>> strategyClass;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new CMIClientClassLoader(oldClassLoader, this));
        try {
            strategyClass = this.clientClusterViewProvider.getStrategyClass(objectName);
        }
        catch (ClusterViewManagerException e) {
            LOGGER.error((Object)"Cannot download the strategy class for {0}", new Object[]{objectName, e});
            throw new ClientClusterViewManagerException("Cannot download the strategy class for " + objectName, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return strategyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pullAndUpdateObjectInfos(String objectName) throws RemoteException, ObjectNotFoundException {
        LOGGER.debug((Object)"Updating infos for: {0} - thread is {1}", new Object[]{objectName, Thread.currentThread().getName()});
        ClientClusterViewCache clientClusterViewCache = this.clientClusterViewCache;
        synchronized (clientClusterViewCache) {
            if (objectName.equals(this.getConfig().getClientProviderName()) && this.clientClusterViewCache.getClusteredObject(objectName).getCMIReferences().isEmpty()) {
                LOGGER.warn((Object)"No provider URLs found for the provider, trying with the initials: ", new Object[]{this.providerServerRefs});
                this.clientClusterViewCache.getClusteredObject(objectName).setCMIReferences(this.providerServerRefs);
            }
            this.pullAddUpdateReplicationInfos(objectName);
            this.pullAndUpdatePolicy(objectName);
            this.pullAndUpdateCMIReferences(objectName);
        }
    }

    private void pullAddUpdateReplicationInfos(String objectName) throws RemoteException, ObjectNotFoundException {
        this.clientClusterViewCache.getClusteredObject(objectName).setReplicated(this.clientClusterViewProvider.isReplicated(objectName));
    }

    private void pullAndUpdatePolicy(String objectName) throws RemoteException, ObjectNotFoundException {
        String lastPolicyName = this.clientClusterViewProvider.getPolicyClassName(objectName);
        LOGGER.debug((Object)"New policy name: {0}", new Object[]{lastPolicyName});
        String lastStrategyName = this.clientClusterViewProvider.getStrategyClassName(objectName);
        LOGGER.debug((Object)"New strategy name: {0}", new Object[]{lastStrategyName});
        long dateOfLastProps = this.clientClusterViewProvider.getDateOfProperties(objectName);
        LOGGER.debug((Object)"New date of properties: {0}", new Object[]{dateOfLastProps});
        if (this.clientClusterViewCache.getClusteredObject(objectName).getPolicyData() != null) {
            String policyName = this.getPolicyClassName(objectName);
            LOGGER.debug((Object)"Old policy name: {0}", new Object[]{policyName});
            long dateOfProps = this.getDateOfProperties(objectName);
            LOGGER.debug((Object)"Old date of properties: {0}", new Object[]{dateOfProps});
            String strategyName = this.getStrategyClassName(objectName);
            LOGGER.debug((Object)"Old strategy name: {0}", new Object[]{strategyName});
            if (policyName.equals(lastPolicyName) && dateOfProps == dateOfLastProps && strategyName.equals(lastStrategyName)) {
                return;
            }
        }
        Map<Object, Object> lastProperties = dateOfLastProps == 0L ? new HashMap() : this.clientClusterViewProvider.getPropertiesForPolicy(objectName);
        this.clientClusterViewCache.getClusteredObject(objectName).setPolicyData(new PolicyData(lastPolicyName, lastStrategyName, lastProperties, dateOfLastProps));
        this.updatePolicy(objectName);
    }

    private void pullAndUpdateCMIReferences(String objectName) throws RemoteException, ObjectNotFoundException {
        Collection<CMIReference> cmiReferences = this.clientClusterViewProvider.getCMIReferences(objectName, this.protocol);
        for (CMIReference cmiRef : cmiReferences) {
            this.pullAndUpdateMissingLoadFactor(cmiRef.getServerRef());
        }
        this.clientClusterViewCache.getClusteredObject(objectName).setCMIReferences(cmiReferences);
    }

    private void pullAndUpdateMissingLoadFactor(ServerRef serverRef) throws RemoteException {
        try {
            this.clientClusterViewCache.getLoadFactor(serverRef);
        }
        catch (NullPointerException npe) {
            try {
                int loadFactor = this.clientClusterViewProvider.getLoadFactor(serverRef);
                this.clientClusterViewCache.setLoadFactor(serverRef, loadFactor);
            }
            catch (ServerNotFoundException e) {
                LOGGER.warn((Object)"Server not found: {0}", new Object[]{serverRef, e});
            }
        }
    }

    private void pullAndUpdateLoadFactors() throws RemoteException {
        for (ServerRef address : this.clientClusterViewCache.getAddressesOfServer()) {
            try {
                int loadFactor = this.clientClusterViewProvider.getLoadFactor(address);
                this.clientClusterViewCache.setLoadFactor(address, loadFactor);
            }
            catch (ServerNotFoundException e) {
                LOGGER.debug((Object)"server not found: {0}", new Object[]{address, e});
                this.clientClusterViewCache.removeLoadFactor(address);
            }
        }
    }
}

