/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.ExpiredNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.common.Debug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.messages.Message;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.FwdAdminRequestNot;
import org.objectweb.joram.mom.notifications.PingNot;
import org.objectweb.joram.mom.notifications.PongNot;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.shared.admin.AddRemoteDestination;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.DelRemoteDestination;
import org.objectweb.joram.shared.admin.SendDestinationsWeights;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class AliasInQueue
extends Queue {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)AliasInQueue.class.getName());
    public static final String REMOTE_AGENT_OPTION = "remoteAgentID";
    private ArrayList<AgentId> destinations = null;
    private ArrayList<Long> oldmetrics = null;
    private ArrayList<Long> newmetrics = null;
    private ArrayList<Long> metrics = null;
    private ArrayList<Long> weights = null;
    private int currentDestination = 0;
    private int receivedMetrics = 0;
    private long minMetrics = Long.MAX_VALUE;
    private long weightLeft = 1L;
    private static long pendingMessagesThreshold = 3000L;

    public void setProperties(Properties properties, boolean firstTime) throws Exception {
        super.setProperties(properties, firstTime);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AliasInQueue.<init> prop = " + properties));
        }
        if (properties != null && properties.containsKey(REMOTE_AGENT_OPTION)) {
            try {
                String[] agents = properties.getProperty(REMOTE_AGENT_OPTION).split(";");
                this.destinations = new ArrayList();
                this.oldmetrics = new ArrayList();
                this.newmetrics = new ArrayList();
                this.metrics = new ArrayList();
                this.weights = new ArrayList();
                for (String str : agents) {
                    this.destinations.add(AgentId.fromString((String)str));
                    this.oldmetrics.add(new Long(0L));
                    this.newmetrics.add(new Long(0L));
                    this.metrics.add(new Long(0L));
                    this.weights.add(new Long(1L));
                }
            }
            catch (IllegalArgumentException exc) {
                logger.log(BasicLevel.ERROR, (Object)"AliasInQueue: can't parse 'remoteAgentID option.", (Throwable)exc);
            }
        }
        if (this.destinations == null) {
            throw new Exception("Remote agent identifier is null or invalid. The property 'remoteAgentID' of the Alias queue has not been set properly.");
        }
    }

    public ClientMessages preProcess(AgentId from, ClientMessages cm) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("AliasInQueue.preProcess(" + from + ", " + (Object)((Object)cm) + ')'));
        }
        if (this.messages.size() > 0) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"Messages are already waiting, enqueue the new ones");
            }
            return cm;
        }
        ClientMessages forward = new ClientMessages(-1, -1, cm.getMessages());
        forward.setDeadNotificationAgentId(this.getId());
        forward.setAsyncSend(true);
        this.sendNot(forward);
        this.nbMsgsDeliverSinceCreation += (long)forward.getMessageCount();
        return null;
    }

    protected void handleExpiredNot(AgentId from, ExpiredNot not) {
        Notification expiredNot;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ExpiredNot received, messages will be queued.");
        }
        if ((expiredNot = not.getExpiredNot()) instanceof ClientMessages) {
            this.nbMsgsDeliverSinceCreation -= (long)((ClientMessages)expiredNot).getMessageCount();
            try {
                this.addClientMessages((ClientMessages)expiredNot, false);
            }
            catch (AccessException e) {
                // empty catch block
            }
            ClientMessages cm = new ClientMessages();
            cm.setDeadNotificationAgentId(this.getId());
            Iterator ite = this.messages.iterator();
            while (ite.hasNext()) {
                Message msg = (Message)ite.next();
                cm.addMessage(msg.getFullMessage());
                ite.remove();
                msg.delete();
            }
            this.sendNot(cm);
            this.nbMsgsDeliverSinceCreation += (long)cm.getMessageCount();
        } else {
            super.handleExpiredNot(from, not);
        }
    }

    protected void doUnknownAgent(UnknownAgent uA) {
        if (uA.not instanceof ClientMessages) {
            logger.log(BasicLevel.ERROR, (Object)"Remote agent refers to an unknown agent.");
            this.nbMsgsDeliverSinceCreation -= (long)((ClientMessages)uA.not).getMessageCount();
            try {
                this.addClientMessages((ClientMessages)uA.not, false);
            }
            catch (AccessException accessException) {}
        } else if (uA.not instanceof PingNot) {
            logger.log(BasicLevel.ERROR, (Object)"Unknown agent. 'remoteAgentID' property refers to an unknown agent.");
        } else {
            super.doUnknownAgent(uA);
        }
    }

    public String toString() {
        return "AliasInQueue:" + this.getId().toString();
    }

    protected void processSetRight(AgentId user, int right) throws RequestException {
        if (right == READ) {
            throw new RequestException("An alias queue can't be set readable.");
        }
        super.processSetRight(user, right);
    }

    public void handleAdminRequestNot(AgentId from, FwdAdminRequestNot not) {
        AdminRequest adminRequest = not.getRequest();
        if (adminRequest instanceof AddRemoteDestination) {
            this.setSave();
            AgentId dest = AgentId.fromString((String)((AddRemoteDestination)adminRequest).getNewId());
            if (!this.destinations.contains(dest)) {
                this.destinations.add(dest);
                this.metrics.add(new Long(0L));
                long newWeight = Long.MIN_VALUE;
                for (long w : this.weights) {
                    if (w <= newWeight) continue;
                    newWeight = w;
                }
                this.weights.add(newWeight);
            }
            this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof DelRemoteDestination) {
            if (this.destinations.size() > 1) {
                this.setSave();
                AgentId dest = AgentId.fromString((String)((DelRemoteDestination)adminRequest).getNewId());
                int index = this.destinations.indexOf(dest);
                if (index != -1) {
                    this.destinations.remove(index);
                    this.metrics.remove(index);
                    this.weights.remove(index);
                    if (this.currentDestination > index) {
                        --this.currentDestination;
                    } else if (this.currentDestination == this.destinations.size()) {
                        this.currentDestination = 0;
                    }
                }
                this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
            } else {
                this.replyToTopic(new AdminReply(9, "Can't remove last destination"), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
            }
        } else if (adminRequest instanceof SendDestinationsWeights) {
            this.setSave();
            int[] newWeights = ((SendDestinationsWeights)adminRequest).getWeights();
            String weightStr = "";
            for (int i = 0; i < newWeights.length; ++i) {
                weightStr = weightStr + " " + newWeights[i];
                this.weights.set(i, Long.valueOf(newWeights[i]));
            }
            logger.log(BasicLevel.ERROR, (Object)("Received weights:" + weightStr));
            this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else {
            super.handleAdminRequestNot(from, not);
        }
    }

    private void sendNot(Notification not) {
        Channel.sendTo((AgentId)this.destinations.get(this.currentDestination), (Notification)not);
        if (--this.weightLeft <= 0L) {
            this.currentDestination = (this.currentDestination + 1) % this.destinations.size();
            this.weightLeft = this.weights.get(this.currentDestination);
        }
    }

    public void wakeUpNot(WakeUpNot not) {
        for (AgentId id : this.destinations) {
            Channel.sendTo((AgentId)id, (Notification)new PingNot());
        }
    }

    protected void handlePongNot(AgentId from, PongNot not) {
        int dest = this.destinations.indexOf(from);
        this.oldmetrics.set(dest, this.newmetrics.get(dest));
        Long x1 = (Long)not.get("NbMsgsDeliverSinceCreation");
        if (x1 != null) {
            this.newmetrics.set(dest, (long)x1);
        }
        this.metrics.set(dest, this.newmetrics.get(dest) - this.oldmetrics.get(dest));
        Long x2 = (Long)not.get("PendingMessageCount");
        long pending = 0L;
        if (x2 != null) {
            pending = x2;
        }
        logger.log(BasicLevel.ERROR, (Object)("Pending: " + pending + " from: " + dest));
        if (pending > pendingMessagesThreshold) {
            this.metrics.set(dest, this.metrics.get(dest) * 80L / 100L);
            logger.log(BasicLevel.ERROR, (Object)("Metric got altered for: " + dest));
        }
        logger.log(BasicLevel.ERROR, (Object)("Received: " + this.metrics.get(dest) + " from: " + dest));
        if (this.metrics.get(dest) < this.minMetrics) {
            this.minMetrics = this.metrics.get(dest);
        }
        if (++this.receivedMetrics == this.destinations.size()) {
            if (this.minMetrics <= 0L) {
                this.minMetrics = 1L;
            }
            int base = (int)Math.pow(10.0, Math.floor(Math.log10(this.minMetrics)));
            logger.log(BasicLevel.ERROR, (Object)("Base: " + base));
            ArrayList<Long> newWeights = new ArrayList<Long>();
            for (int i = 0; i < this.receivedMetrics; ++i) {
                long weight = Math.round((double)this.metrics.get(i).longValue() / (double)base);
                if (weight <= 0L) {
                    weight = 1L;
                }
                newWeights.add(weight);
                logger.log(BasicLevel.ERROR, (Object)("Computed: " + newWeights.get(i) + " for: " + i));
            }
            this.weights = newWeights;
            this.weightLeft = this.weights.get(this.currentDestination);
            this.receivedMetrics = 0;
            this.minMetrics = Long.MAX_VALUE;
        }
    }
}

