/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.Expression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;
import javax.faces.view.Location;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlResponseWriterImpl;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.shared_impl.util.StateUtils;
import org.apache.myfaces.spi.WebConfigProvider;
import org.apache.myfaces.spi.WebConfigProviderFactory;
import org.apache.myfaces.view.facelets.component.UIRepeat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ErrorPageWriter {
    public static final String ERROR_PAGE_BEAN_KEY = "__myFacesErrorPageBean";
    private static final String EXCEPTION_KEY = "javax.servlet.error.exception";
    private static final String VIEW_KEY = "org.apache.myfaces.error.UIViewRoot";
    private static final Logger log = Logger.getLogger(ErrorPageWriter.class.getName());
    private static final String TS = "&lt;";
    private static final String ERROR_TEMPLATE = "META-INF/rsc/myfaces-dev-error.xml";
    private static final String ERROR_TEMPLATE_RESOURCE = "org.apache.myfaces.ERROR_TEMPLATE_RESOURCE";
    private static String[] ERROR_PARTS;
    private static final String DEBUG_TEMPLATE = "META-INF/rsc/myfaces-dev-debug.xml";
    private static final String DEBUG_TEMPLATE_RESOURCE = "org.apache.myfaces.DEBUG_TEMPLATE_RESOURCE";
    private static String[] DEBUG_PARTS;
    private static final String REGEX_PATTERN = ".*?\\Q,Id:\\E\\s*(\\S+)\\s*\\].*?";
    private static final String[] IGNORE;
    public static final String DEBUG_INFO_KEY = "org.apache.myfaces.debug.DEBUG_INFO";
    private static final Map<UIComponent, Integer> visitedFacetCount;
    public static final String ERROR_HANDLING_PARAMETER = "org.apache.myfaces.ERROR_HANDLING";

    public static void debugHtml(Writer writer, FacesContext faces, Throwable e) throws IOException {
        ErrorPageWriter.debugHtml(writer, faces, e, faces.getViewRoot());
    }

    private static void debugHtml(Writer writer, FacesContext faces, Throwable e, UIViewRoot view) throws IOException {
        ErrorPageWriter._init(faces);
        Date now = new Date();
        for (int i = 0; i < ERROR_PARTS.length; ++i) {
            if ("message".equals(ERROR_PARTS[i])) {
                String msg = e.getMessage();
                if (msg != null) {
                    writer.write(msg.replaceAll("<", TS));
                    continue;
                }
                writer.write(e.getClass().getName());
                continue;
            }
            if ("trace".equals(ERROR_PARTS[i])) {
                ErrorPageWriter._writeException(writer, e);
                continue;
            }
            if ("now".equals(ERROR_PARTS[i])) {
                writer.write(DateFormat.getDateTimeInstance().format(now));
                continue;
            }
            if ("tree".equals(ERROR_PARTS[i])) {
                if (view == null) continue;
                ErrorPageWriter._writeComponent(faces, writer, (UIComponent)view, ErrorPageWriter._getErrorId(e));
                continue;
            }
            if ("vars".equals(ERROR_PARTS[i])) {
                ErrorPageWriter._writeVariables(writer, faces, view);
                continue;
            }
            if ("cause".equals(ERROR_PARTS[i])) {
                ErrorPageWriter._writeCause(writer, e);
                continue;
            }
            writer.write(ERROR_PARTS[i]);
        }
    }

    public static void debugHtml(Writer writer, FacesContext faces) throws IOException {
        ErrorPageWriter._init(faces);
        Date now = new Date();
        for (int i = 0; i < DEBUG_PARTS.length; ++i) {
            if ("message".equals(DEBUG_PARTS[i])) {
                writer.write(faces.getViewRoot().getViewId());
                continue;
            }
            if ("now".equals(DEBUG_PARTS[i])) {
                writer.write(DateFormat.getDateTimeInstance().format(now));
                continue;
            }
            if ("tree".equals(DEBUG_PARTS[i])) {
                ErrorPageWriter._writeComponent(faces, writer, (UIComponent)faces.getViewRoot(), null);
                continue;
            }
            if ("extendedtree".equals(DEBUG_PARTS[i])) {
                ErrorPageWriter._writeExtendedComponentTree(writer, faces);
                continue;
            }
            if ("vars".equals(DEBUG_PARTS[i])) {
                ErrorPageWriter._writeVariables(writer, faces, faces.getViewRoot());
                continue;
            }
            writer.write(DEBUG_PARTS[i]);
        }
    }

    public static void handleThrowable(FacesContext facesContext, Throwable ex) throws FacesException {
        ErrorPageWriter._prepareExceptionStack(ex);
        boolean errorPageWritten = false;
        WebConfigProvider webConfigProvider = WebConfigProviderFactory.getWebConfigProviderFactory(facesContext.getExternalContext()).getWebConfigProvider(facesContext.getExternalContext());
        if (webConfigProvider.isErrorPagePresent(facesContext.getExternalContext())) {
            facesContext.getExternalContext().getRequestMap().put(VIEW_KEY, facesContext.getViewRoot());
        } else {
            HttpServletResponse httpResp;
            Object response;
            boolean errorHandlingDisabled;
            String errorHandling = facesContext.getExternalContext().getInitParameter(ERROR_HANDLING_PARAMETER);
            boolean bl = errorHandlingDisabled = errorHandling != null && errorHandling.equalsIgnoreCase("false");
            if (!errorHandlingDisabled && (response = facesContext.getExternalContext().getResponse()) instanceof HttpServletResponse && !(httpResp = (HttpServletResponse)response).isCommitted()) {
                httpResp.reset();
                if (facesContext.getPartialViewContext().isAjaxRequest()) {
                    httpResp.setContentType("text/xml; charset=UTF-8");
                    try {
                        PrintWriter writer = httpResp.getWriter();
                        HtmlResponseWriterImpl responseWriter = new HtmlResponseWriterImpl(writer, "text/xml", "utf-8");
                        PartialResponseWriter partialWriter = new PartialResponseWriter((ResponseWriter)responseWriter);
                        partialWriter.startDocument();
                        partialWriter.startError(ex.getClass().getName());
                        if (ex.getCause() != null) {
                            partialWriter.write(ex.getCause().toString());
                        } else if (ex.getMessage() != null) {
                            partialWriter.write(ex.getMessage());
                        }
                        partialWriter.endError();
                        partialWriter.endDocument();
                    }
                    catch (IOException ioe) {
                        throw new FacesException("Could not write the error page", (Throwable)ioe);
                    }
                }
                httpResp.setContentType("text/html; charset=UTF-8");
                try {
                    PrintWriter writer = httpResp.getWriter();
                    ErrorPageWriter.debugHtml(writer, facesContext, ex);
                }
                catch (IOException ioe) {
                    throw new FacesException("Could not write the error page", (Throwable)ioe);
                }
                log.log(Level.SEVERE, "An exception occurred", ex);
                facesContext.responseComplete();
                errorPageWritten = true;
            }
        }
        if (!errorPageWritten) {
            if (ex instanceof FacesException) {
                throw (FacesException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new FacesException(ex);
        }
    }

    private static String _getErrorTemplate(FacesContext context) {
        String errorTemplate = context.getExternalContext().getInitParameter(ERROR_TEMPLATE_RESOURCE);
        if (errorTemplate != null) {
            return errorTemplate;
        }
        return ERROR_TEMPLATE;
    }

    private static String _getDebugTemplate(FacesContext context) {
        String debugTemplate = context.getExternalContext().getInitParameter(DEBUG_TEMPLATE_RESOURCE);
        if (debugTemplate != null) {
            return debugTemplate;
        }
        return DEBUG_TEMPLATE;
    }

    private static void _init(FacesContext context) throws IOException {
        if (ERROR_PARTS == null) {
            ERROR_PARTS = ErrorPageWriter._splitTemplate(ErrorPageWriter._getErrorTemplate(context));
        }
        if (DEBUG_PARTS == null) {
            DEBUG_PARTS = ErrorPageWriter._splitTemplate(ErrorPageWriter._getDebugTemplate(context));
        }
    }

    private static String[] _splitTemplate(String rsc) throws IOException {
        int read;
        InputStream is = ClassUtils.getContextClassLoader().getResourceAsStream(rsc);
        if (is == null && (is = FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream(rsc)) == null) {
            is = ErrorPageWriter.class.getClassLoader().getResourceAsStream(rsc);
        }
        if (is == null) {
            throw new IllegalArgumentException("Could not find resource " + rsc);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[512];
        while ((read = is.read(buff)) != -1) {
            baos.write(buff, 0, read);
        }
        String str = baos.toString();
        return str.split("@@");
    }

    private static List<String> _getErrorId(Throwable e) {
        String message = e.getMessage();
        if (message == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile(REGEX_PATTERN);
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    private static void _writeException(Writer writer, Throwable e) throws IOException {
        StringWriter str = new StringWriter(256);
        PrintWriter pstr = new PrintWriter(str);
        e.printStackTrace(pstr);
        pstr.close();
        writer.write(str.toString().replaceAll("<", TS));
    }

    private static void _writeCause(Writer writer, Throwable ex) throws IOException {
        String msg = ex.getMessage();
        while (ex.getCause() != null) {
            if ((ex = ex.getCause()).getMessage() == null) continue;
            msg = ex.getMessage();
        }
        if (msg != null) {
            msg = ex.getClass().getName() + " - " + msg;
            writer.write(msg.replaceAll("<", TS));
        } else {
            writer.write(ex.getClass().getName());
        }
    }

    private static void _writeVariables(Writer writer, FacesContext faces, UIViewRoot view) throws IOException {
        ExternalContext ctx = faces.getExternalContext();
        ErrorPageWriter._writeVariables(writer, ctx.getRequestParameterMap(), "Request Parameters");
        ErrorPageWriter._writeVariables(writer, ctx.getRequestMap(), "Request Attributes");
        if (view != null) {
            ErrorPageWriter._writeVariables(writer, view.getViewMap(), "View Attributes");
        }
        if (ctx.getSession(false) != null) {
            ErrorPageWriter._writeVariables(writer, ctx.getSessionMap(), "Session Attributes");
        }
        ErrorPageWriter._writeVariables(writer, (Map<String, ? extends Object>)ctx.getFlash(), "Flash Attributes");
        ErrorPageWriter._writeVariables(writer, ctx.getApplicationMap(), "Application Attributes");
    }

    private static void _writeVariables(Writer writer, Map<String, ? extends Object> vars, String caption) throws IOException {
        writer.write("<table><caption>");
        writer.write(caption);
        writer.write("</caption><thead><tr><th style=\"width: 10%; \">Name</th><th style=\"width: 90%; \">Value</th></tr></thead><tbody>");
        boolean written = false;
        if (!vars.isEmpty()) {
            TreeMap<String, ? extends Object> sortedMap = new TreeMap<String, Object>(vars);
            for (Map.Entry entry : sortedMap.entrySet()) {
                String key = ((String)entry.getKey()).toString();
                if (key.indexOf(46) != -1) continue;
                writer.write("<tr><td>");
                writer.write(key.replaceAll("<", TS));
                writer.write("</td><td>");
                writer.write(entry.getValue().toString().replaceAll("<", TS));
                writer.write("</td></tr>");
                written = true;
            }
        }
        if (!written) {
            writer.write("<tr><td colspan=\"2\"><em>None</em></td></tr>");
        }
        writer.write("</tbody></table>");
    }

    private static void _writeComponent(FacesContext faces, Writer writer, UIComponent c, List<String> highlightId) throws IOException {
        int stateSize;
        boolean hasChildren;
        block11: {
            writer.write("<dl><dt");
            if (ErrorPageWriter._isText(c)) {
                writer.write(" class=\"uicText\"");
            }
            if (highlightId != null && highlightId.size() > 0 && highlightId.get(0).equals(c.getId())) {
                highlightId.remove(0);
                if (highlightId.size() == 0) {
                    writer.write(" class=\"highlightComponent\"");
                }
            }
            writer.write(">");
            hasChildren = c.getChildCount() > 0 || c.getFacets().size() > 0;
            stateSize = 0;
            Object state = c.saveState(faces);
            if (state != null) {
                try {
                    byte[] stateBytes = StateUtils.getAsByteArray(state, faces.getExternalContext());
                    stateSize = stateBytes.length;
                }
                catch (Exception e) {
                    stateSize = -1;
                    if (!log.isLoggable(Level.FINEST)) break block11;
                    log.fine("Could not determine state size: " + e.getMessage());
                }
            }
        }
        ErrorPageWriter._writeStart(writer, c, hasChildren, true);
        writer.write(" - State size:" + stateSize + " bytes");
        writer.write("</dt>");
        if (hasChildren) {
            if (c.getFacets().size() > 0) {
                for (Map.Entry entry : c.getFacets().entrySet()) {
                    writer.write("<dd class=\"uicFacet\">");
                    writer.write("<span>");
                    writer.write((String)entry.getKey());
                    writer.write("</span>");
                    ErrorPageWriter._writeComponent(faces, writer, (UIComponent)entry.getValue(), highlightId);
                    writer.write("</dd>");
                }
            }
            if (c.getChildCount() > 0) {
                for (UIComponent child : c.getChildren()) {
                    writer.write("<dd>");
                    ErrorPageWriter._writeComponent(faces, writer, child, highlightId);
                    writer.write("</dd>");
                }
            }
            writer.write("<dt>");
            ErrorPageWriter._writeEnd(writer, c);
            writer.write("</dt>");
        }
        writer.write("</dl>");
    }

    private static void _writeExtendedComponentTree(Writer writer, FacesContext facesContext) throws IOException {
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, EnumSet.of(VisitHint.SKIP_UNRENDERED));
        facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)new ExtendedComponentTreeVisitCallback(writer));
    }

    private static boolean _isFirstUIColumn(UIComponent uidata, UIColumn uicolumn) {
        for (UIComponent child : uidata.getChildren()) {
            if (!(child instanceof UIColumn)) continue;
            return child == uicolumn;
        }
        return false;
    }

    private static String _getFacetName(UIComponent component) {
        UIComponent parent = component.getParent();
        if (parent != null) {
            for (Map.Entry entry : parent.getFacets().entrySet()) {
                if (entry.getValue() != component) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    private static int _getVisitedFacetCount(UIComponent component) {
        Integer count = visitedFacetCount.get(component);
        if (count != null) {
            return count;
        }
        return 0;
    }

    private static void _incrementVisitedFacetCount(UIComponent component) {
        visitedFacetCount.put(component, ErrorPageWriter._getVisitedFacetCount(component) + 1);
    }

    private static void _removeVisitedFacetCount(UIComponent component) {
        visitedFacetCount.remove(component);
    }

    private static void _writeEnd(Writer writer, UIComponent c) throws IOException {
        if (!ErrorPageWriter._isText(c)) {
            writer.write(TS);
            writer.write(47);
            writer.write(ErrorPageWriter._getName(c));
            writer.write(62);
        }
    }

    private static void _writeAttributes(Writer writer, UIComponent c, boolean valueExpressionValues) {
        try {
            String location;
            BeanInfo info = Introspector.getBeanInfo(c.getClass());
            PropertyDescriptor[] pd = info.getPropertyDescriptors();
            Method m = null;
            Object v = null;
            ValueExpression valueExpression = null;
            String str = null;
            for (int i = 0; i < pd.length; ++i) {
                if (pd[i].getWriteMethod() == null || Arrays.binarySearch(IGNORE, pd[i].getName()) >= 0) continue;
                m = pd[i].getReadMethod();
                try {
                    valueExpression = c.getValueExpression(pd[i].getName());
                    if (valueExpressionValues && valueExpression != null) {
                        ErrorPageWriter._writeAttribute(writer, pd[i].getName(), valueExpression.getExpressionString());
                        continue;
                    }
                    v = m.invoke((Object)c, null);
                    if (v == null || v instanceof Collection || v instanceof Map || v instanceof Iterator) continue;
                    str = v instanceof Expression ? ((Expression)v).getExpressionString() : (v instanceof ValueBinding ? ((ValueBinding)v).getExpressionString() : (v instanceof MethodBinding ? ((MethodBinding)v).getExpressionString() : v.toString()));
                    ErrorPageWriter._writeAttribute(writer, pd[i].getName(), str);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ValueExpression binding = c.getValueExpression("binding");
            if (binding != null) {
                ErrorPageWriter._writeAttribute(writer, "binding", binding.getExpressionString());
            }
            if ((location = ErrorPageWriter._getComponentLocation(c)) != null) {
                ErrorPageWriter._writeAttribute(writer, "location", location);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void _writeAttribute(Writer writer, String name, String value) throws IOException {
        writer.write(" ");
        writer.write(name);
        writer.write("=\"");
        writer.write(value.replaceAll("<", TS));
        writer.write("\"");
    }

    private static void _writeStart(Writer writer, UIComponent c, boolean children, boolean valueExpressionValues) throws IOException {
        if (ErrorPageWriter._isText(c)) {
            String str = c.toString().trim();
            writer.write(str.replaceAll("<", TS));
        } else {
            writer.write(TS);
            writer.write(ErrorPageWriter._getName(c));
            ErrorPageWriter._writeAttributes(writer, c, valueExpressionValues);
            if (children) {
                writer.write(62);
            } else {
                writer.write("/>");
            }
        }
    }

    private static String _getName(UIComponent c) {
        String nm = c.getClass().getName();
        return nm.substring(nm.lastIndexOf(46) + 1);
    }

    private static boolean _isText(UIComponent c) {
        return c.getClass().getName().startsWith("org.apache.myfaces.view.facelets.compiler");
    }

    private static void _prepareExceptionStack(Throwable ex) {
        if (ex == null) {
            return;
        }
        if (!ErrorPageWriter._initCausePerReflection(ex, "getRootCause")) {
            ErrorPageWriter._initCausePerReflection(ex, "getCause");
        }
        ErrorPageWriter._prepareExceptionStack(ex.getCause());
    }

    private static boolean _initCausePerReflection(Throwable ex, String methodName) {
        try {
            Method causeGetter = ex.getClass().getMethod(methodName, null);
            Throwable rootCause = (Throwable)causeGetter.invoke((Object)ex, (Object[])null);
            return ErrorPageWriter._initCauseIfAvailable(ex, rootCause);
        }
        catch (Exception e1) {
            return false;
        }
    }

    private static boolean _initCauseIfAvailable(Throwable th, Throwable cause) {
        if (cause == null) {
            return false;
        }
        try {
            Method m = Throwable.class.getMethod("initCause", Throwable.class);
            m.invoke((Object)th, cause);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String _getComponentLocation(UIComponent component) {
        Location location = (Location)component.getAttributes().get("javax.faces.component.VIEW_LOCATION_KEY");
        if (location != null) {
            return location.toString();
        }
        return null;
    }

    static {
        IGNORE = new String[]{"parent", "rendererType"};
        visitedFacetCount = new HashMap<UIComponent, Integer>();
    }

    private static class ExtendedComponentTreeVisitCallback
    implements VisitCallback {
        private Writer _writer;

        public ExtendedComponentTreeVisitCallback(Writer writer) {
            this._writer = writer;
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            block23: {
                Map requestMap = context.getFacesContext().getExternalContext().getRequestMap();
                try {
                    if (!(target instanceof UIViewRoot)) {
                        this._writer.write("<dd>");
                    }
                    UIComponent parent = target.getParent();
                    boolean hasChildren = target.getChildCount() > 0 || target.getFacets().size() > 0;
                    String facetName = ErrorPageWriter._getFacetName(target);
                    if (!(target instanceof UIColumn)) {
                        if (parent instanceof UIColumn && (parent.getChildCount() > 0 && parent.getChildren().get(0) == target || facetName != null && ErrorPageWriter._getVisitedFacetCount(parent) == 0)) {
                            if (parent.getParent() instanceof UIData && ErrorPageWriter._isFirstUIColumn(parent.getParent(), (UIColumn)parent)) {
                                this._writer.write("<span>Row: ");
                                int rowIndex = ((UIData)parent.getParent()).getRowIndex();
                                this._writer.write("" + rowIndex);
                                if (rowIndex == -1) {
                                    this._writer.write(" (all column facets)");
                                }
                                this._writer.write("</span>");
                            }
                            this._writer.write("<dl><dt>");
                            ErrorPageWriter._writeStart(this._writer, parent, true, false);
                            this._writer.write("</dt><dd>");
                        }
                        if (facetName != null) {
                            this._writer.write("<span>" + facetName + "</span>");
                            ErrorPageWriter._incrementVisitedFacetCount(parent);
                        }
                        this._writer.write("<dl><dt");
                        if (ErrorPageWriter._isText(target)) {
                            this._writer.write(" class=\"uicText\"");
                        }
                        this._writer.write(">");
                        Map debugInfos = null;
                        if (target instanceof EditableValueHolder) {
                            debugInfos = (Map)requestMap.get(ErrorPageWriter.DEBUG_INFO_KEY + target.getClientId());
                        }
                        Renderer renderer = null;
                        try {
                            Method getRenderer = UIComponent.class.getDeclaredMethod("getRenderer", FacesContext.class);
                            getRenderer.setAccessible(true);
                            renderer = (Renderer)getRenderer.invoke((Object)target, context.getFacesContext());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        ErrorPageWriter._writeStart(this._writer, target, hasChildren || debugInfos != null || renderer != null, false);
                        this._writer.write("</dt>");
                        if (renderer != null) {
                            this._writer.write("<div class=\"renderer\">Rendered by ");
                            this._writer.write(renderer.getClass().getCanonicalName());
                            this._writer.write("</div>");
                            if (!hasChildren && debugInfos == null) {
                                this._writer.write("<dt>");
                                ErrorPageWriter._writeEnd(this._writer, target);
                                this._writer.write("</dt>");
                            }
                        }
                        if (debugInfos != null) {
                            String fieldid = target.getClientId() + "_lifecycle";
                            this._writer.write("<div class=\"lifecycle_values_wrapper\">");
                            this._writer.write("<a href=\"#\" onclick=\"toggle('");
                            this._writer.write(fieldid);
                            this._writer.write("'); return false;\"><span id=\"");
                            this._writer.write(fieldid);
                            this._writer.write("Off\">+</span><span id=\"");
                            this._writer.write(fieldid);
                            this._writer.write("On\" style=\"display: none;\">-</span> Value Lifecycle</a>");
                            this._writer.write("<div id=\"");
                            this._writer.write(fieldid);
                            this._writer.write("\" class=\"lifecycle_values\">");
                            for (Map.Entry entry : debugInfos.entrySet()) {
                                this._writer.write("<span>");
                                this._writer.write((String)entry.getKey());
                                this._writer.write("</span><ol>");
                                int i = 0;
                                for (Object[] debugInfo : (List)entry.getValue()) {
                                    String oldValue = debugInfo[1] == null ? "null" : debugInfo[1].toString();
                                    String newValue = debugInfo[2] == null ? "null" : debugInfo[2].toString();
                                    this._writer.write("<li><b>");
                                    this._writer.write((String)entry.getKey());
                                    this._writer.write("</b> set from <b>");
                                    this._writer.write(oldValue);
                                    this._writer.write("</b> to <b>");
                                    this._writer.write(newValue);
                                    this._writer.write("</b> in Phase ");
                                    this._writer.write(debugInfo[0].toString());
                                    if (debugInfo[3] != null) {
                                        String stackTraceId = fieldid + "_" + (String)entry.getKey() + "_" + i;
                                        this._writer.write("<div class=\"stacktrace_wrapper\">");
                                        this._writer.write("<a href=\"#\" onclick=\"toggle('");
                                        this._writer.write(stackTraceId);
                                        this._writer.write("'); return false;\"><span id=\"");
                                        this._writer.write(stackTraceId);
                                        this._writer.write("Off\">+</span><span id=\"");
                                        this._writer.write(stackTraceId);
                                        this._writer.write("On\" style=\"display: none;\">-</span> Call Stack</a>");
                                        this._writer.write("<div id=\"");
                                        this._writer.write(stackTraceId);
                                        this._writer.write("\" class=\"stacktrace_values\">");
                                        this._writer.write("<ul>");
                                        for (StackTraceElement stackTraceElement : (List)debugInfo[3]) {
                                            this._writer.write("<li>");
                                            this._writer.write(stackTraceElement.toString());
                                            this._writer.write("</li>");
                                        }
                                        this._writer.write("</ul></div></div>");
                                    }
                                    this._writer.write("</li>");
                                    ++i;
                                }
                                this._writer.write("</ol>");
                            }
                            this._writer.write("</div></div>");
                            requestMap.remove(ErrorPageWriter.DEBUG_INFO_KEY + target.getClientId());
                            if (!hasChildren) {
                                this._writer.write("<dt>");
                                ErrorPageWriter._writeEnd(this._writer, target);
                                this._writer.write("</dt>");
                            }
                        }
                    }
                    if (hasChildren) break block23;
                    this._writer.write("</dl>");
                    while (parent != null && (parent.getChildCount() > 0 && parent.getChildren().get(parent.getChildCount() - 1) == target || parent.getFacetCount() != 0 && ErrorPageWriter._getVisitedFacetCount(parent) == parent.getFacetCount())) {
                        UIRepeat uirepeat;
                        UIData uidata;
                        ErrorPageWriter._removeVisitedFacetCount(parent);
                        if (!(parent instanceof UIData ? (uidata = (UIData)parent).getRowIndex() != uidata.getRowCount() - 1 : parent instanceof UIRepeat && (uirepeat = (UIRepeat)parent).getIndex() + uirepeat.getStep() < uirepeat.getRowCount())) {
                            this._writer.write("</dd><dt>");
                            ErrorPageWriter._writeEnd(this._writer, parent);
                            this._writer.write("</dt></dl>");
                            if (!(parent instanceof UIViewRoot)) {
                                this._writer.write("</dd>");
                            }
                            target = parent;
                            parent = target.getParent();
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    throw new FacesException((Throwable)ioe);
                }
            }
            return VisitResult.ACCEPT;
        }
    }

    public static class ErrorPageBean
    implements Serializable {
        private static final long serialVersionUID = -79513324193326616L;

        public String getErrorPageHtml() throws IOException {
            String head;
            String body;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            Throwable t = (Throwable)requestMap.get(ErrorPageWriter.EXCEPTION_KEY);
            if (t == null) {
                throw new IllegalStateException("No Exception to handle");
            }
            UIViewRoot view = (UIViewRoot)requestMap.get(ErrorPageWriter.VIEW_KEY);
            StringWriter writer = new StringWriter();
            ErrorPageWriter.debugHtml(writer, facesContext, t, view);
            String html = writer.toString();
            try {
                body = html.substring(html.indexOf("<body>") + "<body>".length(), html.indexOf("</body>"));
            }
            catch (Exception e) {
                return html;
            }
            try {
                head = html.substring(html.indexOf("<head>") + "<head>".length(), html.indexOf("</head>"));
            }
            catch (Exception e) {
                return body;
            }
            StringBuilder builder = new StringBuilder(body);
            int startIndex = 0;
            try {
                while (true) {
                    int endIndex = head.indexOf("</style>", startIndex) + "</style>".length();
                    builder.append(head.substring(head.indexOf("<style", startIndex), endIndex));
                    startIndex = endIndex;
                }
            }
            catch (Exception e) {
                startIndex = 0;
                try {
                    while (true) {
                        int endIndex = head.indexOf("</script>", startIndex) + "</script>".length();
                        builder.append(head.substring(head.indexOf("<script", startIndex), endIndex));
                        startIndex = endIndex;
                    }
                }
                catch (Exception e2) {
                    return builder.toString();
                }
            }
        }
    }
}

