/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class TrimFilter
extends TokenFilter {
    final boolean updateOffsets;

    public TrimFilter(TokenStream in, boolean updateOffsets) {
        super(in);
        this.updateOffsets = updateOffsets;
    }

    public final Token next() throws IOException {
        Token t = this.input.next();
        if (null == t || null == t.termText()) {
            return t;
        }
        if (this.updateOffsets) {
            int start;
            String txt = t.termText();
            int end = txt.length();
            int endOff = 0;
            for (start = 0; start < end && txt.charAt(start) <= ' '; ++start) {
            }
            while (start < end && txt.charAt(end - 1) <= ' ') {
                --end;
                ++endOff;
            }
            if (start > 0 || end < txt.length()) {
                int incr = t.getPositionIncrement();
                t = new Token(t.termText().substring(start, end), t.startOffset() + start, t.endOffset() - endOff, t.type());
                t.setPositionIncrement(incr);
            }
        } else {
            t.setTermText(t.termText().trim());
        }
        return t;
    }
}

