/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.store.Directory;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.reader.CacheableMultiReader;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.ReaderProviderHelper;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class SharingBufferReaderProvider
implements ReaderProvider {
    private static final Logger log = LoggerFactory.make();
    protected final Map<IndexReader, ReaderUsagePair> allReaders = new ConcurrentHashMap<IndexReader, ReaderUsagePair>();
    protected final Map<Directory, PerDirectoryLatestReader> currentReaders = new ConcurrentHashMap<Directory, PerDirectoryLatestReader>();

    public void closeReader(IndexReader multiReader) {
        if (multiReader == null) {
            return;
        }
        if (!(multiReader instanceof MultiReader)) {
            throw new AssertionFailure("Everything should be wrapped in a MultiReader");
        }
        IndexReader[] readers = ReaderProviderHelper.getSubReadersFromMultiReader((MultiReader)multiReader);
        log.debug("Closing MultiReader: {}", (Object)multiReader);
        for (IndexReader reader : readers) {
            ReaderUsagePair container = this.allReaders.get(reader);
            container.close();
        }
        log.trace("IndexReader closed.");
    }

    public void initialize(Properties props, BuildContext context) {
        Set<DirectoryProvider<?>> providers = context.getDirectoryProviders();
        for (DirectoryProvider<?> provider : providers) {
            this.createReader((Directory)provider.getDirectory());
        }
    }

    private synchronized PerDirectoryLatestReader createReader(Directory directory) {
        PerDirectoryLatestReader reader = this.currentReaders.get(directory);
        if (reader != null) {
            return reader;
        }
        try {
            reader = new PerDirectoryLatestReader(directory);
            this.currentReaders.put(directory, reader);
            return reader;
        }
        catch (IOException e) {
            throw new SearchException("Unable to open Lucene IndexReader", e);
        }
    }

    public void destroy() {
        IndexReader[] readers;
        for (IndexReader reader : readers = this.allReaders.keySet().toArray(new IndexReader[this.allReaders.size()])) {
            ReaderUsagePair usage = this.allReaders.get(reader);
            usage.close();
        }
        if (this.allReaders.size() != 0) {
            log.warn("ReaderProvider contains readers not properly closed at destroy time");
        }
    }

    public IndexReader openReader(DirectoryProvider ... directoryProviders) {
        int length = directoryProviders.length;
        IndexReader[] readers = new IndexReader[length];
        log.debug("Opening IndexReader for directoryProviders: {}", (Object)length);
        for (int index = 0; index < length; ++index) {
            Object directory = directoryProviders[index].getDirectory();
            log.trace("Opening IndexReader from {}", directory);
            PerDirectoryLatestReader directoryLatestReader = this.currentReaders.get(directory);
            if (directoryLatestReader == null) {
                directoryLatestReader = this.createReader((Directory)directory);
            }
            readers[index] = directoryLatestReader.refreshAndGet();
        }
        if (length == 0) {
            return null;
        }
        try {
            return new CacheableMultiReader(readers);
        }
        catch (Exception e) {
            for (IndexReader ir : readers) {
                ReaderUsagePair readerUsagePair = this.allReaders.get(ir);
                readerUsagePair.close();
            }
            throw new SearchException("Unable to open a MultiReader", e);
        }
    }

    protected IndexReader readerFactory(Directory directory) throws IOException {
        return IndexReader.open(directory, true);
    }

    protected final class PerDirectoryLatestReader {
        public ReaderUsagePair current;
        private final Lock lockOnReplaceCurrent = new ReentrantLock();

        public PerDirectoryLatestReader(Directory directory) throws IOException {
            IndexReader reader = SharingBufferReaderProvider.this.readerFactory(directory);
            ReaderUsagePair initialPair = new ReaderUsagePair(reader);
            initialPair.usageCounter.set(1);
            this.lockOnReplaceCurrent.lock();
            this.current = initialPair;
            this.lockOnReplaceCurrent.unlock();
            SharingBufferReaderProvider.this.allReaders.put(reader, initialPair);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexReader refreshAndGet() {
            ReaderUsagePair previousCurrent;
            IndexReader updatedReader;
            this.lockOnReplaceCurrent.lock();
            try {
                IndexReader beforeUpdateReader = this.current.reader;
                try {
                    updatedReader = beforeUpdateReader.reopen();
                }
                catch (IOException e) {
                    throw new SearchException("Unable to reopen IndexReader", e);
                }
                if (beforeUpdateReader == updatedReader) {
                    previousCurrent = null;
                    this.current.usageCounter.incrementAndGet();
                } else {
                    ReaderUsagePair newPair = new ReaderUsagePair(updatedReader);
                    assert (newPair.usageCounter.get() == 2);
                    previousCurrent = this.current;
                    this.current = newPair;
                    SharingBufferReaderProvider.this.allReaders.put(updatedReader, newPair);
                }
            }
            finally {
                this.lockOnReplaceCurrent.unlock();
            }
            if (previousCurrent != null) {
                previousCurrent.close();
            }
            return updatedReader;
        }
    }

    protected final class ReaderUsagePair {
        public final IndexReader reader;
        protected final AtomicInteger usageCounter = new AtomicInteger(2);

        ReaderUsagePair(IndexReader r) {
            this.reader = r;
        }

        public void close() {
            int refCount = this.usageCounter.decrementAndGet();
            if (refCount == 0) {
                ReaderUsagePair removed = SharingBufferReaderProvider.this.allReaders.remove(this.reader);
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    log.warn("Unable to close Lucene IndexReader", (Throwable)e);
                }
                assert (removed != null);
            } else if (refCount < 0) {
                throw new AssertionFailure("Closing an IndexReader for which you didn't own a lock-token, or somebody else which didn't own closed already.");
            }
        }

        public String toString() {
            return "Reader:" + this.hashCode() + " ref.count=" + this.usageCounter.get();
        }
    }
}

