/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.security;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.stream.StreamUtil;
import fr.dyade.aaa.common.stream.Streamable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class Identity
implements Externalizable,
Streamable {
    public static Logger logger = Debug.getLogger((String)Identity.class.getName());
    private static final String SEPARATE_CHAR = ":";

    public abstract String getUserName();

    public abstract void setUserName(String var1);

    public abstract void setIdentity(String var1, String var2) throws Exception;

    public abstract boolean check(Identity var1) throws Exception;

    public static String getRootIdentityClass(String rootName) {
        String identityClassName = null;
        int index = rootName.indexOf(SEPARATE_CHAR);
        identityClassName = index > 0 ? rootName.substring(0, index) : SimpleIdentity.class.getName();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("getRootIdentityClass: identityClassName = " + identityClassName));
        }
        return identityClassName;
    }

    public static String getRootName(String rootName) {
        String root = rootName;
        int index = rootName.indexOf(SEPARATE_CHAR);
        if (index > 0) {
            root = root.substring(index + 1, rootName.length());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("getRootName: rootName = " + root));
        }
        return root;
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Identity.writeExternal");
        }
        this.writeTo((OutputStream)((Object)out));
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Identity.readExternal");
        }
        this.readFrom((InputStream)((Object)in));
    }

    public static void write(Identity identity, OutputStream os) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Identity.write: " + identity));
        }
        if (identity == null) {
            StreamUtil.writeTo((String)null, (OutputStream)os);
            return;
        }
        if (identity instanceof SimpleIdentity) {
            StreamUtil.writeTo((String)"", (OutputStream)os);
        } else {
            StreamUtil.writeTo((String)identity.getClass().getName(), (OutputStream)os);
        }
        identity.writeTo(os);
    }

    public static Identity read(InputStream is) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Identity identity = null;
        String classname = StreamUtil.readStringFrom((InputStream)is);
        if (classname != null) {
            if (classname.length() == 0) {
                classname = SimpleIdentity.class.getName();
            }
            identity = (Identity)Class.forName(classname).newInstance();
            identity.readFrom(is);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Identity.read: " + identity));
        }
        return identity;
    }
}

