/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.common.Debug;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.SecurityException;
import org.objectweb.joram.client.connector.DefaultConnectionManager;
import org.objectweb.joram.client.connector.JoramResourceAdapter;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.joram.client.connector.OutboundQueueConnectionFactory;
import org.objectweb.joram.client.connector.QueueConnectionRequest;
import org.objectweb.joram.client.jms.admin.AbstractConnectionFactory;
import org.objectweb.joram.client.jms.local.XALocalConnectionFactory;
import org.objectweb.joram.client.jms.local.XAQueueLocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.XAQueueTcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.XATcpConnectionFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ManagedQueueConnectionFactoryImpl
extends ManagedConnectionFactoryImpl {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)ManagedQueueConnectionFactoryImpl.class.getName());

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createConnectionFactory(" + cxManager + ")"));
        }
        return new OutboundQueueConnectionFactory(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createConnectionFactory()"));
        }
        OutboundQueueConnectionFactory factory = new OutboundQueueConnectionFactory(this, DefaultConnectionManager.getRef());
        Reference ref = new Reference(factory.getClass().getName(), "org.objectweb.joram.client.connector.ObjectFactoryImpl", null);
        ref.add(new StringRefAddr("hostName", this.getHostName()));
        ref.add(new StringRefAddr("serverPort", "" + this.getServerPort()));
        ref.add(new StringRefAddr("userName", this.getUserName()));
        ref.add(new StringRefAddr("password", this.getPassword()));
        ref.add(new StringRefAddr("identityClass", this.getIdentityClass()));
        factory.setReference(ref);
        return factory;
    }

    protected XAConnectionFactory createFactory(ConnectionRequestInfo cxRequest) throws ResourceException {
        Object factory = null;
        String hostName = this.getHostName();
        int serverPort = this.getServerPort();
        factory = this.isCollocated().booleanValue() ? (cxRequest instanceof QueueConnectionRequest ? XAQueueLocalConnectionFactory.create() : XALocalConnectionFactory.create()) : (cxRequest instanceof QueueConnectionRequest ? XAQueueTcpConnectionFactory.create((String)hostName, (int)serverPort) : XATcpConnectionFactory.create((String)hostName, (int)serverPort));
        ((AbstractConnectionFactory)factory).setCnxJMXBeanBaseName(JoramResourceAdapter.jmxRootName + "#" + this.ra.getName());
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createFactory factory = " + factory));
        }
        return factory;
    }

    protected XAConnection createXAConnection(XAConnectionFactory factory, String userName, String password) throws ResourceException {
        Object cnx = null;
        try {
            cnx = factory instanceof XAQueueConnectionFactory ? ((XAQueueConnectionFactory)factory).createXAQueueConnection(userName, password) : factory.createXAConnection(userName, password);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " createXAConnection cnx = " + cnx));
            }
        }
        catch (IllegalStateException exc) {
            if (this.out != null) {
                this.out.print("Could not access the JORAM server: " + (Object)((Object)exc));
            }
            throw new CommException("Could not access the JORAM server: " + (Object)((Object)exc));
        }
        catch (JMSSecurityException exc) {
            if (this.out != null) {
                this.out.print("Invalid user identification: " + (Object)((Object)exc));
            }
            throw new SecurityException("Invalid user identification: " + (Object)((Object)exc));
        }
        catch (JMSException exc) {
            if (this.out != null) {
                this.out.print("Failed connecting process: " + (Object)((Object)exc));
            }
            throw new ResourceException("Failed connecting process: " + (Object)((Object)exc));
        }
        return cnx;
    }

    public int hashCode() {
        return ("PTP:" + this.getHostName() + ":" + this.getServerPort() + "-" + this.getUserName()).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ManagedQueueConnectionFactoryImpl)) {
            return false;
        }
        return super.equals(o);
    }
}

