/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ow2.easybeans.api.EZBTimerService;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.itf.TimerComponent;
import org.ow2.easybeans.component.quartz.CallbackJob;
import org.ow2.easybeans.component.quartz.CallbackJobDetailData;
import org.ow2.easybeans.component.quartz.QuartzTimerService;
import org.ow2.easybeans.component.util.Property;
import org.ow2.easybeans.component.util.TimerCallback;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuartzComponent
implements TimerComponent {
    private Scheduler scheduler = null;
    private List<Property> quartzProperties = null;
    private SchedulerFactory schedulerFactory = null;

    public void init() throws EZBComponentException {
        Properties schedulerProperties = new Properties();
        if (this.quartzProperties != null) {
            for (Property property : this.quartzProperties) {
                schedulerProperties.put(property.getName(), property.getValue());
            }
        }
        this.schedulerFactory = null;
        try {
            this.schedulerFactory = new StdSchedulerFactory(schedulerProperties);
        }
        catch (SchedulerException e) {
            throw new EZBComponentException("Cannot initialize the Scheduler factory", (Throwable)e);
        }
    }

    public void start() throws EZBComponentException {
        try {
            this.scheduler = this.schedulerFactory.getScheduler();
        }
        catch (SchedulerException e) {
            throw new EZBComponentException("Cannot get a scheduler from the factory", (Throwable)e);
        }
        try {
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            throw new EZBComponentException("Cannot start the scheduler", (Throwable)e);
        }
    }

    public void stop() throws EZBComponentException {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            throw new EZBComponentException("Cannot stop the scheduler", (Throwable)e);
        }
    }

    public EZBTimerService getTimerService(Factory<?, ?> factory) {
        return new QuartzTimerService(factory, this.scheduler);
    }

    public void schedule(String id, long interval, TimerCallback callback, Map<String, Object> callbackProperties) throws EZBComponentException {
        try {
            if (this.getScheduler().getTriggerKeys(GroupMatcher.triggerGroupContains("TimerCallback")).size() != 0) {
                throw new EZBComponentException("An existing TimerCallback with the same id is already registered");
            }
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put("callback-job-detail-data", (Object)new CallbackJobDetailData(callback, callbackProperties));
            JobDetail jobDetail = JobBuilder.newJob(CallbackJob.class).usingJobData(jobDataMap).withIdentity(JobKey.jobKey(id, "TimerCallback")).build();
            SimpleTrigger trigger = TriggerBuilder.newTrigger().withIdentity(TriggerKey.triggerKey(id, "TimerCallback")).forJob(jobDetail).startNow().withSchedule(SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(interval).repeatForever()).build();
            this.getScheduler().scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            throw new EZBComponentException("Unable to schedule TimeCallback " + id + " with a repeat interval of " + interval, (Throwable)e);
        }
    }

    public void unschedule(String id) throws EZBComponentException {
        try {
            this.getScheduler().deleteJob(JobKey.jobKey(id, "TimerCallback"));
        }
        catch (SchedulerException e) {
            throw new EZBComponentException("Unable to unschedule job " + id, (Throwable)e);
        }
    }

    public List<Property> getProperties() {
        return this.quartzProperties;
    }

    public void setProperties(List<Property> quartzProperties) {
        this.quartzProperties = quartzProperties;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

