/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.ejb.ScheduleExpression;
import org.ow2.easybeans.component.quartz.EasyBeansScheduleExpression;
import org.ow2.easybeans.component.quartz.SchedulePatterns;
import org.ow2.easybeans.component.quartz.ScheduleValue;
import org.ow2.easybeans.component.quartz.ScheduleValueAttribute;
import org.ow2.easybeans.component.quartz.ScheduleValueAttributeNDays;
import org.ow2.easybeans.component.quartz.ScheduleValueIncrements;
import org.ow2.easybeans.component.quartz.ScheduleValueLast;
import org.ow2.easybeans.component.quartz.ScheduleValueList;
import org.ow2.easybeans.component.quartz.ScheduleValueRange;
import org.ow2.easybeans.component.quartz.ScheduleValueWildCard;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class ScheduleExpressionParser {
    private static final Log LOGGER = LogFactory.getLog(ScheduleExpressionParser.class);
    private Map<String, Integer> monthNameToInt = new HashMap<String, Integer>();
    private Map<String, Integer> dayOfWeeksToInt = null;

    public ScheduleExpressionParser() {
        this.monthNameToInt.put("jan", 0);
        this.monthNameToInt.put("feb", 1);
        this.monthNameToInt.put("mar", 2);
        this.monthNameToInt.put("apr", 3);
        this.monthNameToInt.put("may", 4);
        this.monthNameToInt.put("jun", 5);
        this.monthNameToInt.put("jul", 6);
        this.monthNameToInt.put("aug", 7);
        this.monthNameToInt.put("sep", 8);
        this.monthNameToInt.put("oct", 9);
        this.monthNameToInt.put("nov", 10);
        this.monthNameToInt.put("dec", 11);
        this.dayOfWeeksToInt = new HashMap<String, Integer>();
        this.dayOfWeeksToInt.put("sun", 0);
        this.dayOfWeeksToInt.put("mon", 1);
        this.dayOfWeeksToInt.put("tue", 2);
        this.dayOfWeeksToInt.put("wed", 3);
        this.dayOfWeeksToInt.put("thu", 4);
        this.dayOfWeeksToInt.put("fri", 5);
        this.dayOfWeeksToInt.put("sat", 6);
    }

    protected String cleanupInput(String input) {
        if (input == null) {
            return null;
        }
        String updatedInput = input.replaceAll("\\s+", "");
        return updatedInput.toLowerCase();
    }

    public EasyBeansScheduleExpression parse(ScheduleExpression scheduleExpression) {
        LOGGER.debug((Object)"Parsing expression ''{0}''", new Object[]{scheduleExpression});
        EasyBeansScheduleExpression quartzExpression = new EasyBeansScheduleExpression();
        String seconds = scheduleExpression.getSecond();
        String minutes = scheduleExpression.getMinute();
        String hours = scheduleExpression.getHour();
        String dayOfMonth = scheduleExpression.getDayOfMonth();
        String month = scheduleExpression.getMonth();
        String dayOfWeek = scheduleExpression.getDayOfWeek();
        String year = scheduleExpression.getYear();
        quartzExpression.setSecond(this.getScheduleValue(seconds, 13));
        quartzExpression.setMinute(this.getScheduleValue(minutes, 12));
        quartzExpression.setHour(this.getScheduleValue(hours, 11));
        quartzExpression.setDayOfMonth(this.getScheduleValue(dayOfMonth, 5));
        quartzExpression.setMonth(this.getScheduleValue(month, 2));
        quartzExpression.setDayOfWeek(this.getScheduleValue(dayOfWeek, 7));
        quartzExpression.setYear(this.getScheduleValue(year, 1));
        return quartzExpression;
    }

    public ScheduleValue getScheduleValue(String inputValue, int calendarField) {
        String value = this.cleanupInput(inputValue);
        if (!this.validate(value, calendarField)) {
            throw new IllegalArgumentException("Unable to validate the field '" + inputValue + "' for calendar field '" + calendarField + "'.");
        }
        String[] commaSeparatedList = value.split(",");
        if (commaSeparatedList.length > 1) {
            ArrayList<String> elements = new ArrayList<String>();
            for (int i = 0; i < commaSeparatedList.length; ++i) {
                String simple = commaSeparatedList[i];
                if (elements.contains(simple)) continue;
                elements.add(simple);
            }
            if (elements.size() > 1) {
                ScheduleValueList scheduleValueList = new ScheduleValueList(calendarField);
                for (String element : elements) {
                    scheduleValueList.add(this.getScheduleValue(element, calendarField));
                }
                return scheduleValueList;
            }
            return this.getScheduleValue((String)elements.get(0), calendarField);
        }
        Matcher incrementMatcher = SchedulePatterns.PATTERN_INCREMENTS.matcher(value);
        if (incrementMatcher.matches()) {
            return new ScheduleValueIncrements(incrementMatcher.group(1), Integer.parseInt(incrementMatcher.group(2)), calendarField);
        }
        Matcher rangeMatcher = SchedulePatterns.PATTERN_RANGE.matcher(value);
        if (rangeMatcher.matches()) {
            String leftRange = rangeMatcher.group(1);
            String rightRange = rangeMatcher.group(2);
            if (7 == calendarField && "0".equals(leftRange) && "7".equals(rightRange)) {
                return new ScheduleValueWildCard(calendarField);
            }
            String left = this.convertToSimple(leftRange, calendarField);
            String right = this.convertToSimple(rightRange, calendarField);
            return new ScheduleValueRange(left, right, calendarField);
        }
        if ("*".equals(value)) {
            return new ScheduleValueWildCard(calendarField);
        }
        if ("last".equals(value)) {
            return new ScheduleValueLast(calendarField);
        }
        if (SchedulePatterns.PATTERN_NDAYS.matcher(value = this.convertToSimple(value, calendarField)).matches()) {
            return new ScheduleValueAttributeNDays(value, calendarField);
        }
        return new ScheduleValueAttribute(Integer.parseInt(value), calendarField);
    }

    public String convertToSimple(String inputValue, int calendarField) {
        String value = this.cleanupInput(inputValue);
        switch (calendarField) {
            case 2: {
                if (SchedulePatterns.PATTERN_MONTH_VALUES.matcher(value).matches()) {
                    Integer monthVal = this.monthNameToInt.get(value);
                    return String.valueOf(monthVal);
                }
                if (!SchedulePatterns.PATTERN_MONTH_1_12.matcher(value).matches()) break;
                return String.valueOf(Integer.parseInt(value) - 1);
            }
            case 7: {
                if (SchedulePatterns.PATTERN_DAY_OF_WEEK_VALUES.matcher(value).matches()) {
                    Integer dayOfweekVal = this.dayOfWeeksToInt.get(value);
                    return String.valueOf(dayOfweekVal);
                }
                if (!SchedulePatterns.PATTERN_DAY_OF_WEEK_0_7.matcher(value).matches()) break;
                return String.valueOf(Integer.parseInt(value));
            }
            default: {
                return value;
            }
        }
        return value;
    }

    protected boolean validate(String inputValue, int calendarField) {
        if (inputValue == null) {
            return false;
        }
        String value = this.cleanupInput(inputValue);
        String[] commaSeparatedList = value.split(",");
        if (commaSeparatedList.length > 1) {
            boolean validated = true;
            for (int i = 0; i < commaSeparatedList.length; ++i) {
                if ("*".equals(commaSeparatedList[i])) {
                    return false;
                }
                if (SchedulePatterns.PATTERN_INCREMENTS.matcher(commaSeparatedList[i]).matches()) {
                    return false;
                }
                validated = validated && this.validate(commaSeparatedList[i], calendarField);
            }
            return validated;
        }
        Matcher incrementMatcher = SchedulePatterns.PATTERN_INCREMENTS.matcher(value);
        if (incrementMatcher.matches()) {
            if (13 != calendarField && 12 != calendarField && 11 != calendarField) {
                throw new IllegalArgumentException("Cannot use increments pattern for an other type than Second/Minute/Hour for the value '" + value + "' for the type '" + calendarField + "'.");
            }
            String leftIncrement = incrementMatcher.group(1);
            String rightIncrement = incrementMatcher.group(2);
            if ("*".equals(leftIncrement)) {
                leftIncrement = "0";
            }
            return this.validate(leftIncrement, calendarField) && this.validate(rightIncrement, calendarField);
        }
        Matcher rangeMatcher = SchedulePatterns.PATTERN_RANGE.matcher(value);
        if (rangeMatcher.matches()) {
            String leftRange = rangeMatcher.group(1);
            String rightRange = rangeMatcher.group(2);
            return this.validate(leftRange, calendarField) && this.validate(rightRange, calendarField);
        }
        switch (calendarField) {
            case 13: {
                return SchedulePatterns.PATTERN_SECOND.matcher(value).matches();
            }
            case 12: {
                return SchedulePatterns.PATTERN_MINUTE.matcher(value).matches();
            }
            case 11: {
                return SchedulePatterns.PATTERN_HOUR.matcher(value).matches();
            }
            case 5: {
                return SchedulePatterns.PATTERN_DAY_OF_MONTH.matcher(value).matches();
            }
            case 2: {
                return SchedulePatterns.PATTERN_MONTH.matcher(value).matches();
            }
            case 7: {
                return SchedulePatterns.PATTERN_DAY_OF_WEEK.matcher(value).matches();
            }
            case 1: {
                return SchedulePatterns.PATTERN_YEAR.matcher(value).matches();
            }
        }
        throw new IllegalStateException("Unknown Calendar Field '" + calendarField + "'");
    }
}

