/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import edu.emory.mathcs.backport.java.util.concurrent.Semaphore;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.jacorb.notification.servant.MessageSupplierDelegate;
import org.omg.CosEventComm.Disconnected;

public class PullMessagesOperation {
    private int pullCounter_;
    private long timeSpentInPull_;
    private int successfulPullCounter_;
    private final MessageSupplierDelegate delegate_;
    private final Semaphore pullSync_ = new Semaphore(1);

    public PullMessagesOperation(MessageSupplierDelegate messageSupplierDelegate) {
        this.delegate_ = messageSupplierDelegate;
    }

    public void runPull() throws Disconnected {
        if (!this.delegate_.getConnected()) {
            throw new Disconnected();
        }
        if (this.delegate_.isSuspended()) {
            return;
        }
        this.runPullInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPullInternal() throws Disconnected {
        block6: {
            try {
                MessageSupplierDelegate.PullResult pullResult;
                boolean bl = this.pullSync_.tryAcquire(1000L, TimeUnit.MILLISECONDS);
                if (!bl) break block6;
                long l = System.currentTimeMillis();
                try {
                    pullResult = this.delegate_.pullMessages();
                }
                finally {
                    this.pullSync_.release();
                    this.timeSpentInPull_ += System.currentTimeMillis() - l;
                }
                ++this.pullCounter_;
                if (pullResult.success_) {
                    ++this.successfulPullCounter_;
                    this.delegate_.queueMessages(pullResult);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getPullCounter() {
        return this.pullCounter_;
    }

    public int getSuccessfulPullCounter() {
        return this.successfulPullCounter_;
    }

    public long getTimeSpentInPull() {
        return this.timeSpentInPull_;
    }
}

