/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.antmodular.jonasbase.db.h2;

import java.io.File;
import org.ow2.jonas.antmodular.jonasbase.bootstrap.JTask;
import org.ow2.jonas.antmodular.jonasbase.db.base.Db;

public class DbH2
extends Db {
    private static final String DB_CLASS = "org.ow2.jonas.db.h2.H2DBServiceImpl";
    public static final String H2_CLASS_NAME = "org.h2.Driver";
    public static final String H2_MAPPER = "rdb.hsql";

    public String getUrl(String host) {
        String database;
        String port;
        String hostname = host;
        if (hostname == null) {
            hostname = "localhost";
        }
        if ((port = this.portNumber) == null) {
            port = "9001";
        }
        if ((database = this.dbName) == null) {
            database = "db_jonas";
        }
        return "jdbc:h2:tcp://" + hostname + ":" + port + "/" + database;
    }

    public String getClassname() {
        return H2_CLASS_NAME;
    }

    public String getMapper() {
        return H2_MAPPER;
    }

    public void execute() {
        super.execute();
        String jBaseConf = this.destDir.getPath() + File.separator + "conf";
        JTask jTask = new JTask();
        jTask.setDestDir(this.destDir);
        jTask.changeValueForKey("[DB] ", jBaseConf, "jonas.properties", "jonas.service.db.class", DB_CLASS, false);
        this.addTask(jTask);
        super.executeAllTask();
    }
}

