/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ow2.easybeans.api.bean.info.IAccessTimeoutInfo;
import org.ow2.easybeans.api.bean.info.ILockTypeInfo;
import org.ow2.easybeans.api.bean.info.IMethodInfo;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.container.info.AccessTimeoutInfo;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJEjbAccessTimeout;
import org.ow2.util.ee.metadata.ejbjar.api.struct.ILockType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
implements IMethodInfo {
    private String name = null;
    private List<String> parameterList = new ArrayList<String>();
    private String returnType = null;
    private List<String> exceptionList = null;
    private String descriptor = null;
    private IAccessTimeoutInfo accessTimeout = null;
    private ILockTypeInfo lockType = null;
    private boolean transacted = false;
    private boolean isAfterBegin = false;
    private boolean isBeforeCompletion = false;
    private boolean isAfterCompletion = false;

    public MethodInfo(EasyBeansEjbJarMethodMetadata methodMetadata) {
        this.name = methodMetadata.getMethodName();
        String descriptor = methodMetadata.getJMethod().getDescriptor();
        this.returnType = Type.getReturnType(descriptor).getDescriptor();
        String[] exceptions = methodMetadata.getJMethod().getExceptions();
        this.exceptionList = exceptions != null ? Arrays.asList(exceptions) : new ArrayList<String>();
        Type[] argumentTypes = Type.getArgumentTypes(descriptor);
        if (argumentTypes != null) {
            for (Type argumentType : argumentTypes) {
                String className = argumentType.getClassName();
                if (9 == argumentType.getSort()) {
                    className = argumentType.getDescriptor().replace('/', '.');
                }
                this.parameterList.add(className);
            }
        }
        this.descriptor = methodMetadata.getJMethod().getDescriptor();
        this.transacted = methodMetadata.isTransacted();
        EasyBeansEjbJarClassMetadata classMetadata = null;
        classMetadata = methodMetadata.isInherited() ? methodMetadata.getOriginalClassMetadata() : (EasyBeansEjbJarClassMetadata)methodMetadata.getClassMetadata();
        ILockType beanlock = classMetadata.getLockType();
        ILockType methodLock = methodMetadata.getLockType();
        if (methodLock == null && beanlock != null) {
            methodLock = beanlock;
        }
        if (methodLock != null) {
            this.lockType = ILockTypeInfo.valueOf((String)methodLock.toString().toUpperCase());
        }
        IJEjbAccessTimeout beanAccessTimeout = classMetadata.getJavaxEjbAccessTimeout();
        IJEjbAccessTimeout methodAccessTimeout = methodMetadata.getJavaxEjbAccessTimeout();
        if (methodAccessTimeout == null && beanAccessTimeout != null) {
            methodAccessTimeout = beanAccessTimeout;
        }
        if (methodAccessTimeout != null) {
            this.accessTimeout = new AccessTimeoutInfo(methodAccessTimeout.getValue(), methodAccessTimeout.getUnit());
        }
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getParameters() {
        return this.parameterList;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public List<String> getExceptions() {
        return this.exceptionList;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public IAccessTimeoutInfo getAccessTimeout() {
        return this.accessTimeout;
    }

    public ILockTypeInfo getLockType() {
        return this.lockType;
    }

    public boolean isAfterBegin() {
        return this.isAfterBegin;
    }

    public void setAfterBegin() {
        this.isAfterBegin = true;
    }

    public boolean isBeforeCompletion() {
        return this.isBeforeCompletion;
    }

    public void setBeforeCompletion() {
        this.isBeforeCompletion = true;
    }

    public boolean isAfterCompletion() {
        return this.isAfterCompletion;
    }

    public void setAfterCompletion() {
        this.isAfterCompletion = true;
    }
}

