/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session.stateful;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import javax.ejb.Timer;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBStatefulSessionFactory;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.api.bean.EasyBeansSFSB;
import org.ow2.easybeans.api.bean.info.IMethodInfo;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.util.TimerCallback;
import org.ow2.easybeans.container.session.JPoolWrapperFactory;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.container.session.stateful.ConcurrentBuilderException;
import org.ow2.easybeans.event.bean.EventBeanInvocationEnd;
import org.ow2.easybeans.event.bean.EventBeanInvocationError;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.persistence.api.EZBExtendedEntityManager;
import org.ow2.easybeans.rpc.JEJBResponse;
import org.ow2.easybeans.rpc.api.EJBLocalRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.api.RPCException;
import org.ow2.util.ee.metadata.ejbjar.api.struct.IJEjbStatefulTimeout;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.enhanced.EnhancedCluePool;
import org.ow2.util.pool.impl.enhanced.api.clue.basiccluemanager.IClueAccessor;
import org.ow2.util.pool.impl.enhanced.impl.clue.basiccluemanager.BasicClueManager;
import org.ow2.util.pool.impl.enhanced.manager.clue.ICluePoolManager;
import org.ow2.util.pool.impl.enhanced.manager.clue.optional.IPoolItemRemoveClueManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulSessionFactory
extends SessionFactory<EasyBeansSFSB>
implements EZBStatefulSessionFactory<EasyBeansSFSB, Long>,
IPoolItemRemoveClueManager<EasyBeansSFSB, Long>,
IClueAccessor<EasyBeansSFSB, Long>,
TimerCallback {
    private static final String STATEFUL_TIMEOUT_INTERVAL_FLAG = "easybeans.stateful.timeout.check.interval";
    private static Log logger = LogFactory.getLog(StatefulSessionFactory.class);
    private long idCount = 0L;
    private BasicClueManager<EasyBeansSFSB, Long> basicClueManager;
    private Map<Long, Lock> locks;
    private final Map<Long, Lock> statefulTimeoutLocks;
    private Map<EasyBeansSFSB, List<EZBExtendedEntityManager>> extendedPersistenceContexts = null;
    private InheritableThreadLocal<Long> currentBeanId = null;
    private Map<Transaction, Synchronization> sessionSynchronizationListeners = null;
    private long statefulTimeoutTimerInterval = 480000L;
    private final List<String> scheduledJobIds = new ArrayList<String>();
    private static final String BEAN_ID_KEY = "BEAN-ID";
    private final List<Long> killedTimedoutIds = new ArrayList<Long>();

    public StatefulSessionFactory(String className, EZBContainer container) throws FactoryException {
        this(className, container, false);
    }

    public StatefulSessionFactory(String className, EZBContainer container, boolean useExtendedPersistenceContext) throws FactoryException {
        super(className, container);
        this.locks = new HashMap<Long, Lock>();
        this.statefulTimeoutLocks = new HashMap<Long, Lock>();
        this.currentBeanId = new InheritableThreadLocal();
        this.sessionSynchronizationListeners = new WeakHashMap<Transaction, Synchronization>();
        this.extendedPersistenceContexts = new HashMap<EasyBeansSFSB, List<EZBExtendedEntityManager>>();
        if (Boolean.getBoolean("easybeans.useSimplePool") || useExtendedPersistenceContext) {
            this.setPool(new JPool(new JPoolWrapperFactory(this)));
        } else {
            EnhancedCluePool enhancedPool = this.getManagementPool().getEnhancedCluePoolFactory().createEnhancedCluePool((ICluePoolManager)this);
            this.basicClueManager = new BasicClueManager((IClueAccessor)this, false, false);
            enhancedPool.setAllowSharedInstance(false);
            this.setPool(enhancedPool);
        }
        this.statefulTimeoutTimerInterval = Long.getLong(STATEFUL_TIMEOUT_INTERVAL_FLAG, this.statefulTimeoutTimerInterval);
    }

    protected synchronized Long getId(Long beanId) {
        Long newId = beanId;
        if (newId == null) {
            ++this.idCount;
            newId = this.idCount;
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected EasyBeansSFSB getBean(Long beanId) throws IllegalArgumentException {
        EasyBeansSFSB bean = null;
        try {
            bean = (EasyBeansSFSB)this.getPool().get((Object)beanId);
        }
        catch (PoolException e) {
            throw new IllegalArgumentException("Cannot get element in the pool", e);
        }
        logger.debug((Object)"Set for bean {0} the Id = {1}", new Object[]{bean, beanId});
        bean.setEasyBeansStatefulID(beanId);
        IJEjbStatefulTimeout statefulTimeout = this.getSessionBeanInfo().getStatefulTimeout();
        if (statefulTimeout != null && statefulTimeout.getValue() >= 0L && bean.getStatefulTimeout() == null) {
            bean.setStatefulTimeout(Long.valueOf(System.currentTimeMillis() + statefulTimeout.getUnit().toMillis(statefulTimeout.getValue())));
            logger.debug((Object)"Factory {0}/{1} have stateful timeout {2} {3}", new Object[]{this.getClassName(), this.getId(), statefulTimeout.getValue(), statefulTimeout.getUnit()});
            logger.debug((Object)"Scheduling a timeout callback for bean {0} with id: {1}", new Object[]{bean, beanId});
            HashMap<String, Long> properties = new HashMap<String, Long>();
            String jobId = this.getId() + "-" + beanId;
            properties.put(BEAN_ID_KEY, beanId);
            List<String> list = this.scheduledJobIds;
            synchronized (list) {
                if (!this.scheduledJobIds.contains(jobId)) {
                    try {
                        this.getTimerComponent().schedule(jobId, this.statefulTimeoutTimerInterval, (TimerCallback)this, properties);
                        this.scheduledJobIds.add(jobId);
                    }
                    catch (EZBComponentException e) {
                        logger.info((Object)"EZBComponentException caught when scheduling a stateful timeout check", new Object[]{e});
                    }
                }
            }
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(EasyBeansSFSB instance) {
        List<EZBExtendedEntityManager> extendedEntityManagers = this.getExtendedPersistenceContexts(instance);
        try {
            if (extendedEntityManagers != null) {
                for (EZBExtendedEntityManager extendedEntityManager : extendedEntityManagers) {
                    extendedEntityManager.close();
                }
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            IJEjbStatefulTimeout statefulTimeout = this.getSessionBeanInfo().getStatefulTimeout();
            if (statefulTimeout != null && statefulTimeout.getValue() >= 0L) {
                String jobId = this.getId() + "-" + instance.getEasyBeansStatefulID();
                List<String> list = this.scheduledJobIds;
                synchronized (list) {
                    if (this.scheduledJobIds.contains(jobId)) {
                        try {
                            this.getTimerComponent().unschedule(jobId);
                        }
                        catch (EZBComponentException e) {
                            logger.info((Object)"EZBComponentException caught when unscheduling a stateful timeout check", new Object[]{e});
                        }
                        this.scheduledJobIds.remove(jobId);
                    }
                }
            }
            super.remove(instance);
            instance.setEasyBeansRemoved(true);
            Map<Long, Lock> map = this.locks;
            synchronized (map) {
                this.locks.remove(instance.getEasyBeansStatefulID());
            }
            map = this.statefulTimeoutLocks;
            synchronized (map) {
                this.statefulTimeoutLocks.remove(instance.getEasyBeansStatefulID());
            }
            throw throwable;
        }
        IJEjbStatefulTimeout statefulTimeout = this.getSessionBeanInfo().getStatefulTimeout();
        if (statefulTimeout != null && statefulTimeout.getValue() >= 0L) {
            String jobId = this.getId() + "-" + instance.getEasyBeansStatefulID();
            List<String> list = this.scheduledJobIds;
            synchronized (list) {
                if (this.scheduledJobIds.contains(jobId)) {
                    try {
                        this.getTimerComponent().unschedule(jobId);
                    }
                    catch (EZBComponentException e) {
                        logger.info((Object)"EZBComponentException caught when unscheduling a stateful timeout check", new Object[]{e});
                    }
                    this.scheduledJobIds.remove(jobId);
                }
            }
        }
        super.remove(instance);
        instance.setEasyBeansRemoved(true);
        Map<Long, Lock> map = this.locks;
        synchronized (map) {
            this.locks.remove(instance.getEasyBeansStatefulID());
        }
        map = this.statefulTimeoutLocks;
        synchronized (map) {
            this.statefulTimeoutLocks.remove(instance.getEasyBeansStatefulID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void injectResources(EasyBeansSFSB instance) throws PoolException {
        Map oldExtendedPersistenceContexts = this.getContainer().getCurrentExtendedPersistenceContexts();
        if (oldExtendedPersistenceContexts == null) {
            HashMap extendedPersistenceContexts = new HashMap();
            this.getContainer().setCurrentExtendedPersistenceContexts(extendedPersistenceContexts);
        }
        try {
            super.injectResources(instance);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getContainer().setCurrentExtendedPersistenceContexts(oldExtendedPersistenceContexts);
            throw throwable;
        }
        this.getContainer().setCurrentExtendedPersistenceContexts(oldExtendedPersistenceContexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EJBResponse localCall(EJBLocalRequest localCallRequest) {
        block64: {
            block61: {
                block66: {
                    block65: {
                        id = this.getId(localCallRequest.getBeanId());
                        methodHash = localCallRequest.getMethodHash();
                        ejbResponse = new JEJBResponse();
                        ejbResponse.setBeanId(id);
                        if (this.getSessionBeanInfo().getStatefulTimeout() != null) {
                            var5_5 = this.killedTimedoutIds;
                            synchronized (var5_5) {
                                if (this.killedTimedoutIds.contains(id)) {
                                    this.killedTimedoutIds.remove(id);
                                    ejbResponse.setRemoved(true);
                                    ejbResponse.setRPCException(new RPCException("Bean has been removed due to an idle timeout", (Throwable)new NoSuchEJBException("Bean has been removed due to an idle timeout")));
                                    return ejbResponse;
                                }
                            }
                        }
                        methodInfo = this.getMethodInfoHashes().get(methodHash);
                        accessTimeout = null;
                        if (methodInfo != null) {
                            accessTimeout = methodInfo.getAccessTimeout();
                        }
                        lock = null;
                        var8_8 = this.locks;
                        synchronized (var8_8) {
                            lock = this.locks.get(id);
                            if (lock == null) {
                                lock = new ReentrantLock();
                                this.locks.put(id, lock);
                            }
                        }
                        getAccess = true;
                        if (accessTimeout == null) break block65;
                        if (accessTimeout.value() == -1L) {
                            lock.lock();
                            break block66;
                        } else if (accessTimeout.value() >= 0L) {
                            try {
                                StatefulSessionFactory.logger.debug((Object)"Trying to lock bean with id ''{0}'' with value ''{1}'' and timeunit ''{2}''", new Object[]{id, accessTimeout.value(), accessTimeout.unit()});
                                getAccess = lock.tryLock(accessTimeout.value(), accessTimeout.unit());
                            }
                            catch (InterruptedException e) {
                                ejbResponse.setRPCException(new RPCException("Cannot get a lock for the stateful instance", (Throwable)e));
                                return ejbResponse;
                            }
                        }
                        break block66;
                    }
                    lock.lock();
                }
                if (!getAccess && accessTimeout != null) {
                    rpcException = null;
                    rpcException = accessTimeout.value() == 0L ? new RPCException((Throwable)ConcurrentBuilderException.buildConcurrentException("Unable to get a concurrent access on bean '" + this.getClassName() + "' and method '" + this.getHashes().get(methodHash) + "'.")) : new RPCException((Throwable)ConcurrentBuilderException.buildConcurrentTimeoutException("Unable to get a concurrent access with an accessTimeout of '" + accessTimeout + "' on bean '" + this.getClassName() + "' and method '" + this.getHashes().get(methodHash) + "'."));
                    ejbResponse.setRPCException(rpcException);
                    return ejbResponse;
                }
                statefulTimeoutLock = null;
                if (this.getSessionBeanInfo().getStatefulTimeout() != null) {
                    var10_13 = this.statefulTimeoutLocks;
                    synchronized (var10_13) {
                        statefulTimeoutLock = this.statefulTimeoutLocks.get(id);
                        if (statefulTimeoutLock == null) {
                            statefulTimeoutLock = new ReentrantLock();
                        }
                        this.locks.put(id, statefulTimeoutLock);
                    }
                    statefulTimeoutLock.lock();
                }
                try {
                    block63: {
                        block70: {
                            bean = null;
                            try {
                                bean = this.getBean(id);
                            }
                            catch (IllegalArgumentException e) {
                                ejbResponse.setRPCException(new RPCException("Cannot get element in the pool", (Throwable)new NoSuchEJBException("Bean has been removed", (Exception)e)));
                                var12_19 = ejbResponse;
                                var31_23 = null;
                                lock.unlock();
                                if (statefulTimeoutLock == null) return var12_19;
                                statefulTimeoutLock.unlock();
                                return var12_19;
                            }
                            catch (NoSuchEJBException e) {
                                ejbResponse.setRPCException(new RPCException("Bean has been removed", (Throwable)e));
                                var12_20 = ejbResponse;
                                var31_24 = null;
                                lock.unlock();
                                if (statefulTimeoutLock == null) return var12_20;
                                statefulTimeoutLock.unlock();
                                return var12_20;
                            }
                            if (!(bean.getStatefulTimeout() == null || bean.getInTransaction() != null && bean.getInTransaction().booleanValue())) {
                                StatefulSessionFactory.logger.debug((Object)"Checking idle timeout for bean {0} with id: {1}", new Object[]{bean, id});
                                if (System.currentTimeMillis() > bean.getStatefulTimeout()) {
                                    StatefulSessionFactory.logger.debug((Object)"Bean {0} with id: {1} is eligible to collection due to an idle timeout, discarding it", new Object[]{bean, id});
                                    try {
                                        this.getPool().discard((Object)bean);
                                    }
                                    catch (PoolException e) {
                                        StatefulSessionFactory.logger.warn((Object)"Unable to discard the bean {0} with id: {1} eligible to collection due to an idle timeout", new Object[]{bean, id, e});
                                    }
                                    ejbResponse.setRemoved(true);
                                    ejbResponse.setRPCException(new RPCException("Bean has been removed due to an idle timeout", (Throwable)new NoSuchEJBException("Bean has been removed due to an idle timeout")));
                                    e = ejbResponse;
                                    var31_25 = null;
                                    lock.unlock();
                                    if (statefulTimeoutLock == null) return e;
                                    statefulTimeoutLock.unlock();
                                    return e;
                                }
                            }
                            if ((m = this.getHashes().get(methodHash)) == null) {
                                ejbResponse.setRPCException(new RPCException("Cannot find method called on the bean '" + this.getClassName() + "'.", (Throwable)new NoSuchMethodException("The method is not found on the bean")));
                                var12_21 = ejbResponse;
                                break block61;
                            }
                            value = null;
                            oldClassLoader = Thread.currentThread().getContextClassLoader();
                            Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
                            oldInvokedBusinessInterface = (String)this.getInvokedBusinessInterfaceNameThreadLocal().get();
                            this.getInvokedBusinessInterfaceNameThreadLocal().set(localCallRequest.getInvokedBusinessInterfaceName());
                            oldState = this.getOperationState();
                            this.getOperationStateThreadLocal().set(OperationState.BUSINESS_METHOD);
                            oldBeanId = (Long)this.getCurrentBeanIDThreadLocal().get();
                            this.getCurrentBeanIDThreadLocal().set(id);
                            methodEventProviderId = this.getJ2EEManagedObjectId() + "/" + J2EEManagedObjectNamingHelper.getMethodSignature(m) + "@Local";
                            enabledEvent = localCallRequest.isCalledFromRemoteRequest() == false;
                            event = null;
                            number = 0L;
                            previousID = null;
                            if (enabledEvent) {
                                if (this.getCurrentInvocationID() != null) {
                                    previousID = this.getCurrentInvocationID().newInvocation();
                                }
                                event = this.getInvocationEventBegin(methodEventProviderId, localCallRequest.getMethodArgs());
                                number = event.getInvocationNumber();
                                this.getEventDispatcher().dispatch((IEvent)event);
                            }
                            try {
                                try {
                                    value = m.invoke((Object)bean, localCallRequest.getMethodArgs());
                                }
                                catch (IllegalArgumentException e) {
                                    ejbResponse.setRPCException(new RPCException((Throwable)e));
                                    if (enabledEvent) {
                                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                                    }
                                    var28_39 = null;
                                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                                    this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                                    this.getOperationStateThreadLocal().set(oldState);
                                    this.getCurrentBeanIDThreadLocal().set(oldBeanId);
                                    if (enabledEvent) {
                                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                                        if (this.getCurrentInvocationID() != null) {
                                            this.getCurrentInvocationID().setAuditID(previousID);
                                        }
                                    }
                                    try {
                                        this.getPool().release((Object)bean);
                                    }
                                    catch (PoolException e) {
                                        ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e));
                                    }
                                    if (bean.getEasyBeansRemoved()) {
                                        ejbResponse.setRemoved(true);
                                    }
                                    break block63;
                                }
                                catch (IllegalAccessException e) {
                                    block67: {
                                        ejbResponse.setRPCException(new RPCException((Throwable)e));
                                        if (enabledEvent) {
                                            this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                                        }
                                        var28_40 = null;
                                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                                        this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                                        this.getOperationStateThreadLocal().set(oldState);
                                        this.getCurrentBeanIDThreadLocal().set(oldBeanId);
                                        if (enabledEvent) {
                                            this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                                            if (this.getCurrentInvocationID() != null) {
                                                this.getCurrentInvocationID().setAuditID(previousID);
                                            }
                                        }
                                        ** try [egrp 9[TRYBLOCK] [19 : 1473->1487)] { 
lbl173:
                                        // 1 sources

                                        this.getPool().release((Object)bean);
                                        break block67;
lbl175:
                                        // 1 sources

                                        catch (PoolException e) {
                                            ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e));
                                        }
                                    }
                                    if (bean.getEasyBeansRemoved()) {
                                        ejbResponse.setRemoved(true);
                                    }
                                    break block63;
                                }
                                catch (InvocationTargetException e) {
                                    block68: {
                                        cause = e.getCause();
                                        rpcException = new RPCException(cause);
                                        applicationException = this.getBeanInfo().getApplicationException(cause);
                                        if (applicationException != null) {
                                            rpcException.setApplicationException();
                                        }
                                        ejbResponse.setRPCException(rpcException);
                                        if (enabledEvent) {
                                            this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                                        }
                                        var28_41 = null;
                                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                                        this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                                        this.getOperationStateThreadLocal().set(oldState);
                                        this.getCurrentBeanIDThreadLocal().set(oldBeanId);
                                        if (enabledEvent) {
                                            this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                                            if (this.getCurrentInvocationID() != null) {
                                                this.getCurrentInvocationID().setAuditID(previousID);
                                            }
                                        }
                                        ** try [egrp 9[TRYBLOCK] [19 : 1473->1487)] { 
lbl204:
                                        // 1 sources

                                        this.getPool().release((Object)bean);
                                        break block68;
lbl206:
                                        // 1 sources

                                        catch (PoolException e) {
                                            ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e));
                                        }
                                    }
                                    if (bean.getEasyBeansRemoved()) {
                                        ejbResponse.setRemoved(true);
                                    }
                                    break block63;
                                }
                                var28_38 = null;
                                Thread.currentThread().setContextClassLoader(oldClassLoader);
                            }
                            catch (Throwable var27_55) {
                                block69: {
                                    var28_42 = null;
                                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                                    this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                                    this.getOperationStateThreadLocal().set(oldState);
                                    this.getCurrentBeanIDThreadLocal().set(oldBeanId);
                                    if (enabledEvent) {
                                        this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                                        if (this.getCurrentInvocationID() != null) {
                                            this.getCurrentInvocationID().setAuditID(previousID);
                                        }
                                    }
                                    ** try [egrp 9[TRYBLOCK] [19 : 1473->1487)] { 
lbl229:
                                    // 1 sources

                                    this.getPool().release((Object)bean);
                                    break block69;
lbl231:
                                    // 1 sources

                                    catch (PoolException e) {
                                        ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e));
                                    }
                                }
                                if (bean.getEasyBeansRemoved() == false) throw var27_55;
                                ejbResponse.setRemoved(true);
                                throw var27_55;
                            }
                            this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                            this.getOperationStateThreadLocal().set(oldState);
                            this.getCurrentBeanIDThreadLocal().set(oldBeanId);
                            if (enabledEvent) {
                                this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                                if (this.getCurrentInvocationID() != null) {
                                    this.getCurrentInvocationID().setAuditID(previousID);
                                }
                            }
                            ** try [egrp 9[TRYBLOCK] [19 : 1473->1487)] { 
lbl247:
                            // 1 sources

                            this.getPool().release((Object)bean);
                            break block70;
lbl249:
                            // 1 sources

                            catch (PoolException e) {
                                ejbResponse.setRPCException(new RPCException("cannot release bean", (Throwable)e));
                            }
                        }
                        if (bean.getEasyBeansRemoved()) {
                            ejbResponse.setRemoved(true);
                        }
                    }
                    ejbResponse.setValue(value);
                    statefulTimeout = this.getSessionBeanInfo().getStatefulTimeout();
                    if (statefulTimeout != null && statefulTimeout.getValue() >= 0L) {
                        StatefulSessionFactory.logger.debug((Object)"Recomputing idle timeout for bean {0} with id: {1}", new Object[]{bean, id});
                        bean.setStatefulTimeout(Long.valueOf(System.currentTimeMillis() + statefulTimeout.getUnit().toMillis(statefulTimeout.getValue())));
                    }
                    break block64;
                }
                catch (Throwable var30_56) {
                    var31_28 = null;
                    lock.unlock();
                    if (statefulTimeoutLock == null) throw var30_56;
                    statefulTimeoutLock.unlock();
                    throw var30_56;
                }
            }
            var31_26 = null;
            lock.unlock();
            if (statefulTimeoutLock == null) return var12_21;
            statefulTimeoutLock.unlock();
            return var12_21;
        }
        var31_27 = null;
        lock.unlock();
        if (statefulTimeoutLock == null) return ejbResponse;
        statefulTimeoutLock.unlock();
        return ejbResponse;
    }

    @Override
    public void notifyTimeout(Timer timer, IMethodInfo methodInfo) {
        throw new EJBException("Stateful bean cannot receive Timer objects");
    }

    public boolean tryMatch(EasyBeansSFSB easyBeansSFSB, Long clue) {
        return this.basicClueManager.tryMatch((Object)easyBeansSFSB, (Object)clue);
    }

    public void unMatch(EasyBeansSFSB easyBeansSFSB) {
        this.basicClueManager.unMatch((Object)easyBeansSFSB);
    }

    public Long getClue(EasyBeansSFSB easyBeansSFSB) {
        return easyBeansSFSB.getEasyBeansStatefulID();
    }

    public void setClue(EasyBeansSFSB easyBeansSFSB, Long clue) {
        logger.debug((Object)"Set for bean {0} the clue = {1}", new Object[]{easyBeansSFSB, clue});
        easyBeansSFSB.setEasyBeansStatefulID(clue);
    }

    public InheritableThreadLocal<Long> getCurrentBeanIDThreadLocal() {
        return this.currentBeanId;
    }

    public Synchronization getSessionSynchronizationListener(Transaction tx) {
        return this.sessionSynchronizationListeners.get(tx);
    }

    public void setSessionSynchronizationListener(Transaction tx, Synchronization sessionSynchronizationListener) {
        this.sessionSynchronizationListeners.put(tx, sessionSynchronizationListener);
    }

    public void unsetSessionSynchronizationListener(Transaction tx) {
        this.sessionSynchronizationListeners.remove(tx);
    }

    public List<EZBExtendedEntityManager> getExtendedPersistenceContexts(EasyBeansSFSB statefulSessionBean) {
        return this.extendedPersistenceContexts.get(statefulSessionBean);
    }

    public void addExtendedPersistenceContext(EasyBeansSFSB statefulSessionBean, EZBExtendedEntityManager extendedEntityManager) {
        List<EZBExtendedEntityManager> list = this.extendedPersistenceContexts.get(statefulSessionBean);
        if (list == null) {
            list = new ArrayList<EZBExtendedEntityManager>();
            this.extendedPersistenceContexts.put(statefulSessionBean, list);
        }
        list.add(extendedEntityManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        this.extendedPersistenceContexts.clear();
        List<String> list = this.scheduledJobIds;
        synchronized (list) {
            for (String scheduledJobId : this.scheduledJobIds) {
                try {
                    this.getTimerComponent().unschedule(scheduledJobId);
                    logger.debug((Object)"Unscheduled job with id: {0}", new Object[]{scheduledJobId});
                }
                catch (EZBComponentException e1) {
                    logger.info((Object)"EZBComponentException caught when scheduling a stateful timeout check", new Object[]{e1});
                }
            }
            this.scheduledJobIds.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, Object> properties) {
        Lock statefulTimeoutLock = null;
        if (this.getSessionBeanInfo().getStatefulTimeout() != null && properties != null) {
            Long beanId = (Long)properties.get(BEAN_ID_KEY);
            logger.debug((Object)"Checking timeout for bean with id: {0}", new Object[]{beanId});
            Map<Long, Lock> map = this.statefulTimeoutLocks;
            synchronized (map) {
                statefulTimeoutLock = this.statefulTimeoutLocks.get(beanId);
                if (statefulTimeoutLock == null) {
                    statefulTimeoutLock = new ReentrantLock();
                }
                this.locks.put(beanId, statefulTimeoutLock);
            }
            try {
                statefulTimeoutLock.lock();
                EasyBeansSFSB bean = null;
                try {
                    bean = this.getBean(beanId);
                }
                catch (Exception e) {
                    logger.debug((Object)"Bean not found, unscheduling timeout callback for bean with id: {0}", new Object[]{beanId});
                    String jobId = this.getId() + "-" + beanId;
                    List<String> list = this.scheduledJobIds;
                    synchronized (list) {
                        try {
                            this.getTimerComponent().unschedule(jobId);
                        }
                        catch (EZBComponentException e1) {
                            logger.info((Object)"EZBComponentException caught when scheduling a stateful timeout check", new Object[]{e1});
                        }
                        this.scheduledJobIds.remove(jobId);
                    }
                    Object var13_16 = null;
                    statefulTimeoutLock.unlock();
                    return;
                }
                if (!(bean.getInTransaction() != null && bean.getInTransaction().booleanValue() || System.currentTimeMillis() <= bean.getStatefulTimeout())) {
                    logger.debug((Object)"Bean {0} with id: {1} is in timeout, discarding it", new Object[]{bean, beanId});
                    try {
                        this.getPool().discard((Object)bean);
                        List<Long> e = this.killedTimedoutIds;
                        synchronized (e) {
                            this.killedTimedoutIds.add(bean.getEasyBeansStatefulID());
                        }
                    }
                    catch (PoolException e) {
                        logger.warn((Object)"Unable to discard timed-out bean", new Object[]{e});
                    }
                    String jobId = this.getId() + "-" + beanId;
                    List<String> list = this.scheduledJobIds;
                    synchronized (list) {
                        try {
                            this.getTimerComponent().unschedule(jobId);
                        }
                        catch (EZBComponentException e) {
                            logger.info((Object)"EZBComponentException caught when scheduling a stateful timeout check", new Object[]{e});
                        }
                        this.scheduledJobIds.remove(jobId);
                    }
                    Object var13_17 = null;
                    statefulTimeoutLock.unlock();
                    return;
                }
                try {
                    this.getPool().release((Object)bean);
                }
                catch (PoolException e) {
                    logger.debug((Object)"Unable to release bean {0} with id: {1}", new Object[]{bean, beanId, e});
                }
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                statefulTimeoutLock.unlock();
                throw throwable;
            }
            Object var13_18 = null;
            statefulTimeoutLock.unlock();
            {
            }
        }
    }
}

