/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.ow2.easybeans.api.EZBServer;
import org.ow2.easybeans.deployer.IRemoteDeployer;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.api.deployer.IDeployerManager;
import org.ow2.util.ee.deploy.api.deployer.UnsupportedDeployerException;
import org.ow2.util.ee.deploy.api.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoteDeployer
implements IRemoteDeployer {
    private static final String DEFAULT_FOLDER = "EasyBeans-" + RemoteDeployer.class.getSimpleName();
    private static Log logger = LogFactory.getLog(RemoteDeployer.class);
    private IDeployerManager deployerManager = null;

    public RemoteDeployer(EZBServer embedded) throws DeployerException {
        this.deployerManager = embedded.getDeployerManager();
    }

    @Override
    public String dumpFile(String fileName, byte[] fileContent) {
        logger.info((Object)"Dump file to the local filesystem with the name = ''{0}''.", new Object[]{fileName});
        File rootFolder = new File(System.getProperty("java.io.tmpdir") + File.separator + DEFAULT_FOLDER);
        rootFolder.mkdirs();
        File file = new File(rootFolder, fileName);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Cannot build an outputstream on file '" + file + "'.", e);
        }
        try {
            out.write(fileContent);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot write byte in outputstream", e);
        }
        try {
            out.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot close outpustream", e);
        }
        return file.getPath();
    }

    @Override
    public void deployFile(String fileName, byte[] fileContent) {
        this.deploy(this.dumpFile(fileName, fileContent));
    }

    @Override
    public void deploy(String fileName) {
        logger.info((Object)"Deploying ''{0}''", new Object[]{fileName});
        IDeployable<?> deployable = this.getDeployable(fileName);
        try {
            this.deployerManager.deploy(deployable);
        }
        catch (DeployerException e) {
            logger.error((Object)"Cannot deploy the deployable ''{0}''", new Object[]{deployable, e});
            throw new RuntimeException("Cannot deploy the deployable '" + deployable + "' : " + e.getMessage());
        }
        catch (UnsupportedDeployerException e) {
            logger.error((Object)"Cannot deploy the deployable ''{0}''", new Object[]{deployable, e});
            throw new RuntimeException("Cannot deploy the deployable '" + deployable + "' : " + e.getMessage());
        }
    }

    protected IDeployable<?> getDeployable(String fileName) {
        IDeployable deployable;
        File file = new File(fileName);
        if (!file.exists()) {
            throw new RuntimeException("The file '" + fileName + "' is not present on the filesystem.");
        }
        IArchive archive = ArchiveManager.getInstance().getArchive((Object)file);
        if (archive == null) {
            logger.error((Object)"No archive found for the invalid file ''{0}''", new Object[]{file});
            throw new RuntimeException("No archive found for the invalid file '" + file + "'.");
        }
        try {
            deployable = DeployableHelper.getDeployable((IArchive)archive);
        }
        catch (DeployableHelperException e) {
            logger.error((Object)"Cannot get a deployable for the archive ''{0}''", new Object[]{archive, e});
            throw new RuntimeException("Cannot get a deployable for the archive '" + archive + "' : " + e.getMessage());
        }
        return deployable;
    }

    @Override
    public void undeploy(String fileName) {
        logger.info((Object)"Undeploying ''{0}''", new Object[]{fileName});
        IDeployable<?> deployable = this.getDeployable(fileName);
        try {
            this.deployerManager.undeploy(deployable);
        }
        catch (DeployerException e) {
            logger.error((Object)"Cannot undeploy the deployable ''{0}''", new Object[]{deployable, e});
            throw new RuntimeException("Cannot undeploy the deployable '" + deployable + "' : " + e.getMessage());
        }
        catch (UnsupportedDeployerException e) {
            logger.error((Object)"Cannot undeploy the deployable ''{0}''", new Object[]{deployable, e});
            throw new RuntimeException("Cannot undeploy the deployable '" + deployable + "' : " + e.getMessage());
        }
    }

    @Override
    public boolean isDeployed(String fileName) {
        IDeployable<?> deployable = this.getDeployable(fileName);
        try {
            return this.deployerManager.isDeployed(deployable);
        }
        catch (DeployerException e) {
            logger.error((Object)"Cannot check isDeployed for  the deployable ''{0}''", new Object[]{deployable, e});
            throw new RuntimeException("Cannot check isDeployed for the deployable '" + deployable + "' : " + e.getMessage());
        }
        catch (UnsupportedDeployerException e) {
            logger.error((Object)"Cannot check isDeployed for  the deployable ''{0}''", new Object[]{deployable, e});
            throw new RuntimeException("Cannot check isDeployed for the deployable '" + deployable + "' : " + e.getMessage());
        }
    }
}

