/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.api.loader.EZBClassLoader;
import org.ow2.easybeans.asm.ClassAdapter;
import org.ow2.easybeans.asm.ClassReader;
import org.ow2.easybeans.asm.ClassVisitor;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EjbJarArchiveMetadata;
import org.ow2.easybeans.enhancer.DefinedClass;
import org.ow2.easybeans.enhancer.EasyBeansClassWriter;
import org.ow2.easybeans.enhancer.EnhancerException;
import org.ow2.easybeans.enhancer.bean.BeanClassAdapter;
import org.ow2.easybeans.enhancer.bean.Migration21ClassAdapter;
import org.ow2.easybeans.enhancer.injection.InjectionClassAdapter;
import org.ow2.easybeans.enhancer.interceptors.InterceptorClassAdapter;
import org.ow2.easybeans.util.topological.NodeWrapper;
import org.ow2.easybeans.util.topological.TopologicalSort;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enhancer {
    private static Log logger = LogFactory.getLog(Enhancer.class);
    private EjbJarArchiveMetadata ejbJarAnnotationMetadata = null;
    private ClassLoader writeLoader = null;
    private ClassLoader readLoader = null;
    private Map<String, Object> map = null;

    public Enhancer(ClassLoader writeLoader, EjbJarArchiveMetadata ejbJarAnnotationMetadata, Map<String, Object> map) {
        this.writeLoader = writeLoader;
        this.ejbJarAnnotationMetadata = ejbJarAnnotationMetadata;
        this.map = map;
        if (writeLoader instanceof EZBClassLoader) {
            this.readLoader = ((EZBClassLoader)writeLoader).duplicate();
        } else if (this.writeLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)this.writeLoader).getURLs();
            this.readLoader = new URLClassLoader(urls, this.writeLoader.getParent());
        } else {
            this.readLoader = writeLoader;
        }
    }

    private static LinkedList<String> getSuperClassesMetadata(EasyBeansEjbJarClassMetadata classAnnotationMetadata) {
        LinkedList<String> superClassesList = new LinkedList<String>();
        String superClassName = classAnnotationMetadata.getSuperName();
        while (!"java/lang/Object".equals(superClassName)) {
            EasyBeansEjbJarClassMetadata superMetaData = (EasyBeansEjbJarClassMetadata)classAnnotationMetadata.getLinkedClassMetadata(superClassName);
            if (superMetaData != null) {
                superClassName = superMetaData.getSuperName();
                superClassesList.addFirst(superMetaData.getClassName());
                continue;
            }
            superClassName = "java/lang/Object";
        }
        superClassesList.addLast(classAnnotationMetadata.getClassName());
        return superClassesList;
    }

    protected List<String> getSortedListBeans() {
        List metadataBeanNames = this.ejbJarAnnotationMetadata.getBeanNames();
        ArrayList<String> beanNames = new ArrayList();
        HashMap<String, NodeWrapper<EasyBeansEjbJarClassMetadata>> nodes = new HashMap<String, NodeWrapper<EasyBeansEjbJarClassMetadata>>();
        boolean inheritanceBetweenBeans = false;
        if (!(this.writeLoader instanceof EZBClassLoader)) {
            for (String beanName : metadataBeanNames) {
                for (EasyBeansEjbJarClassMetadata classAnnotationMetadata : this.ejbJarAnnotationMetadata.getClassesForBean(beanName)) {
                    if (!classAnnotationMetadata.isBean() || !beanName.equals(classAnnotationMetadata.getJCommonBean().getName())) continue;
                    NodeWrapper<EasyBeansEjbJarClassMetadata> node = new NodeWrapper<EasyBeansEjbJarClassMetadata>(beanName, classAnnotationMetadata);
                    nodes.put(classAnnotationMetadata.getClassName(), node);
                }
            }
            for (NodeWrapper node : nodes.values()) {
                EasyBeansEjbJarClassMetadata classMetadata = (EasyBeansEjbJarClassMetadata)((Object)node.getWrapped());
                String superName = classMetadata.getSuperName();
                while (superName != null && !superName.equals("java/lang/Object")) {
                    EasyBeansEjbJarClassMetadata scannMetadata = (EasyBeansEjbJarClassMetadata)this.ejbJarAnnotationMetadata.getScannedClassMetadata(superName);
                    if (scannMetadata == null) {
                        superName = null;
                        continue;
                    }
                    NodeWrapper foundNode = (NodeWrapper)nodes.get(scannMetadata.getClassName());
                    if (foundNode != null) {
                        logger.debug((Object)"Add dependency from ''{0}'' to ''{1}''", new Object[]{node, foundNode});
                        if (!node.getDependencies().contains(foundNode)) {
                            node.addDependency(foundNode);
                            inheritanceBetweenBeans = true;
                        }
                    }
                    superName = scannMetadata.getSuperName();
                }
            }
        }
        if (inheritanceBetweenBeans) {
            beanNames = new ArrayList();
            List<NodeWrapper> sortedNodes = TopologicalSort.sort(nodes.values());
            for (NodeWrapper node : sortedNodes) {
                beanNames.add(node.getName());
            }
            logger.debug((Object)"Beans have been updated from ''{0}'' to ''{1}''", new Object[]{metadataBeanNames, beanNames});
        } else {
            beanNames = metadataBeanNames;
        }
        return beanNames;
    }

    public void enhance() throws EnhancerException {
        InjectionClassAdapter cv2;
        List<String> beanNames = this.getSortedListBeans();
        ArrayList<String> ejbClassAndSuperClassMetadatas = new ArrayList<String>();
        for (String beanName : beanNames) {
            for (EasyBeansEjbJarClassMetadata classAnnotationMetadata : this.ejbJarAnnotationMetadata.getClassesForBean(beanName)) {
                if (!classAnnotationMetadata.isBean()) continue;
                ejbClassAndSuperClassMetadatas.addAll(Enhancer.getSuperClassesMetadata(classAnnotationMetadata));
            }
        }
        for (String beanName : beanNames) {
            for (EasyBeansEjbJarClassMetadata classAnnotationMetadata : this.ejbJarAnnotationMetadata.getClassesForBean(beanName)) {
                if (!classAnnotationMetadata.isInterceptor() || ejbClassAndSuperClassMetadatas.contains(classAnnotationMetadata.getClassName()) || classAnnotationMetadata.wasModified()) continue;
                logger.debug((Object)"ClassAdapter on interceptor : {0}", new Object[]{classAnnotationMetadata.getClassName()});
                EasyBeansEjbJarClassMetadata classicMetadata = (EasyBeansEjbJarClassMetadata)this.ejbJarAnnotationMetadata.getScannedClassMetadata(classAnnotationMetadata.getClassName());
                if (classicMetadata != null && classicMetadata.wasModified()) continue;
                this.enhanceSuperClass(classAnnotationMetadata, null);
                ClassReader cr = this.getClassReader(classAnnotationMetadata);
                EasyBeansClassWriter cw = new EasyBeansClassWriter(this.readLoader);
                InterceptorClassAdapter cv = new InterceptorClassAdapter(classAnnotationMetadata, (ClassVisitor)cw, this.readLoader);
                cv2 = new InjectionClassAdapter(classAnnotationMetadata, cv, this.map, null, false);
                cr.accept(cv2, 0);
                classAnnotationMetadata.setModified();
                if (classicMetadata != null) {
                    classicMetadata.setModified();
                }
                this.defineClass(this.writeLoader, classAnnotationMetadata.getClassName().replace("/", "."), cw.toByteArray());
            }
        }
        for (EasyBeansEjbJarClassMetadata classAnnotationMetadata : this.ejbJarAnnotationMetadata.getEjbJarClassMetadataCollection()) {
            if (!classAnnotationMetadata.isInterceptor() || ejbClassAndSuperClassMetadatas.contains(classAnnotationMetadata.getClassName()) || classAnnotationMetadata.wasModified()) continue;
            logger.debug((Object)"ClassAdapter on interceptor : {0}", new Object[]{classAnnotationMetadata.getClassName()});
            this.enhanceSuperClass(classAnnotationMetadata, null);
            ClassReader cr = this.getClassReader(classAnnotationMetadata);
            EasyBeansClassWriter cw = new EasyBeansClassWriter(this.readLoader);
            InterceptorClassAdapter cv = new InterceptorClassAdapter(classAnnotationMetadata, (ClassVisitor)cw, this.readLoader);
            InjectionClassAdapter cv22 = new InjectionClassAdapter(classAnnotationMetadata, cv, this.map, null, false);
            cr.accept(cv22, 0);
            classAnnotationMetadata.setModified();
            this.defineClass(this.writeLoader, classAnnotationMetadata.getClassName().replace("/", "."), cw.toByteArray());
        }
        logger.info((Object)"Beans found are {0}", new Object[]{this.ejbJarAnnotationMetadata.getBeanNames()});
        for (String beanName : beanNames) {
            for (EasyBeansEjbJarClassMetadata classAnnotationMetadata : this.ejbJarAnnotationMetadata.getClassesForBean(beanName)) {
                if (!classAnnotationMetadata.isBean()) continue;
                this.enhanceSuperClass(classAnnotationMetadata, classAnnotationMetadata);
                ClassReader cr = this.getClassReader(classAnnotationMetadata);
                EasyBeansClassWriter cw = new EasyBeansClassWriter(this.readLoader);
                BeanClassAdapter cv = new BeanClassAdapter(classAnnotationMetadata, cw, this.readLoader);
                InterceptorClassAdapter itcpClassAdapter = new InterceptorClassAdapter(classAnnotationMetadata, (ClassVisitor)cv, this.readLoader);
                ClassAdapter beanVisitor = cv2 = new InjectionClassAdapter(classAnnotationMetadata, itcpClassAdapter, this.map, classAnnotationMetadata, false);
                if (classAnnotationMetadata.getRemoteHome() != null || classAnnotationMetadata.getLocalHome() != null) {
                    Migration21ClassAdapter ejb21Adapter = new Migration21ClassAdapter(classAnnotationMetadata, cv2);
                    beanVisitor = ejb21Adapter;
                }
                cr.accept(beanVisitor, 0);
                this.loadDefinedClasses(this.writeLoader, itcpClassAdapter.getDefinedClasses());
                this.defineClass(this.writeLoader, classAnnotationMetadata.getClassName().replace("/", "."), cw.toByteArray());
                this.loadDefinedClasses(this.writeLoader, cv.getDefinedClasses());
            }
        }
    }

    protected void enhanceSuperClass(EasyBeansEjbJarClassMetadata classAnnotationMetadata, EasyBeansEjbJarClassMetadata beanClassMetadata) throws EnhancerException {
        EasyBeansEjbJarClassMetadata superMetaData;
        String superClass = classAnnotationMetadata.getSuperName();
        if (!superClass.equals("java/lang/Object") && (superMetaData = (EasyBeansEjbJarClassMetadata)classAnnotationMetadata.getLinkedClassMetadata(superClass)) != null && !superMetaData.wasModified()) {
            ClassReader cr = this.getClassReader(superMetaData);
            EasyBeansClassWriter cw = new EasyBeansClassWriter(this.readLoader);
            if (superMetaData.isBean()) {
                superMetaData.setGlobalEasyBeansInterceptors(beanClassMetadata.getGlobalEasyBeansInterceptors());
            }
            InterceptorClassAdapter itcpClassAdapter = new InterceptorClassAdapter(superMetaData, (ClassVisitor)cw, this.readLoader);
            InjectionClassAdapter cv = new InjectionClassAdapter(superMetaData, itcpClassAdapter, this.map, beanClassMetadata, false);
            cr.accept(cv, 0);
            superMetaData.setModified();
            this.enhanceSuperClass(superMetaData, beanClassMetadata);
            this.defineClass(this.writeLoader, superMetaData.getClassName().replace("/", "."), cw.toByteArray());
        }
    }

    protected void loadDefinedClasses(ClassLoader loader, List<DefinedClass> lst) {
        if (lst != null) {
            for (DefinedClass definedClass : lst) {
                this.defineClass(loader, definedClass.getClassName(), definedClass.getBytes());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ClassReader getClassReader(EasyBeansEjbJarClassMetadata classAnnotationMetadata) throws EnhancerException {
        String className = classAnnotationMetadata.getClassName() + ".class";
        InputStream is = this.readLoader.getResourceAsStream(className);
        if (is == null) {
            throw new EnhancerException("Cannot find input stream in classloader " + this.readLoader + " for class " + className);
        }
        ClassReader cr = null;
        try {
            try {
                cr = new ClassReader(is);
            }
            catch (IOException e) {
                throw new EnhancerException("Cannot load input stream for class '" + className + "' in classloader '" + this.readLoader, e);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new EnhancerException("Cannot close input stream for class '" + className + "' in classloader '" + this.readLoader, e);
            }
        }
        try {}
        catch (IOException e) {
            throw new EnhancerException("Cannot close input stream for class '" + className + "' in classloader '" + this.readLoader, e);
        }
        is.close();
        return cr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void defineClass(ClassLoader loader, String className, byte[] b) {
        if (loader instanceof EZBClassLoader) {
            ((EZBClassLoader)loader).addClassDefinition(className, b);
        } else {
            try {
                Class<?> cls = Class.forName("java.lang.ClassLoader");
                Method method = cls.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                try {
                    Object[] args = new Object[]{className, b, 0, b.length};
                    method.invoke((Object)loader, args);
                    Object var8_9 = null;
                    method.setAccessible(false);
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    method.setAccessible(false);
                    throw throwable;
                }
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof LinkageError) {
                    logger.error((Object)"Unable to define the class ''{0}''", new Object[]{className, ite});
                } else {
                    logger.warn((Object)"Unable to define the class ''{0}''", new Object[]{className, ite});
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected EjbJarArchiveMetadata getEjbJarAnnotationMetadata() {
        return this.ejbJarAnnotationMetadata;
    }

    protected Map<String, Object> getMap() {
        return this.map;
    }

    protected ClassLoader getClassLoader() {
        return this.writeLoader;
    }
}

