/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.cluster.daemon;

import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.carol.util.configuration.TraceCarol;
import org.ow2.jonas.cluster.daemon.ClusterDaemon;

public class ShutdownHookThread
extends Thread {
    private ClusterDaemon clusterDaemon;
    private Logger logger;
    public static final int ACTION_DESTROY = 0;
    public static final int ACTION_JONAS_STOP = 1;
    private String keyCmd = null;
    private int action = -1;
    private String serverName = null;

    public ShutdownHookThread(String serverName, String keyCmd, int action, ClusterDaemon clusterDaemon, Logger logger) {
        this.clusterDaemon = clusterDaemon;
        this.keyCmd = keyCmd;
        this.action = action;
        this.serverName = serverName;
        this.logger = logger;
    }

    public void run() {
        try {
            if (this.action == 0) {
                ((Process)this.clusterDaemon.getProcessMap().get(this.keyCmd)).destroy();
                this.logger.log(BasicLevel.DEBUG, (Object)("destroy cmd" + this.keyCmd));
            } else if (this.action == 1) {
                this.logger.log(BasicLevel.DEBUG, (Object)("stop JOnAS instance " + this.serverName));
                this.clusterDaemon.doStopJOnAS(this.serverName);
                this.logger.log(BasicLevel.DEBUG, (Object)("destroy cmd" + this.keyCmd));
                ((Process)this.clusterDaemon.getProcessMap().get(this.keyCmd)).destroy();
            }
        }
        catch (Exception e) {
            TraceCarol.error((String)("ShutdownHook problem for key=" + this.keyCmd), (Throwable)e);
        }
    }
}

