/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Event;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.jmx.ResourceDMBean;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

@DeprecatedProperty(names={"down_thread", "down_thread_prio", "up_thread", "up_thread_prio"})
public abstract class Protocol {
    protected Protocol up_prot = null;
    protected Protocol down_prot = null;
    protected ProtocolStack stack = null;
    @Property(description="Determines whether to collect statistics (and expose them via JMX). Default is true", writable=true)
    protected boolean stats = true;
    @Property(description="Enables ergonomics: dynamically find the best values for properties at runtime")
    protected boolean ergonomics = true;
    @Property(name="name", description="Give the protocol a different name if needed so we can have multiple instances of it in the same stack (also change ID)", writable=false)
    protected String name = this.getClass().getSimpleName();
    @Property(description="Give the protocol a different ID if needed so we can have multiple instances of it in the same stack", writable=false)
    protected short id = ClassConfigurator.getProtocolId(this.getClass());
    protected final Log log = LogFactory.getLog(this.getClass());

    @Property(name="level", description="Sets the logger level (see javadocs)")
    public void setLevel(String level) {
        this.log.setLevel(level);
    }

    public String getLevel() {
        return this.log.getLevel();
    }

    public boolean isErgonomics() {
        return this.ergonomics;
    }

    public void setErgonomics(boolean ergonomics) {
        this.ergonomics = ergonomics;
    }

    protected boolean setProperties(Properties props) {
        throw new UnsupportedOperationException("deprecated; use a setter instead");
    }

    public void setProperty(String key, String val) {
        throw new UnsupportedOperationException("deprecated; use a setter instead");
    }

    public boolean setPropertiesInternal(Properties props) {
        throw new UnsupportedOperationException("use a setter instead");
    }

    public Object getValue(String name) {
        if (name == null) {
            return null;
        }
        Field field = Util.getField(this.getClass(), name);
        if (field == null) {
            throw new IllegalArgumentException("field \"" + name + "\n not found");
        }
        return Configurator.getField(field, this);
    }

    public Protocol setValues(Map<String, Object> values) {
        if (values == null) {
            return this;
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String attrname = entry.getKey();
            Object value = entry.getValue();
            Field field = Util.getField(this.getClass(), attrname);
            if (field == null) continue;
            Configurator.setField(field, this, value);
        }
        return this;
    }

    public Protocol setValue(String name, Object value) {
        if (name == null || value == null) {
            return this;
        }
        Field field = Util.getField(this.getClass(), name);
        if (field == null) {
            throw new IllegalArgumentException("field \"" + name + "\n not found");
        }
        Configurator.setField(field, this, value);
        return this;
    }

    public Properties getProperties() {
        if (this.log.isWarnEnabled()) {
            this.log.warn("deprecated feature: please use a setter instead");
        }
        return new Properties();
    }

    public ProtocolStack getProtocolStack() {
        return this.stack;
    }

    protected List<Object> getConfigurableObjects() {
        return null;
    }

    protected TP getTransport() {
        Protocol retval = this;
        while (retval != null && retval.down_prot != null) {
            retval = retval.down_prot;
        }
        return (TP)retval;
    }

    public ThreadFactory getThreadFactory() {
        return this.down_prot != null ? this.down_prot.getThreadFactory() : null;
    }

    public SocketFactory getSocketFactory() {
        return this.down_prot != null ? this.down_prot.getSocketFactory() : null;
    }

    public void setSocketFactory(SocketFactory factory) {
        if (this.down_prot != null) {
            this.down_prot.setSocketFactory(factory);
        }
    }

    public boolean upThreadEnabled() {
        return false;
    }

    public boolean downThreadEnabled() {
        return false;
    }

    public boolean statsEnabled() {
        return this.stats;
    }

    public void enableStats(boolean flag) {
        this.stats = flag;
    }

    public void resetStats() {
    }

    public String printStats() {
        return null;
    }

    public Map<String, Object> dumpStats() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods;
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(ManagedAttribute.class) && (!field.isAnnotationPresent(Property.class) || !field.getAnnotation(Property.class).exposeAsManagedAttribute())) continue;
                String attributeName = field.getName();
                try {
                    field.setAccessible(true);
                    Object value = field.get(this);
                    map.put(attributeName, value != null ? value.toString() : null);
                }
                catch (Exception e) {
                    this.log.warn("Could not retrieve value of attribute (field) " + attributeName, e);
                }
            }
            for (Method method : methods = this.getClass().getMethods()) {
                if (!method.isAnnotationPresent(ManagedAttribute.class) && (!method.isAnnotationPresent(Property.class) || !method.getAnnotation(Property.class).exposeAsManagedAttribute())) continue;
                String method_name = method.getName();
                if (method_name.startsWith("is") || method_name.startsWith("get")) {
                    try {
                        Object value = method.invoke((Object)this, new Object[0]);
                        String attributeName = Util.methodNameToAttributeName(method_name);
                        map.put(attributeName, value != null ? value.toString() : null);
                    }
                    catch (Exception e) {
                        this.log.warn("Could not retrieve value of attribute (method) " + method_name, e);
                    }
                    continue;
                }
                if (!method_name.startsWith("set")) continue;
                String stem = method_name.substring(3);
                Method getter = ResourceDMBean.findGetter(this.getClass(), stem);
                if (getter == null) continue;
                try {
                    Object value = getter.invoke((Object)this, new Object[0]);
                    String attributeName = Util.methodNameToAttributeName(method_name);
                    map.put(attributeName, value != null ? value.toString() : null);
                }
                catch (Exception e) {
                    this.log.warn("Could not retrieve value of attribute (method) " + method_name, e);
                }
            }
        }
        return map;
    }

    public void init() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public Vector<Integer> requiredUpServices() {
        return null;
    }

    public Vector<Integer> requiredDownServices() {
        return null;
    }

    public Vector<Integer> providedUpServices() {
        return null;
    }

    public Vector<Integer> providedDownServices() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public short getId() {
        return this.id;
    }

    public void setId(short id) {
        this.id = id;
    }

    public Protocol getUpProtocol() {
        return this.up_prot;
    }

    public Protocol getDownProtocol() {
        return this.down_prot;
    }

    public void setUpProtocol(Protocol up_prot) {
        this.up_prot = up_prot;
    }

    public void setDownProtocol(Protocol down_prot) {
        this.down_prot = down_prot;
    }

    public void setProtocolStack(ProtocolStack stack) {
        this.stack = stack;
    }

    public Object up(Event evt) {
        return this.up_prot.up(evt);
    }

    public Object down(Event evt) {
        return this.down_prot.down(evt);
    }
}

