/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.mail.internal.factory;

import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.util.JNDIUtils;
import org.ow2.jonas.lib.util.PropDump;
import org.ow2.jonas.mail.MailService;
import org.ow2.jonas.mail.internal.factory.AbstractJavaMail;
import org.ow2.jonas.mail.internal.factory.JavaMailSessionFactory;

public class JavaMailSession
extends AbstractJavaMail {
    private static final String FACTORY_TYPE = "javax.mail.Session";

    public JavaMailSession(String factoryName, String name, Properties mailProperties, MailService mailService) {
        super(factoryName, name, mailProperties, mailService);
    }

    public String getType() {
        return FACTORY_TYPE;
    }

    public Reference getReference() throws NamingException {
        byte[] bytes;
        Reference reference = new Reference(FACTORY_TYPE, JavaMailSessionFactory.class.getName(), null);
        if (JavaMailSession.getLogger().isLoggable(BasicLevel.DEBUG)) {
            PropDump.print((String)"Here are these properties:", (Properties)this.getMailSessionProperties(), (Logger)JavaMailSession.getLogger(), (int)BasicLevel.DEBUG);
        }
        if ((bytes = JNDIUtils.getBytesFromObject((Object)this.getMailSessionProperties())) != null) {
            reference.add(new BinaryRefAddr("javaxmailSession.properties", bytes));
        }
        if ((bytes = JNDIUtils.getBytesFromObject((Object)this.getAuthenticationProperties())) != null) {
            reference.add(new BinaryRefAddr("authentication.properties", bytes));
        }
        return reference;
    }
}

