/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.ow2.jonas.discovery.base.comm.DiscEvent;
import org.ow2.jonas.discovery.base.comm.DiscGreeting;
import org.ow2.jonas.discovery.base.comm.DiscMessage;

public class DiscHelper {
    private static int DISC_MESSAGE = 0;
    private static int DISC_EVENT = 1;
    private static int DISC_GREETING = 2;

    public static byte[] objectToBytes(Object obj) throws IOException {
        byte[] resultBytes = null;
        if (!(obj instanceof DiscMessage)) {
            return null;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(byteStream);
        try {
            if (obj instanceof DiscEvent) {
                stream.writeInt(DISC_EVENT);
            } else if (obj instanceof DiscGreeting) {
                stream.writeInt(DISC_GREETING);
            } else {
                stream.writeInt(DISC_MESSAGE);
            }
            stream.writeObject(obj);
            resultBytes = byteStream.toByteArray();
            byteStream.close();
            stream.close();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            byteStream.close();
            stream.close();
        }
        return resultBytes;
    }

    public static Object bytesToObject(byte[] bytes) throws IOException, ClassNotFoundException {
        DiscMessage resultObject = null;
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        ObjectInputStream stream = null;
        try {
            stream = new ObjectInputStream(byteStream);
            int type = stream.readInt();
            if (type == DISC_MESSAGE) {
                resultObject = (DiscMessage)stream.readObject();
            } else if (type == DISC_EVENT) {
                resultObject = (DiscEvent)stream.readObject();
            } else if (type == DISC_GREETING) {
                resultObject = (DiscGreeting)stream.readObject();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        finally {
            byteStream.close();
            stream.close();
        }
        return resultObject;
    }
}

