/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.ExtensionManagerImpl;
import org.apache.cxf.bus.spring.OldSpringSupport;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.springframework.beans.Mergeable;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanLocator
implements ConfiguredBeanLocator {
    private static final Logger LOG = LogUtils.getL7dLogger(SpringBeanLocator.class);
    ApplicationContext context;
    ConfiguredBeanLocator orig;
    Set<String> passThroughs = new HashSet<String>();
    Object bundleContext;
    boolean osgi = true;

    public SpringBeanLocator(ApplicationContext ctx) {
        this(ctx, null);
    }

    public SpringBeanLocator(ApplicationContext ctx, Bus bus) {
        this.context = ctx;
        if (bus != null) {
            this.orig = bus.getExtension(ConfiguredBeanLocator.class);
            if (this.orig instanceof ExtensionManagerImpl) {
                ArrayList<String> names = new ArrayList<String>();
                for (String s : ctx.getBeanDefinitionNames()) {
                    ConfigurableApplicationContext ctxt = (ConfigurableApplicationContext)this.context;
                    BeanDefinition def = ctxt.getBeanFactory().getBeanDefinition(s);
                    String cn = def.getBeanClassName();
                    if (OldSpringSupport.class.getName().equals(cn)) {
                        this.passThroughs.add(s);
                        for (String s2 : ctx.getAliases(s)) {
                            this.passThroughs.add(s2);
                        }
                        continue;
                    }
                    names.add(s);
                    for (String s2 : ctx.getAliases(s)) {
                        names.add(s2);
                    }
                }
                ((ExtensionManagerImpl)this.orig).removeBeansOfNames(names);
            }
        }
        this.loadOSGIContext(bus);
    }

    private void loadOSGIContext(Bus b) {
        try {
            Method m = this.context.getClass().getMethod("getBundleContext", new Class[0]);
            this.bundleContext = m.invoke((Object)this.context, new Object[0]);
            if (b != null) {
                Class<?> cls = m.getReturnType();
                b.setExtension(this.bundleContext, cls);
            }
        }
        catch (Throwable t) {
            this.osgi = false;
        }
    }

    @Override
    public <T> T getBeanOfType(String name, Class<T> type) {
        Object t = null;
        try {
            t = this.context.getBean(name, type);
        }
        catch (NoSuchBeanDefinitionException nsbde) {
            // empty catch block
        }
        if (t == null) {
            t = this.orig.getBeanOfType(name, type);
        }
        return (T)t;
    }

    @Override
    public List<String> getBeanNamesOfType(Class<?> type) {
        LinkedHashSet<String> s = new LinkedHashSet<String>(Arrays.asList(this.context.getBeanNamesForType(type, false, false)));
        s.removeAll(this.passThroughs);
        s.addAll(this.orig.getBeanNamesOfType(type));
        return new ArrayList<String>(s);
    }

    @Override
    public <T> Collection<? extends T> getBeansOfType(Class<T> type) {
        LinkedHashSet<String> s = new LinkedHashSet<String>(Arrays.asList(this.context.getBeanNamesForType(type, false, false)));
        s.removeAll(this.passThroughs);
        LinkedList<Object> lst = new LinkedList<Object>();
        for (String n : s) {
            lst.add(this.context.getBean(n, type));
        }
        lst.addAll(this.orig.getBeansOfType(type));
        if (lst.isEmpty()) {
            this.tryOSGI(lst, type);
        }
        return lst;
    }

    private <T> void tryOSGI(Collection<T> lst, Class<T> type) {
        if (!this.osgi) {
            return;
        }
        try {
            Class<?> contextClass = this.findContextClass(this.bundleContext.getClass());
            Method m = contextClass.getMethod("getServiceReference", String.class);
            ReflectionUtil.setAccessible(m);
            Object o = m.invoke(this.bundleContext, type.getName());
            if (o != null) {
                m = contextClass.getMethod("getService", m.getReturnType());
                ReflectionUtil.setAccessible(m);
                o = m.invoke(this.bundleContext, o);
                lst.add(type.cast(o));
            }
        }
        catch (NoSuchMethodException e) {
            this.osgi = false;
        }
        catch (Throwable e) {
            LOG.log(Level.WARNING, "Could not get service for " + type.getName(), e);
        }
    }

    private Class<?> findContextClass(Class<?> cls) {
        for (Class<?> c : cls.getInterfaces()) {
            if (!c.getName().equals("org.osgi.framework.BundleContext")) continue;
            return c;
        }
        for (Class<?> c : cls.getInterfaces()) {
            Class<?> c2 = this.findContextClass(c);
            if (c2 == null) continue;
            return c2;
        }
        Class<?> c2 = this.findContextClass(cls.getSuperclass());
        if (c2 != null) {
            return c2;
        }
        return cls;
    }

    @Override
    public <T> boolean loadBeansOfType(Class<T> type, ConfiguredBeanLocator.BeanLoaderListener<T> listener) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.context.getBeanNamesForType(type, false, false)));
        list.removeAll(this.passThroughs);
        Collections.reverse(list);
        boolean loaded = false;
        for (String s : list) {
            Class beanType;
            Class<T> t;
            if (!listener.loadBean(s, t = (beanType = this.context.getType(s)).asSubclass(type))) continue;
            Object o = this.context.getBean(s);
            if (listener.beanLoaded(s, type.cast(o))) {
                return true;
            }
            loaded = true;
        }
        return loaded || this.orig.loadBeansOfType(type, listener);
    }

    @Override
    public boolean hasConfiguredPropertyValue(String beanName, String propertyName, String searchValue) {
        if (this.context.containsBean(beanName) && !this.passThroughs.contains(beanName)) {
            ConfigurableApplicationContext ctxt = (ConfigurableApplicationContext)this.context;
            BeanDefinition def = ctxt.getBeanFactory().getBeanDefinition(beanName);
            if (!ctxt.getBeanFactory().isSingleton(beanName) || def.isAbstract()) {
                return false;
            }
            Collection ids = null;
            PropertyValue pv = def.getPropertyValues().getPropertyValue(propertyName);
            if (pv != null) {
                Object value = pv.getValue();
                if (!(value instanceof Collection)) {
                    throw new RuntimeException("The property " + propertyName + " must be a collection!");
                }
                if (value instanceof Mergeable) {
                    if (!((Mergeable)value).isMergeEnabled()) {
                        ids = (Collection)value;
                    }
                } else {
                    ids = (Collection)value;
                }
            }
            if (ids != null) {
                for (Object o : ids) {
                    if (!(o instanceof TypedStringValue ? searchValue.equals(((TypedStringValue)o).getValue()) : searchValue.equals(o))) continue;
                    return true;
                }
            }
        }
        return this.orig.hasConfiguredPropertyValue(beanName, propertyName, searchValue);
    }

    public <T> List<T> getOSGiServices(Class<T> type) {
        ArrayList<T> lst = new ArrayList<T>();
        if (!this.osgi) {
            return lst;
        }
        Class<?> contextClass = this.findContextClass(this.bundleContext.getClass());
        try {
            Method m = contextClass.getMethod("getServiceReference", String.class);
            Class<?> servRefClass = m.getReturnType();
            m = contextClass.getMethod("getServiceReferences", String.class, String.class);
            Object o = ReflectionUtil.setAccessible(m).invoke(this.bundleContext, type.getName(), null);
            if (o != null) {
                m = contextClass.getMethod("getService", servRefClass);
                ReflectionUtil.setAccessible(m);
                for (int x = 0; x < Array.getLength(o); ++x) {
                    Object ref = Array.get(o, x);
                    Object o2 = m.invoke(this.bundleContext, ref);
                    if (o2 == null) continue;
                    lst.add(type.cast(o2));
                }
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOG.log(Level.FINE, "Could not get services for " + type.getName(), e);
        }
        return lst;
    }

    @Override
    public boolean hasBeanOfName(String name) {
        if (this.context.containsBean(name)) {
            return true;
        }
        return this.orig.hasBeanOfName(name);
    }
}

