/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.ClientWebApplicationException;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.LocalClientState;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.client.ServerWebApplicationException;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxyImpl
extends AbstractClient
implements InvocationHandlerAware,
InvocationHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(ClientProxyImpl.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ClientProxyImpl.class);
    private static final String SLASH = "/";
    private ClassResourceInfo cri;
    private ClassLoader proxyLoader;
    private boolean inheritHeaders;
    private boolean isRoot;
    private Map<String, Object> valuesMap = Collections.emptyMap();

    public ClientProxyImpl(URI baseURI, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, Object ... varValues) {
        this(new LocalClientState(baseURI), loader, cri, isRoot, inheritHeaders, varValues);
    }

    public ClientProxyImpl(ClientState initialState, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, Object ... varValues) {
        super(initialState);
        this.proxyLoader = loader;
        this.cri = cri;
        this.isRoot = isRoot;
        this.inheritHeaders = inheritHeaders;
        this.initValuesMap(varValues);
    }

    private void initValuesMap(Object ... varValues) {
        if (this.isRoot) {
            List<String> vars = this.cri.getURITemplate().getVariables();
            this.valuesMap = new LinkedHashMap<String, Object>();
            for (int i = 0; i < vars.size(); ++i) {
                if (varValues.length > 0) {
                    if (i < varValues.length) {
                        this.valuesMap.put(vars.get(i), varValues[i]);
                        continue;
                    }
                    org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("ROOT_VARS_MISMATCH", BUNDLE, vars.size(), varValues.length);
                    LOG.info(msg.toString());
                    break;
                }
                this.valuesMap.put(vars.get(i), "");
            }
        }
    }

    @Override
    public Object invoke(Object o, Method m, Object[] params) throws Throwable {
        Class<?> declaringClass = m.getDeclaringClass();
        if (Client.class == declaringClass || InvocationHandlerAware.class == declaringClass || Object.class == declaringClass) {
            return m.invoke((Object)this, params);
        }
        this.resetResponse();
        OperationResourceInfo ori = this.cri.getMethodDispatcher().getOperationResourceInfo(m);
        if (ori == null) {
            ClientProxyImpl.reportInvalidResourceMethod(m, "INVALID_RESOURCE_METHOD");
        }
        MultivaluedMap<ParameterType, Parameter> types = ClientProxyImpl.getParametersInfo(params, ori);
        List<Object> pathParams = this.getPathParamValues(types, params, ori);
        int bodyIndex = ClientProxyImpl.getBodyIndex(types, ori);
        UriBuilder builder = this.getCurrentBuilder().clone();
        if (this.isRoot) {
            this.addNonEmptyPath(builder, ori.getClassResourceInfo().getURITemplate().getValue());
        }
        this.addNonEmptyPath(builder, ori.getURITemplate().getValue());
        ClientProxyImpl.handleMatrixes(types, params, builder);
        ClientProxyImpl.handleQueries(types, params, builder);
        URI uri = builder.buildFromEncoded(pathParams.toArray()).normalize();
        MultivaluedMap<String, String> headers = this.getHeaders();
        MetadataMap<String, String> paramHeaders = new MetadataMap<String, String>();
        this.handleHeaders(paramHeaders, types, params);
        this.handleCookies(paramHeaders, types, params);
        if (ori.isSubResourceLocator()) {
            ClassResourceInfo subCri = this.cri.getSubResource(m.getReturnType(), m.getReturnType());
            if (subCri == null) {
                ClientProxyImpl.reportInvalidResourceMethod(m, "INVALID_SUBRESOURCE");
            }
            MetadataMap<String, String> subHeaders = paramHeaders;
            if (this.inheritHeaders) {
                subHeaders.putAll((Map)headers);
            }
            ClientState newState = this.getState().newState(uri, subHeaders, this.getTemplateParametersMap(ori.getURITemplate(), pathParams));
            ClientProxyImpl proxyImpl = new ClientProxyImpl(newState, this.proxyLoader, subCri, false, this.inheritHeaders, new Object[0]);
            proxyImpl.setConfiguration(this.getConfiguration());
            return JAXRSClientFactory.createProxy(m.getReturnType(), this.proxyLoader, proxyImpl);
        }
        headers.putAll(paramHeaders);
        this.setRequestHeaders(headers, ori, types.containsKey((Object)ParameterType.FORM), bodyIndex == -1 ? null : params[bodyIndex].getClass(), m.getReturnType());
        this.getState().setTemplates(this.getTemplateParametersMap(ori.getURITemplate(), pathParams));
        Object body = null;
        if (bodyIndex != -1) {
            body = params[bodyIndex];
        } else if (types.containsKey((Object)ParameterType.FORM)) {
            body = this.handleForm(types, params);
        } else if (types.containsKey((Object)ParameterType.REQUEST_BODY)) {
            body = this.handleMultipart(types, ori, params);
        }
        return this.doChainedInvocation(uri, headers, ori, body, bodyIndex, null, null);
    }

    private void addNonEmptyPath(UriBuilder builder, String pathValue) {
        if (!SLASH.equals(pathValue)) {
            builder.path(pathValue);
        }
    }

    private static MultivaluedMap<ParameterType, Parameter> getParametersInfo(Object[] params, OperationResourceInfo ori) {
        MetadataMap<ParameterType, Parameter> map = new MetadataMap<ParameterType, Parameter>();
        List<Parameter> parameters = ori.getParameters();
        if (parameters.size() == 0) {
            return map;
        }
        int requestBodyParam = 0;
        int multipartParam = 0;
        for (Parameter p : parameters) {
            if (p.getType() == ParameterType.CONTEXT) continue;
            if (p.getType() == ParameterType.REQUEST_BODY) {
                ++requestBodyParam;
                if (ClientProxyImpl.getMultipart(ori, p.getIndex()) != null) {
                    ++multipartParam;
                }
            }
            map.add((Object)p.getType(), p);
        }
        if (map.containsKey((Object)ParameterType.REQUEST_BODY)) {
            if (requestBodyParam > 1 && requestBodyParam != multipartParam) {
                ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "SINGLE_BODY_ONLY");
            }
            if (map.containsKey((Object)ParameterType.FORM)) {
                ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "ONLY_FORM_ALLOWED");
            }
        }
        return map;
    }

    private static int getBodyIndex(MultivaluedMap<ParameterType, Parameter> map, OperationResourceInfo ori) {
        int index;
        List list = (List)map.get((Object)ParameterType.REQUEST_BODY);
        int n = index = list == null || list.size() > 1 ? -1 : ((Parameter)list.get(0)).getIndex();
        if (ori.isSubResourceLocator() && index != -1) {
            ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "NO_BODY_IN_SUBRESOURCE");
        }
        return index;
    }

    private void checkResponse(Method m, Response r, Message inMessage) throws Throwable {
        ServerWebApplicationException t = null;
        int status = r.getStatus();
        if (status >= 400) {
            if (m.getReturnType() == Response.class && m.getExceptionTypes().length == 0) {
                return;
            }
            ResponseExceptionMapper<?> mapper = ClientProxyImpl.findExceptionMapper(m, inMessage);
            if (mapper != null && (t = (ServerWebApplicationException)((Object)mapper.fromResponse(r))) != null) {
                throw t;
            }
            if (t == null) {
                t = new ServerWebApplicationException(r);
            }
            if (inMessage.getExchange().get(Message.RESPONSE_CODE) == null) {
                throw t;
            }
            Endpoint ep = inMessage.getExchange().get(Endpoint.class);
            inMessage.getExchange().put(InterceptorProvider.class, this.getConfiguration());
            inMessage.setContent(Exception.class, new Fault((Throwable)((Object)t)));
            inMessage.getInterceptorChain().abort();
            if (ep.getInFaultObserver() != null) {
                ep.getInFaultObserver().onMessage(inMessage);
            }
            throw t;
        }
    }

    private static ResponseExceptionMapper<?> findExceptionMapper(Method m, Message message) {
        ProviderFactory pf = ProviderFactory.getInstance(message);
        for (Class<?> exType : m.getExceptionTypes()) {
            ResponseExceptionMapper mapper = pf.createResponseExceptionMapper(exType);
            if (mapper == null) continue;
            return mapper;
        }
        return null;
    }

    private MultivaluedMap<String, String> setRequestHeaders(MultivaluedMap<String, String> headers, OperationResourceInfo ori, boolean formParams, Class<?> bodyClass, Class<?> responseClass) {
        List<MediaType> accepts;
        if (headers.getFirst((Object)"Content-Type") == null) {
            if (formParams || bodyClass != null && MultivaluedMap.class.isAssignableFrom(bodyClass)) {
                headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
            } else {
                String cType = ori.getConsumeTypes().isEmpty() || ori.getConsumeTypes().get(0).equals((Object)MediaType.WILDCARD_TYPE) ? "application/xml" : ori.getConsumeTypes().get(0).toString();
                headers.putSingle((Object)"Content-Type", (Object)cType);
            }
        }
        if ((accepts = this.getAccept(headers)) == null) {
            boolean produceWildcard;
            boolean bl = produceWildcard = ori.getProduceTypes().size() == 0 || ori.getProduceTypes().get(0).equals((Object)MediaType.WILDCARD_TYPE);
            accepts = produceWildcard ? (InjectionUtils.isPrimitive(responseClass) ? Collections.singletonList(MediaType.TEXT_PLAIN_TYPE) : Collections.singletonList(MediaType.APPLICATION_XML_TYPE)) : (responseClass == Void.class ? Collections.singletonList(MediaType.WILDCARD_TYPE) : ori.getProduceTypes());
            for (MediaType mt : accepts) {
                headers.add((Object)"Accept", (Object)mt.toString());
            }
        }
        return headers;
    }

    private List<MediaType> getAccept(MultivaluedMap<String, String> allHeaders) {
        List headers = (List)allHeaders.get((Object)"Accept");
        if (headers == null || headers.size() == 0) {
            return null;
        }
        ArrayList<MediaType> types = new ArrayList<MediaType>();
        for (String s : headers) {
            types.add(MediaType.valueOf((String)s));
        }
        return types;
    }

    private List<Object> getPathParamValues(MultivaluedMap<ParameterType, Parameter> map, Object[] params, OperationResourceInfo ori) {
        LinkedList<Object> list = new LinkedList<Object>();
        if (this.isRoot) {
            list.addAll(this.valuesMap.values());
        }
        List<String> methodVars = ori.getURITemplate().getVariables();
        List<Parameter> paramsList = ClientProxyImpl.getParameters(map, ParameterType.PATH);
        LinkedHashMap<String, Parameter> paramsMap = new LinkedHashMap<String, Parameter>();
        for (Parameter p : paramsList) {
            if (p.getName().length() == 0) {
                MultivaluedMap<String, Object> values = InjectionUtils.extractValuesFromBean(params[p.getIndex()], "");
                for (String var : methodVars) {
                    list.addAll((Collection)values.get((Object)var));
                }
                continue;
            }
            paramsMap.put(p.getName(), p);
        }
        for (String varName : methodVars) {
            Parameter p = (Parameter)paramsMap.remove(varName);
            if (p == null) continue;
            list.add(params[p.getIndex()]);
        }
        block3: for (Parameter p : paramsMap.values()) {
            if (!this.valuesMap.containsKey(p.getName())) continue;
            int index = 0;
            Iterator<String> it = this.valuesMap.keySet().iterator();
            while (it.hasNext()) {
                if (it.next().equals(p.getName()) && index < list.size()) {
                    list.remove(index);
                    list.add(index, params[p.getIndex()]);
                    continue block3;
                }
                ++index;
            }
        }
        return list;
    }

    private static List<Parameter> getParameters(MultivaluedMap<ParameterType, Parameter> map, ParameterType key) {
        return map.get((Object)key) == null ? Collections.EMPTY_LIST : (List)map.get((Object)key);
    }

    private static void handleQueries(MultivaluedMap<ParameterType, Parameter> map, Object[] params, UriBuilder ub) {
        List<Parameter> qs = ClientProxyImpl.getParameters(map, ParameterType.QUERY);
        for (Parameter p : qs) {
            if (params[p.getIndex()] == null) continue;
            ClientProxyImpl.addParametersToBuilder(ub, p.getName(), params[p.getIndex()], ParameterType.QUERY);
        }
    }

    private static void handleMatrixes(MultivaluedMap<ParameterType, Parameter> map, Object[] params, UriBuilder ub) {
        List<Parameter> mx = ClientProxyImpl.getParameters(map, ParameterType.MATRIX);
        for (Parameter p : mx) {
            if (params[p.getIndex()] == null) continue;
            ClientProxyImpl.addParametersToBuilder(ub, p.getName(), params[p.getIndex()], ParameterType.MATRIX);
        }
    }

    private MultivaluedMap<String, String> handleForm(MultivaluedMap<ParameterType, Parameter> map, Object[] params) {
        MetadataMap<String, String> form = new MetadataMap<String, String>();
        List<Parameter> fm = ClientProxyImpl.getParameters(map, ParameterType.FORM);
        for (Parameter p : fm) {
            Object pValue = params[p.getIndex()];
            if (pValue == null) continue;
            if (InjectionUtils.isSupportedCollectionOrArray(pValue.getClass())) {
                List<Object> c = pValue.getClass().isArray() ? Arrays.asList((Object[])pValue) : (List<Object>)pValue;
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    FormUtils.addPropertyToForm(form, p.getName(), it.next());
                }
                continue;
            }
            FormUtils.addPropertyToForm(form, p.getName(), pValue);
        }
        return form;
    }

    private List<Attachment> handleMultipart(MultivaluedMap<ParameterType, Parameter> map, OperationResourceInfo ori, Object[] params) {
        LinkedList<Attachment> atts = new LinkedList<Attachment>();
        List<Parameter> fm = ClientProxyImpl.getParameters(map, ParameterType.REQUEST_BODY);
        for (Parameter p : fm) {
            Multipart part = ClientProxyImpl.getMultipart(ori, p.getIndex());
            if (part == null) continue;
            atts.add(new Attachment(part.value(), part.type(), params[p.getIndex()]));
        }
        return atts;
    }

    private void handleHeaders(MultivaluedMap<String, String> headers, MultivaluedMap<ParameterType, Parameter> map, Object[] params) {
        List<Parameter> hs = ClientProxyImpl.getParameters(map, ParameterType.HEADER);
        for (Parameter p : hs) {
            if (params[p.getIndex()] == null) continue;
            headers.add((Object)p.getName(), (Object)params[p.getIndex()].toString());
        }
    }

    private static Multipart getMultipart(OperationResourceInfo ori, int index) {
        Method aMethod = ori.getAnnotatedMethod();
        return aMethod != null ? AnnotationUtils.getAnnotation(aMethod.getParameterAnnotations()[index], Multipart.class) : null;
    }

    private void handleCookies(MultivaluedMap<String, String> headers, MultivaluedMap<ParameterType, Parameter> map, Object[] params) {
        List<Parameter> cs = ClientProxyImpl.getParameters(map, ParameterType.COOKIE);
        for (Parameter p : cs) {
            if (params[p.getIndex()] == null) continue;
            headers.add((Object)"Cookie", (Object)(p.getName() + '=' + params[p.getIndex()].toString()));
        }
    }

    private Object doChainedInvocation(URI uri, MultivaluedMap<String, String> headers, OperationResourceInfo ori, Object body, int bodyIndex, Exchange exchange, Map<String, Object> invocationContext) throws Throwable {
        Message outMessage = this.createMessage(body, ori.getHttpMethod(), headers, uri, exchange, invocationContext, true);
        outMessage.getExchange().setOneWay(ori.isOneway());
        outMessage.setContent(OperationResourceInfo.class, ori);
        this.setPlainOperationNameProperty(outMessage, ori.getMethodToInvoke().getName());
        outMessage.getExchange().put(Method.class, ori.getMethodToInvoke());
        if (body != null) {
            outMessage.put("BODY_INDEX", bodyIndex);
            outMessage.getInterceptorChain().add(new BodyWriter());
        }
        Map<String, Object> reqContext = this.getRequestContext(outMessage);
        reqContext.put(OperationResourceInfo.class.getName(), ori);
        reqContext.put("BODY_INDEX", bodyIndex);
        try {
            outMessage.getInterceptorChain().doIntercept(outMessage);
        }
        catch (Exception ex) {
            outMessage.setContent(Exception.class, ex);
        }
        Object[] results = this.preProcessResult(outMessage);
        if (results != null && results.length == 1) {
            return results[0];
        }
        Object response = null;
        try {
            Object object = response = this.handleResponse(outMessage);
            return object;
        }
        catch (Exception ex) {
            response = ex;
            throw ex;
        }
        finally {
            this.completeExchange(response, outMessage.getExchange(), true);
        }
    }

    @Override
    protected Object retryInvoke(URI newRequestURI, MultivaluedMap<String, String> headers, Object body, Exchange exchange, Map<String, Object> invContext) throws Throwable {
        Map reqContext = CastUtils.cast((Map)invContext.get("RequestContext"));
        int bodyIndex = body != null ? (Integer)reqContext.get("BODY_INDEX") : -1;
        OperationResourceInfo ori = (OperationResourceInfo)reqContext.get(OperationResourceInfo.class.getName());
        return this.doChainedInvocation(newRequestURI, headers, ori, body, bodyIndex, exchange, invContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleResponse(Message outMessage) throws Throwable {
        try {
            Response r = this.setResponseBuilder(outMessage, outMessage.getExchange()).build();
            Method method = outMessage.getExchange().get(Method.class);
            this.checkResponse(method, r, outMessage);
            if (method.getReturnType() == Void.class) {
                Object var4_4 = null;
                return var4_4;
            }
            if (method.getReturnType() == Response.class && (r.getEntity() == null || InputStream.class.isAssignableFrom(r.getEntity().getClass()) && ((InputStream)r.getEntity()).available() == 0)) {
                Response response = r;
                return response;
            }
            Object obj = this.readBody(r, outMessage, method.getReturnType(), method.getGenericReturnType(), method.getDeclaredAnnotations());
            return obj;
        }
        finally {
            ProviderFactory.getInstance(outMessage).clearThreadLocalProxies();
        }
    }

    @Override
    public Object getInvocationHandler() {
        return this;
    }

    protected static void reportInvalidResourceMethod(Method m, String name) {
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(name, BUNDLE, m.getDeclaringClass().getName(), m.getName());
        LOG.severe(errorMsg.toString());
        throw new ClientWebApplicationException(errorMsg.toString());
    }

    private class BodyWriter
    extends AbstractOutDatabindingInterceptor {
        public BodyWriter() {
            super("write");
        }

        public void handleMessage(Message outMessage) throws Fault {
            OperationResourceInfo ori = outMessage.getContent(OperationResourceInfo.class);
            OutputStream os = outMessage.getContent(OutputStream.class);
            if (os == null && outMessage.getContent(XMLStreamWriter.class) == null || ori == null) {
                return;
            }
            MessageContentsList objs = MessageContentsList.getContentsList(outMessage);
            if (objs == null || objs.size() == 0) {
                return;
            }
            MultivaluedMap headers = (MultivaluedMap)outMessage.get(Message.PROTOCOL_HEADERS);
            Method method = ori.getMethodToInvoke();
            int bodyIndex = (Integer)outMessage.get("BODY_INDEX");
            Method aMethod = ori.getAnnotatedMethod();
            Annotation[] anns = aMethod == null || bodyIndex == -1 ? new Annotation[]{} : aMethod.getParameterAnnotations()[bodyIndex];
            Object body = objs.get(0);
            try {
                if (bodyIndex != -1) {
                    Class<?> paramClass = method.getParameterTypes()[bodyIndex];
                    Class<?> paramType = method.getGenericParameterTypes()[bodyIndex];
                    boolean isAssignable = paramClass.isAssignableFrom(body.getClass());
                    ClientProxyImpl.this.writeBody(body, outMessage, isAssignable ? paramClass : body.getClass(), isAssignable ? paramType : body.getClass(), anns, (MultivaluedMap<String, Object>)headers, os);
                } else {
                    ClientProxyImpl.this.writeBody(body, outMessage, body.getClass(), body.getClass(), anns, (MultivaluedMap<String, Object>)headers, os);
                }
            }
            catch (Exception ex) {
                throw new Fault(ex);
            }
        }
    }
}

